/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.workspace;

import java.io.IOException;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspaceBase;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public abstract class AbstractCDOWorkspaceBase
implements InternalCDOWorkspaceBase {
    private InternalCDOWorkspace workspace;
    private InternalStore store;
    private InternalCDOPackageRegistry packageRegistry;
    private InternalCDOBranchManager branchManager;

    protected AbstractCDOWorkspaceBase() {
    }

    public void init(InternalCDOWorkspace workspace) {
        this.workspace = workspace;
        InternalRepository localRepository = workspace.getLocalRepository();
        this.store = localRepository.getStore();
        this.packageRegistry = localRepository.getPackageRegistry(false);
        this.branchManager = localRepository.getBranchManager();
    }

    public InternalCDOWorkspace getWorkspace() {
        return this.workspace;
    }

    public void updateAfterCommit(CDOTransaction transaction) {
        InternalCDOTransaction tx = (InternalCDOTransaction)transaction;
        Set dirtyObjects = tx.getDirtyObjects().keySet();
        Set detachedObjects = tx.getDetachedObjects().keySet();
        for (InternalCDORevision revision : tx.getCleanRevisions().values()) {
            CDOID id = revision.getID();
            if (!dirtyObjects.contains(id) && !detachedObjects.contains(id)) continue;
            if (this.isAddedObject(id)) {
                this.deregisterObject(id);
                continue;
            }
            this.registerChangedOrDetachedObject(revision);
        }
        for (CDOObject object : tx.getNewObjects().values()) {
            this.registerAddedObject(object.cdoID());
        }
    }

    protected boolean isAddedObject(CDOID id) {
        return this.store.isLocal(id);
    }

    protected CDODataInput createCDODataInput(ExtendedDataInputStream edis) throws IOException {
        CDORevisionFactory revisionFactory = CDORevisionFactory.DEFAULT;
        CDOListFactory listFactory = CDOListFactory.DEFAULT;
        return CDOCommonUtil.createCDODataInput((ExtendedDataInputStream)edis, (CDOPackageRegistry)this.packageRegistry, (CDOBranchManager)this.branchManager, null, (CDORevisionFactory)revisionFactory, (CDOListFactory)listFactory, null);
    }

    protected CDODataOutput createCDODataOutput(ExtendedDataOutputStream edos) {
        CDOIDProvider idProvider = CDOIDProvider.NOOP;
        return CDOCommonUtil.createCDODataOutput((ExtendedDataOutput)edos, (CDOPackageRegistry)this.packageRegistry, (CDOIDProvider)idProvider);
    }

    protected abstract void registerChangedOrDetachedObject(InternalCDORevision var1);

    protected abstract void registerAddedObject(CDOID var1);

    protected abstract void deregisterObject(CDOID var1);
}

