/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.workspace;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.CDOServerBrowser;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspaceBase;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOSessionConfiguration;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOWorkspaceImpl
implements InternalCDOWorkspace {
    private static final String PROP_BRANCH_PATH = "org.eclipse.emf.cdo.workspace.branchPath";
    private static final String PROP_TIME_STAMP = "org.eclipse.emf.cdo.workspace.timeStamp";
    private static final String PROP_FIXED = "org.eclipse.emf.cdo.workspace.fixed";
    private IManagedContainer container;
    private InternalCDOWorkspaceBase base;
    private InternalRepository localRepository;
    private InternalCDOSession localSession;
    private CDOBranchPoint head;
    private String branchPath;
    private long timeStamp;
    private boolean fixed;
    private CDOSessionConfigurationFactory remoteSessionConfigurationFactory;
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();
    private CDOServerBrowser browser;

    public CDOWorkspaceImpl(IStore local, InternalCDOWorkspaceBase base, CDOSessionConfigurationFactory remote, String branchPath, long timeStamp) {
        this.init(local, base, remote);
        this.remoteSessionConfigurationFactory = remote;
        this.branchPath = StringUtil.isEmpty((String)branchPath) ? "MAIN" : branchPath;
        this.timeStamp = timeStamp;
        this.fixed = timeStamp != 0L;
        this.checkout();
        this.saveProperties();
    }

    public CDOWorkspaceImpl(IStore local, InternalCDOWorkspaceBase base, CDOSessionConfigurationFactory remote) {
        this.init(local, base, remote);
        this.loadProperties();
    }

    protected void init(IStore local, InternalCDOWorkspaceBase base, CDOSessionConfigurationFactory remote) {
        this.container = this.createContainer(local);
        this.remoteSessionConfigurationFactory = remote;
        this.localRepository = this.createLocalRepository(local);
        HashMap<String, InternalRepository> repositories = new HashMap<String, InternalRepository>();
        repositories.put(this.localRepository.getName(), this.localRepository);
        this.browser = new CDOServerBrowser(repositories);
        this.browser.setPort(7779);
        this.browser.activate();
        this.base = base;
        this.base.init(this);
    }

    protected void checkout() {
        Monitor monitor = new Monitor();
        final IStoreAccessor.Raw accessor = (IStoreAccessor.Raw)this.localRepository.getStore().getWriter(null);
        StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
        try {
            InternalCDOSession remoteSession = this.openRemoteSession();
            try {
                this.localRepository.setRootResourceID(remoteSession.getRepositoryInfo().getRootResourceID());
                InternalCDOPackageUnit[] packageUnits = remoteSession.getPackageRegistry().getPackageUnits(false);
                this.localRepository.getPackageRegistry(false).putPackageUnits(packageUnits, CDOPackageUnit.State.LOADED);
                accessor.rawStore(packageUnits, (OMMonitor)monitor);
                CDORevisionHandler handler = new CDORevisionHandler((OMMonitor)monitor){
                    private final /* synthetic */ OMMonitor val$monitor;
                    {
                        this.val$monitor = oMMonitor;
                    }

                    public boolean handleRevision(CDORevision revision) {
                        InternalCDORevision rev = (InternalCDORevision)revision;
                        accessor.rawStore(rev, this.val$monitor);
                        long commitTime = revision.getTimeStamp();
                        if (commitTime > CDOWorkspaceImpl.this.timeStamp) {
                            CDOWorkspaceImpl.this.timeStamp = commitTime;
                        }
                        return true;
                    }
                };
                InternalCDOBranch branch = remoteSession.getBranchManager().getBranch(this.branchPath);
                remoteSession.getSessionProtocol().handleRevisions(null, (CDOBranch)branch, false, this.timeStamp, false, handler);
            }
            finally {
                LifecycleUtil.deactivate((Object)remoteSession);
            }
            accessor.rawCommit(1.0, (OMMonitor)monitor);
        }
        finally {
            StoreThreadLocal.release();
            monitor.done();
        }
    }

    @Override
    public String getBranchPath() {
        return this.branchPath;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public InternalCDOWorkspaceBase getBase() {
        return this.base;
    }

    public InternalCDOView openView() {
        CDOView view = this.getLocalSession().openView();
        this.initView(view);
        return (InternalCDOView)view;
    }

    public InternalCDOView openView(ResourceSet resourceSet) {
        CDOView view = this.getLocalSession().openView(resourceSet);
        this.initView(view);
        return (InternalCDOView)view;
    }

    public InternalCDOTransaction openTransaction() {
        CDOTransaction transaction = this.getLocalSession().openTransaction();
        this.initView((CDOView)transaction);
        return (InternalCDOTransaction)transaction;
    }

    public InternalCDOTransaction openTransaction(ResourceSet resourceSet) {
        CDOTransaction transaction = this.getLocalSession().openTransaction(resourceSet);
        this.initView((CDOView)transaction);
        return (InternalCDOTransaction)transaction;
    }

    public InternalCDOTransaction update(CDOMerger merger) {
        return this.merge(merger, this.branchPath);
    }

    public InternalCDOTransaction merge(CDOMerger merger, String branchPath) {
        return this.merge(merger, branchPath, 0L);
    }

    public InternalCDOTransaction merge(CDOMerger merger, String branchPath, long timeStamp) {
        InternalCDOSession remoteSession = this.openRemoteSession();
        try {
            InternalCDOBranchManager branchManager = remoteSession.getBranchManager();
            CDOBranchPoint basePoint = branchManager.getBranch(branchPath).getPoint(this.timeStamp);
            CDOBranchPoint remotePoint = branchManager.getBranch(branchPath).getPoint(timeStamp);
            CDOBranchPointRange range = CDOBranchUtil.createRange((CDOBranchPoint)basePoint, (CDOBranchPoint)remotePoint);
            CDOChangeSetData remoteData = remoteSession.getSessionProtocol().loadChangeSets(new CDOBranchPointRange[]{range})[0];
            CDOChangeSetData localData = this.getLocalChanges();
            if (!localData.isEmpty()) {
                CDOChangeSet localChanges = CDORevisionUtil.createChangeSet((CDOBranchPoint)basePoint, null, (CDOChangeSetData)localData);
                CDOChangeSet remoteChanges = CDORevisionUtil.createChangeSet((CDOBranchPoint)basePoint, (CDOBranchPoint)remotePoint, (CDOChangeSetData)remoteData);
                remoteData = merger.merge(localChanges, remoteChanges);
            }
            InternalCDOTransaction transaction = this.openTransaction();
            transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler2(){

                public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                    CDOWorkspaceImpl.this.base.clear();
                }
            });
            transaction.applyChangeSetData(remoteData, new CDORevisionProvider(){

                public CDORevision getRevision(CDOID id) {
                    CDORevision revision = CDOWorkspaceImpl.this.base.getRevision(id);
                    if (revision == null) {
                        revision = CDOWorkspaceImpl.this.getRevision(id);
                    }
                    return revision;
                }
            }, (CDORevisionProvider)this, null);
            InternalCDOTransaction internalCDOTransaction = transaction;
            return internalCDOTransaction;
        }
        finally {
            LifecycleUtil.deactivate((Object)remoteSession);
        }
    }

    @Override
    public void revert() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replace(String branchPath, long timeStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOCommitInfo checkin() throws CommitException {
        return this.checkin(null);
    }

    @Override
    public CDOCommitInfo checkin(String comment) throws CommitException {
        InternalCDOSession remoteSession = this.openRemoteSession();
        try {
            InternalCDOBranch branch = remoteSession.getBranchManager().getBranch(this.branchPath);
            InternalCDOTransaction transaction = (InternalCDOTransaction)remoteSession.openTransaction((CDOBranch)branch);
            CDOChangeSetData changes = this.getLocalChanges();
            Pair mappedLocalIDs = (Pair)transaction.applyChangeSetData(changes, (CDORevisionProvider)this.base, (CDORevisionProvider)this, this.head).getElement2();
            CDOIDMapper idMapper = this.getIDMapper(transaction, (Pair<Map<CDOID, CDOID>, List<CDOID>>)mappedLocalIDs);
            transaction.setCommitComment(comment);
            CDOCommitInfo info = transaction.commit();
            if (idMapper != null) {
                this.adjustLocally(idMapper, (List)mappedLocalIDs.getElement2());
            }
            this.base.clear();
            this.timeStamp = info.getTimeStamp();
            this.saveProperties();
            CDOCommitInfo cDOCommitInfo = info;
            return cDOCommitInfo;
        }
        finally {
            LifecycleUtil.deactivate((Object)remoteSession);
        }
    }

    protected CDOIDMapper getIDMapper(InternalCDOTransaction transaction, Pair<Map<CDOID, CDOID>, List<CDOID>> mappedLocalIDs) {
        if (mappedLocalIDs == null) {
            return null;
        }
        final Map idMappings = (Map)mappedLocalIDs.getElement1();
        transaction.addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof CDOTransactionFinishedEvent) {
                    CDOTransactionFinishedEvent e = (CDOTransactionFinishedEvent)event;
                    Map remoteMappings = e.getIDMappings();
                    for (Map.Entry entry : idMappings.entrySet()) {
                        CDOID tempID = (CDOID)entry.getValue();
                        CDOID newID = (CDOID)remoteMappings.get(tempID);
                        entry.setValue(newID);
                    }
                }
            }
        });
        return new CDOIDMapper(idMappings);
    }

    protected void adjustLocally(CDOIDMapper idMapper, List<CDOID> adjustedObjects) {
        IStoreAccessor.Raw accessor = (IStoreAccessor.Raw)this.localRepository.getStore().getReader(null);
        Monitor monitor = new Monitor();
        for (Map.Entry entry : idMapper.getIDMappings().entrySet()) {
            CDOID id = (CDOID)entry.getKey();
            InternalCDORevision revision = accessor.readRevision(id, this.head, -1, null);
            accessor.rawDelete(revision.getID(), revision.getVersion(), revision.getBranch(), revision.getEClass(), (OMMonitor)monitor);
            CDOID newID = (CDOID)entry.getValue();
            revision.setID(newID);
            revision.setVersion(1);
            revision.adjustReferences((CDOReferenceAdjuster)idMapper);
            accessor.rawStore(revision, (OMMonitor)monitor);
        }
        for (CDOID id : adjustedObjects) {
            InternalCDORevision revision = accessor.readRevision(id, this.head, -1, null);
            accessor.rawDelete(revision.getID(), revision.getVersion(), revision.getBranch(), revision.getEClass(), (OMMonitor)monitor);
            revision.adjustReferences((CDOReferenceAdjuster)idMapper);
            accessor.rawStore(revision, (OMMonitor)monitor);
        }
        accessor.rawCommit(1.0, (OMMonitor)monitor);
    }

    protected InternalCDORevision adjustRevision(IStoreAccessor.Raw accessor, CDOID id, CDOIDMapper idMapper) {
        InternalCDORevision revision = accessor.readRevision(id, this.head, -1, null);
        CDOID newID = (CDOID)idMapper.getIDMappings().get(id);
        if (newID != null) {
            revision.setID(newID);
            revision.setVersion(1);
        }
        revision.adjustReferences((CDOReferenceAdjuster)idMapper);
        accessor.rawStore(revision, (OMMonitor)new Monitor());
        return revision;
    }

    @Override
    public CDOChangeSetData compare(String branchPath) {
        return this.compare(branchPath, 0L);
    }

    @Override
    public CDOChangeSetData compare(String branchPath, long timeStamp) {
        throw new UnsupportedOperationException();
    }

    public synchronized void close() {
        LifecycleUtil.deactivate((Object)this.browser);
        this.browser = null;
        LifecycleUtil.deactivate((Object)this.localSession);
        this.localSession = null;
        LifecycleUtil.deactivate((Object)this.localRepository);
        this.localRepository = null;
        LifecycleUtil.deactivate((Object)this.container);
        this.container = null;
    }

    public synchronized boolean isClosed() {
        return this.container == null;
    }

    public CDORevision getRevision(CDOID id) {
        InternalCDOSession session = this.getLocalSession();
        InternalCDORevisionManager revisionManager = session.getRevisionManager();
        return revisionManager.getRevision(id, this.head, -1, 0, true);
    }

    @Override
    public InternalRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public synchronized InternalCDOSession getLocalSession() {
        if (this.localSession == null) {
            this.localSession = this.openLocalSession();
        }
        return this.localSession;
    }

    @Override
    public CDOChangeSetData getLocalChanges() {
        Set<CDOID> ids = this.base.getIDs();
        return CDORevisionUtil.createChangeSetData(ids, (CDORevisionProvider)this.base, (CDORevisionProvider)this);
    }

    protected IManagedContainer createContainer(IStore local) {
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        JVMUtil.prepareContainer((IManagedContainer)container);
        CDONet4jServerUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        return container;
    }

    protected IManagedContainer getContainer() {
        return this.container;
    }

    protected String getLocalAcceptorName() {
        return "acceptor-for-" + this.localRepository.getUUID();
    }

    protected IJVMAcceptor getLocalAcceptor() {
        String localAcceptorName = this.getLocalAcceptorName();
        return JVMUtil.getAcceptor((IManagedContainer)this.container, (String)localAcceptorName);
    }

    protected IJVMConnector getLocalConnector() {
        String localAcceptorName = this.getLocalAcceptorName();
        return JVMUtil.getConnector((IManagedContainer)this.container, (String)localAcceptorName);
    }

    protected InternalRepository createLocalRepository(IStore store) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", "false");
        props.put("supportingBranches", "false");
        Repository.Default repository = new Repository.Default(){

            public void initMainBranch(InternalCDOBranchManager branchManager, long timeStamp) {
                branchManager.initMainBranch(true, timeStamp);
            }

            protected void initRootResource() {
                this.setState(CDOCommonRepository.State.INITIAL);
            }
        };
        repository.setName("local");
        repository.setStore((InternalStore)store);
        repository.setProperties(props);
        CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)repository);
        return repository;
    }

    protected InternalCDOSession openLocalSession() {
        this.getLocalAcceptor();
        IJVMConnector connector = this.getLocalConnector();
        String repositoryName = this.localRepository.getName();
        org.eclipse.emf.cdo.net4j.CDOSessionConfiguration configuration = CDONet4jUtil.createSessionConfiguration();
        configuration.setConnector((IConnector)connector);
        configuration.setRepositoryName(repositoryName);
        configuration.setRevisionManager(CDORevisionUtil.createRevisionManager((CDORevisionCache)CDORevisionCache.NOOP));
        ((InternalCDOSessionConfiguration)configuration).setMainBranchLocal(true);
        InternalCDOSession session = (InternalCDOSession)configuration.openSession();
        session.setPackageRegistry(this.localRepository.getPackageRegistry(false));
        this.head = session.getBranchManager().getMainBranch().getHead();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalCDOView[] getViews() {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.views.toArray(new InternalCDOView[this.views.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initView(CDOView view) {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            this.views.add((InternalCDOView)view);
        }
        view.addListener((IListener)new LifecycleEventAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onDeactivated(ILifecycle view) {
                Set set = CDOWorkspaceImpl.this.views;
                synchronized (set) {
                    CDOWorkspaceImpl.this.views.remove(view);
                }
            }
        });
        if (view instanceof CDOTransaction) {
            if (this.fixed) {
                throw new ReadOnlyException("Workspace is fixed");
            }
            CDOTransaction transaction = (CDOTransaction)view;
            transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler2(){

                public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                    CDOWorkspaceImpl.this.committedTransaction(transaction, commitContext);
                }
            });
        }
    }

    protected void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
        this.base.updateAfterCommit(transaction);
    }

    protected CDOSessionConfigurationFactory getRemoteSessionConfigurationFactory() {
        return this.remoteSessionConfigurationFactory;
    }

    protected InternalCDOSession openRemoteSession() {
        CDOSessionConfiguration configuration = this.remoteSessionConfigurationFactory.createSessionConfiguration();
        InternalCDOSession session = (InternalCDOSession)configuration.openSession();
        if (!session.getRepositoryInfo().isSupportingAudits()) {
            session.close();
            throw new IllegalStateException("Remote repository does not support auditing");
        }
        return session;
    }

    protected void saveProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROP_BRANCH_PATH, this.branchPath);
        props.put(PROP_TIME_STAMP, String.valueOf(this.timeStamp));
        props.put(PROP_FIXED, String.valueOf(this.fixed));
        this.localRepository.getStore().setPersistentProperties(props);
    }

    protected void loadProperties() {
        HashSet<String> names = new HashSet<String>(Arrays.asList(PROP_BRANCH_PATH, PROP_TIME_STAMP, PROP_FIXED));
        Map props = this.localRepository.getStore().getPersistentProperties(names);
        this.branchPath = (String)props.get(PROP_BRANCH_PATH);
        this.timeStamp = Long.parseLong((String)props.get(PROP_TIME_STAMP));
        this.fixed = Boolean.parseBoolean((String)props.get(PROP_FIXED));
    }
}

