/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.workspace;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.workspace.AbstractCDOWorkspaceBase;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceBase;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderCDOWorkspaceBase
extends AbstractCDOWorkspaceBase {
    private File folder;

    public FolderCDOWorkspaceBase(File folder) {
        this.folder = folder;
    }

    public File getFolder() {
        return this.folder;
    }

    @Override
    public void clear() {
        IOUtil.delete((File)this.folder);
        this.checkExists(this.folder, false);
        this.createFolder();
    }

    @Override
    public Set<CDOID> getIDs() {
        HashSet<CDOID> ids = new HashSet<CDOID>();
        String[] stringArray = this.folder.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            CDOID id = this.getCDOID(key);
            ids.add(id);
            ++n2;
        }
        return ids;
    }

    public CDORevision getRevision(CDOID id) {
        CDORevision cDORevision;
        File file = this.getFile(id);
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ExtendedDataInputStream edis = new ExtendedDataInputStream((InputStream)fis);
            CDODataInput in = this.createCDODataInput(edis);
            cDORevision = in.readCDORevision();
        }
        catch (Exception ex) {
            try {
                throw new IllegalStateException("Could not read from " + file.getAbsolutePath(), ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)fis);
        return cDORevision;
    }

    @Override
    protected void registerChangedOrDetachedObject(InternalCDORevision revision) {
        File file = this.getFile(revision.getID());
        if (file.exists()) {
            return;
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                ExtendedDataOutputStream edos = new ExtendedDataOutputStream((OutputStream)fos);
                CDODataOutput out = this.createCDODataOutput(edos);
                out.writeCDORevision((CDORevision)revision, -1);
                edos.flush();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not create " + file.getAbsolutePath(), ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fos);
            throw throwable;
        }
        IOUtil.close((Closeable)fos);
    }

    @Override
    protected void registerAddedObject(CDOID id) {
        File file = this.getFile(id);
        if (file.exists()) {
            return;
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not create " + file.getAbsolutePath(), ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fos);
            throw throwable;
        }
        IOUtil.close((Closeable)fos);
    }

    @Override
    protected void deregisterObject(CDOID id) {
        File file = this.getFile(id);
        file.delete();
        this.checkExists(file, false);
    }

    protected CDOID getCDOID(String filename) {
        return CDOIDUtil.read((String)filename);
    }

    protected String getKey(CDOID id) {
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)id);
        return builder.toString();
    }

    protected File getFile(CDOID id) {
        String key = this.getKey(id);
        return new File(this.folder, key);
    }

    private void createFolder() {
        IOUtil.mkdirs((File)this.folder);
        this.checkExists(this.folder, true);
    }

    private void checkExists(File file, boolean exists) {
        if (exists) {
            if (!file.exists()) {
                throw new IllegalStateException("File does not exist: " + file.getAbsolutePath());
            }
        } else if (file.exists()) {
            throw new IllegalStateException("File does still exist: " + file.getAbsolutePath());
        }
    }

    public static final class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String TYPE = "folder";

        public Factory() {
            super("org.eclipse.emf.cdo.workspace.bases", TYPE);
        }

        public Factory(String productGroup, String type) {
            super(productGroup, type);
        }

        public CDOWorkspaceBase create(String description) throws ProductCreationException {
            return CDOWorkspaceUtil.createFolderWorkspaceBase(new File(description));
        }
    }
}

