/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.util.List;
import org.eclipse.emf.cdo.CDONotification;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.object.CDOLegacyWrapper;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDOLegacyAdapter
extends CDOLegacyWrapper
implements Adapter.Internal {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOLegacyAdapter.class);

    public CDOLegacyAdapter(InternalEObject object) {
        super(object);
        this.instance.eAdapters().add((Object)this);
        ((BasicNotifierImpl.EObservableAdapterList)this.instance.eAdapters()).addListener((BasicNotifierImpl.EObservableAdapterList.Listener)new AdapterListListener());
    }

    public void setTarget(Notifier newTarget) {
        this.instance = (InternalEObject)newTarget;
    }

    public void unsetTarget(Notifier oldTarget) {
        if (this.instance == oldTarget) {
            this.instance = null;
        }
    }

    public Notifier getTarget() {
        return this.instance;
    }

    public boolean isAdapterForType(Object type) {
        return type == CDOLegacyAdapter.class;
    }

    public void notifyChanged(Notification msg) {
        if (msg.isTouch() || msg instanceof CDONotification) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)msg.getFeature();
        if (this.view == null || feature == null || !(this.view instanceof CDOTransaction)) {
            return;
        }
        CDOStore store = this.view.getStore();
        if (EMFUtil.isPersistent((EStructuralFeature)feature)) {
            switch (msg.getEventType()) {
                case 1: {
                    store.set(this.instance, feature, msg.getPosition(), msg.getNewValue());
                    break;
                }
                case 2: {
                    store.unset(this.instance, feature);
                    break;
                }
                case 7: {
                    store.move(this.instance, feature, msg.getPosition(), (Integer)msg.getOldValue());
                    break;
                }
                case 3: {
                    store.add(this.instance, feature, msg.getPosition(), msg.getNewValue());
                    break;
                }
                case 5: {
                    int pos = msg.getPosition();
                    List list = (List)msg.getNewValue();
                    for (Object object : list) {
                        store.add(this.instance, feature, pos++, object);
                    }
                    break;
                }
                case 4: {
                    store.remove(this.instance, feature, msg.getPosition());
                    break;
                }
                case 6: {
                    List list = (List)msg.getOldValue();
                    int i = list.size() - 1;
                    while (i >= 0) {
                        store.remove(this.instance, feature, i);
                        --i;
                    }
                    break;
                }
            }
            this.instanceToRevisionContainment();
        }
    }

    protected class AdapterListListener
    implements BasicNotifierImpl.EObservableAdapterList.Listener {
        public void added(Notifier notifier, Adapter adapter) {
            if (TRACER.isEnabled()) {
                TRACER.format("Added : {0} to {1} ", new Object[]{adapter, CDOLegacyAdapter.this});
            }
            if (!FSMUtil.isTransient(CDOLegacyAdapter.this)) {
                CDOLegacyAdapter.this.cdoView().handleAddAdapter(CDOLegacyAdapter.this, adapter);
            }
        }

        public void removed(Notifier notifier, Adapter adapter) {
            if (TRACER.isEnabled()) {
                TRACER.format("Removed : {0} from {1} ", new Object[]{adapter, CDOLegacyAdapter.this});
            }
            if (!FSMUtil.isTransient(CDOLegacyAdapter.this)) {
                CDOLegacyAdapter.this.cdoView().handleRemoveAdapter(CDOLegacyAdapter.this, adapter);
            }
        }
    }
}

