/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.internal.cdo.transaction.CDOUserSavepointImpl;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.collection.MultiMap;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOSavepointImpl
extends CDOUserSavepointImpl
implements InternalCDOSavepoint {
    private final InternalCDOTransaction transaction;
    private Map<CDOID, CDORevision> baseNewObjects = new HashMap<CDOID, CDORevision>();
    private Map<CDOID, CDOObject> newObjects = new HashMap<CDOID, CDOObject>();
    private Map<CDOID, CDOObject> reattachedObjects = new HashMap<CDOID, CDOObject>();
    private Map<CDOID, CDOObject> detachedObjects = new HashMap<CDOID, CDOObject>(){
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CDOObject put(CDOID key, CDOObject object) {
            InternalCDOTransaction internalCDOTransaction = CDOSavepointImpl.this.transaction;
            synchronized (internalCDOTransaction) {
                CDOSavepointImpl.this.baseNewObjects.remove(key);
                CDOSavepointImpl.this.newObjects.remove(key);
                CDOSavepointImpl.this.reattachedObjects.remove(key);
                CDOSavepointImpl.this.dirtyObjects.remove(key);
                CDOSavepointImpl.this.revisionDeltas.remove(key);
                return super.put(key, object);
            }
        }
    };
    private Map<CDOID, CDOObject> dirtyObjects = new HashMap<CDOID, CDOObject>();
    private ConcurrentMap<CDOID, CDORevisionDelta> revisionDeltas = new ConcurrentHashMap<CDOID, CDORevisionDelta>();
    private boolean wasDirty;

    public CDOSavepointImpl(InternalCDOTransaction transaction, InternalCDOSavepoint lastSavepoint) {
        super(transaction, lastSavepoint);
        this.transaction = transaction;
        this.wasDirty = transaction.isDirty();
    }

    @Override
    public InternalCDOTransaction getTransaction() {
        return (InternalCDOTransaction)super.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOSavepoint getFirstSavePoint() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            return (InternalCDOSavepoint)super.getFirstSavePoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOSavepoint getPreviousSavepoint() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            return (InternalCDOSavepoint)super.getPreviousSavepoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOSavepoint getNextSavepoint() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            return (InternalCDOSavepoint)super.getNextSavepoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            this.newObjects.clear();
            this.dirtyObjects.clear();
            this.revisionDeltas.clear();
            this.baseNewObjects.clear();
            this.detachedObjects.clear();
            this.reattachedObjects.clear();
        }
    }

    @Override
    public boolean wasDirty() {
        return this.wasDirty;
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        return this.newObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getDetachedObjects() {
        return this.detachedObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getReattachedObjects() {
        return this.reattachedObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        return this.dirtyObjects;
    }

    @Override
    @Deprecated
    public Set<CDOID> getSharedDetachedObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void recalculateSharedDetachedObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<CDOID, CDORevisionDelta> getRevisionDeltas() {
        return this.revisionDeltas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOChangeSetData getChangeSetData() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            return this.createChangeSetData(this.newObjects, this.revisionDeltas, this.detachedObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOChangeSetData getAllChangeSetData() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            return this.createChangeSetData(this.getAllNewObjects(), this.getAllRevisionDeltas(), this.getAllDetachedObjects());
        }
    }

    private CDOChangeSetData createChangeSetData(Map<CDOID, CDOObject> newObjects, Map<CDOID, CDORevisionDelta> revisionDeltas, Map<CDOID, CDOObject> detachedObjects) {
        ArrayList<CDORevision> newList = new ArrayList<CDORevision>(newObjects.size());
        for (CDOObject object : newObjects.values()) {
            newList.add(object.cdoRevision());
        }
        ArrayList<CDORevisionDelta> changedList = new ArrayList<CDORevisionDelta>(revisionDeltas.size());
        for (CDORevisionDelta delta : revisionDeltas.values()) {
            changedList.add(delta);
        }
        ArrayList<CDOIDAndVersion> detachedList = new ArrayList<CDOIDAndVersion>(detachedObjects.size());
        for (CDOID id : detachedObjects.keySet()) {
            detachedList.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)0));
        }
        return new CDOChangeSetDataImpl(newList, changedList, detachedList);
    }

    @Override
    public Map<CDOID, CDORevision> getBaseNewObjects() {
        return this.baseNewObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CDOID, CDOObject> getAllDirtyObjects() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            if (this.getPreviousSavepoint() == null) {
                return Collections.unmodifiableMap(this.getDirtyObjects());
            }
            MultiMap.ListBased dirtyObjects = new MultiMap.ListBased();
            InternalCDOSavepoint savepoint = this;
            while (savepoint != null) {
                dirtyObjects.getDelegates().add(savepoint.getDirtyObjects());
                savepoint = savepoint.getPreviousSavepoint();
            }
            return dirtyObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CDOID, CDOObject> getAllNewObjects() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            if (this.getPreviousSavepoint() == null) {
                return Collections.unmodifiableMap(this.getNewObjects());
            }
            HashMap<CDOID, CDOObject> newObjects = new HashMap<CDOID, CDOObject>();
            InternalCDOSavepoint savepoint = this.getFirstSavePoint();
            while (savepoint != null) {
                newObjects.putAll(savepoint.getNewObjects());
                for (CDOID removedID : savepoint.getDetachedObjects().keySet()) {
                    newObjects.remove(removedID);
                }
                savepoint = savepoint.getNextSavepoint();
            }
            return newObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CDOID, CDORevision> getAllBaseNewObjects() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            if (this.getPreviousSavepoint() == null) {
                return Collections.unmodifiableMap(this.getBaseNewObjects());
            }
            MultiMap.ListBased newObjects = new MultiMap.ListBased();
            InternalCDOSavepoint savepoint = this;
            while (savepoint != null) {
                newObjects.getDelegates().add(savepoint.getBaseNewObjects());
                savepoint = savepoint.getPreviousSavepoint();
            }
            return newObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CDOID, CDORevisionDelta> getAllRevisionDeltas() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            if (this.getPreviousSavepoint() == null) {
                return Collections.unmodifiableMap(this.getRevisionDeltas());
            }
            HashMap<CDOID, CDORevisionDelta> allRevisionDeltas = new HashMap<CDOID, CDORevisionDelta>();
            InternalCDOSavepoint savepoint = this.getFirstSavePoint();
            while (savepoint != null) {
                for (CDORevisionDelta revisionDelta : savepoint.getRevisionDeltas().values()) {
                    CDOID id = revisionDelta.getID();
                    if (this.isNewObject(id)) continue;
                    CDORevisionDeltaImpl oldRevisionDelta = (CDORevisionDeltaImpl)allRevisionDeltas.get(id);
                    if (oldRevisionDelta == null) {
                        allRevisionDeltas.put(id, revisionDelta.copy());
                        continue;
                    }
                    for (CDOFeatureDelta delta : revisionDelta.getFeatureDeltas()) {
                        oldRevisionDelta.addFeatureDelta(((InternalCDOFeatureDelta)delta).copy());
                    }
                }
                for (CDOID detachedID : savepoint.getDetachedObjects().keySet()) {
                    allRevisionDeltas.remove(detachedID);
                }
                savepoint = savepoint.getNextSavepoint();
            }
            return Collections.unmodifiableMap(allRevisionDeltas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CDOID, CDOObject> getAllDetachedObjects() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            if (this.getPreviousSavepoint() == null && this.reattachedObjects.isEmpty()) {
                return Collections.unmodifiableMap(this.getDetachedObjects());
            }
            HashMap<CDOID, CDOObject> detachedObjects = new HashMap<CDOID, CDOObject>();
            InternalCDOSavepoint savepoint = this.getFirstSavePoint();
            while (savepoint != null) {
                for (Map.Entry<CDOID, CDOObject> entry : savepoint.getDetachedObjects().entrySet()) {
                    CDOID detachedID = entry.getKey();
                    if (this.isNewObject(detachedID)) continue;
                    CDOObject detachedObject = entry.getValue();
                    detachedObjects.put(detachedID, detachedObject);
                }
                for (CDOID reattachedID : savepoint.getReattachedObjects().keySet()) {
                    detachedObjects.remove(reattachedID);
                }
                savepoint = savepoint.getNextSavepoint();
            }
            return detachedObjects;
        }
    }

    public boolean isNewObject(CDOID id) {
        return id.isTemporary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        InternalCDOTransaction internalCDOTransaction = this.transaction;
        synchronized (internalCDOTransaction) {
            InternalCDOTransaction transaction = this.getTransaction();
            LifecycleUtil.checkActive((Object)transaction);
            CDOTransactionStrategy transactionStrategy = transaction.getTransactionStrategy();
            transactionStrategy.rollback(transaction, this);
        }
    }
}

