/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ReferentialIntegrityException;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOUserSavepoint;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDOSingleTransactionStrategyImpl
implements CDOTransactionStrategy {
    public static final CDOSingleTransactionStrategyImpl INSTANCE = new CDOSingleTransactionStrategyImpl();
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, CDOSingleTransactionStrategyImpl.class);

    public CDOCommitInfo commit(InternalCDOTransaction transaction, IProgressMonitor progressMonitor) throws Exception {
        String comment = transaction.getCommitComment();
        InternalCDOTransaction.InternalCDOCommitContext commitContext = transaction.createCommitContext();
        if (TRACER.isEnabled()) {
            TRACER.format("CDOCommitContext.preCommit", new Object[0]);
        }
        commitContext.preCommit();
        CDOCommitData commitData = commitContext.getCommitData();
        Collection<CDOLob<?>> lobs = commitContext.getLobs();
        CDOSession session = transaction.getSession();
        CDOSessionProtocol.CommitTransactionResult result = null;
        if (transaction.isDirty()) {
            int viewID = transaction.getViewID();
            boolean releaseLocks = transaction.options().isAutoReleaseLocksEnabled();
            EclipseMonitor monitor = new EclipseMonitor(progressMonitor);
            CDOSessionProtocol sessionProtocol = session.getSessionProtocol();
            result = sessionProtocol.commitTransaction(viewID, comment, releaseLocks, transaction, commitData, lobs, (OMMonitor)monitor);
            String rollbackMessage = result.getRollbackMessage();
            if (rollbackMessage != null) {
                commitContext.postCommit(result);
                List<CDOObjectReference> xRefs = result.getXRefs();
                if (xRefs != null) {
                    throw new ReferentialIntegrityException(rollbackMessage, xRefs);
                }
                throw new CommitException(rollbackMessage);
            }
        }
        commitContext.postCommit(result);
        transaction.setCommitComment(null);
        if (result == null) {
            return null;
        }
        long previousTimeStamp = result.getPreviousTimeStamp();
        CDOBranch branch = transaction.getBranch();
        long timeStamp = result.getTimeStamp();
        String userID = session.getUserID();
        InternalCDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
        return commitInfoManager.createCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, commitData);
    }

    public void rollback(InternalCDOTransaction transaction, InternalCDOUserSavepoint savepoint) {
        transaction.handleRollback((InternalCDOSavepoint)savepoint);
    }

    public InternalCDOUserSavepoint setSavepoint(InternalCDOTransaction transaction) {
        return transaction.handleSetSavepoint();
    }

    public void setTarget(InternalCDOTransaction transaction) {
    }

    public void unsetTarget(InternalCDOTransaction transaction) {
    }
}

