/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.diff.provider.ReferenceChangeItemProvider;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateReferenceItemProvider
extends ReferenceChangeItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public UpdateReferenceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object getImage(Object object) {
        Object labelImage;
        UpdateReference updateReference = (UpdateReference)object;
        Object operationImage = updateReference.isRemote() ? this.getResourceLocator().getImage("full/obj16/RemoteUpdateUniqueReferenceValue") : this.getResourceLocator().getImage("full/obj16/UpdateReference");
        EObject value = this.getLeftValue(updateReference);
        if (value == null) {
            value = this.getRightValue(updateReference);
        }
        if (value != null && (labelImage = AdapterUtils.getItemProviderImage((EObject)value)) != null) {
            List<Object> images = Arrays.asList(labelImage, operationImage);
            return new ComposedImage(images);
        }
        return operationImage;
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addLeftTargetPropertyDescriptor(object);
            this.addRightTargetPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addLeftTargetPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_UpdateReference_leftTarget_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_UpdateReference_leftTarget_feature", "_UI_UpdateReference_type"), (EStructuralFeature)DiffPackage.Literals.UPDATE_REFERENCE__LEFT_TARGET, true, false, true, null, null, null));
    }

    protected void addRightTargetPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_UpdateReference_rightTarget_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_UpdateReference_rightTarget_feature", "_UI_UpdateReference_type"), (EStructuralFeature)DiffPackage.Literals.UPDATE_REFERENCE__RIGHT_TARGET, true, false, true, null, null, null));
    }

    @Override
    public String getText(Object object) {
        UpdateReference operation = (UpdateReference)object;
        String elementLabel = AdapterUtils.getItemProviderText((EObject)operation.getLeftElement());
        String referenceLabel = AdapterUtils.getItemProviderText((EObject)operation.getReference());
        String leftValueLabel = AdapterUtils.getItemProviderText((EObject)this.getLeftValue(operation));
        String rightValueLabel = AdapterUtils.getItemProviderText((EObject)this.getRightValue(operation));
        String diffLabel = operation.isRemote() ? this.getString("_UI_RemoteUpdateReference_type", new Object[]{referenceLabel, elementLabel, leftValueLabel, rightValueLabel}) : (operation.isConflicting() ? this.getString("_UI_UpdateReference_conflicting", new Object[]{referenceLabel, elementLabel, rightValueLabel, leftValueLabel}) : this.getString("_UI_UpdateReference_type", new Object[]{referenceLabel, elementLabel, rightValueLabel, leftValueLabel}));
        return diffLabel;
    }

    private EObject getLeftValue(UpdateReference operation) {
        EReference reference = operation.getReference();
        return (EObject)operation.getLeftElement().eGet((EStructuralFeature)reference);
    }

    private EObject getRightValue(UpdateReference operation) {
        EReference reference = operation.getReference();
        return (EObject)operation.getRightElement().eGet((EStructuralFeature)reference);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

