/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine;

import java.util.List;
import org.eclipse.emf.compare.match.engine.DefaultMatchScope;
import org.eclipse.emf.compare.match.engine.IMatchScope;
import org.eclipse.emf.compare.match.engine.IMatchScopeProvider;
import org.eclipse.emf.compare.match.filter.IResourceFilter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMatchScopeProvider
implements IMatchScopeProvider {
    private IMatchScope leftScope;
    private IMatchScope rightScope;
    private IMatchScope ancestorScope;

    public DefaultMatchScopeProvider(EObject leftObject, EObject rightObject) {
        this.leftScope = new DefaultMatchScope(leftObject);
        this.rightScope = new DefaultMatchScope(rightObject);
    }

    public DefaultMatchScopeProvider(EObject leftObject, EObject rightObject, EObject ancestorObject) {
        this(leftObject, rightObject);
        this.ancestorScope = new DefaultMatchScope(ancestorObject);
    }

    public DefaultMatchScopeProvider(Resource leftResource, Resource rightResource) {
        this.leftScope = new DefaultMatchScope(leftResource);
        this.rightScope = new DefaultMatchScope(rightResource);
    }

    public DefaultMatchScopeProvider(Resource leftResource, Resource rightResource, Resource ancestorResource) {
        this(leftResource, rightResource);
        this.ancestorScope = new DefaultMatchScope(ancestorResource);
    }

    public DefaultMatchScopeProvider(ResourceSet leftResourceSet, ResourceSet rightResourceSet) {
        this.leftScope = new DefaultMatchScope(leftResourceSet);
        this.rightScope = new DefaultMatchScope(rightResourceSet);
    }

    public DefaultMatchScopeProvider(ResourceSet leftResourceSet, ResourceSet rightResourceSet, ResourceSet ancestorResourceSet) {
        this(leftResourceSet, rightResourceSet);
        this.ancestorScope = new DefaultMatchScope(ancestorResourceSet);
    }

    @Override
    public IMatchScope getAncestorScope() {
        return this.ancestorScope;
    }

    @Override
    public IMatchScope getLeftScope() {
        return this.leftScope;
    }

    @Override
    public IMatchScope getRightScope() {
        return this.rightScope;
    }

    @Override
    public void applyResourceFilter(IResourceFilter filter) {
        if (this.ancestorScope != null) {
            DefaultMatchScopeProvider.applyExternalFilter(filter, ((DefaultMatchScope)this.leftScope).getResourcesInScope(), ((DefaultMatchScope)this.rightScope).getResourcesInScope(), ((DefaultMatchScope)this.ancestorScope).getResourcesInScope());
        } else {
            DefaultMatchScopeProvider.applyExternalFilter(filter, ((DefaultMatchScope)this.leftScope).getResourcesInScope(), ((DefaultMatchScope)this.rightScope).getResourcesInScope());
        }
    }

    private static void applyExternalFilter(IResourceFilter filter, List<Resource> ... resources) {
        if (resources.length == 2) {
            filter.filter(resources[0], resources[1]);
        } else {
            filter.filter(resources[0], resources[1], resources[2]);
        }
    }
}

