/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.match.EMFCompareMatchMessages;
import org.eclipse.emf.compare.match.engine.AbstractSimilarityChecker;
import org.eclipse.emf.compare.match.engine.internal.GenericMatchEngineToCheckerBridge;
import org.eclipse.emf.compare.match.internal.statistic.NameSimilarity;
import org.eclipse.emf.compare.match.internal.statistic.StructureSimilarity;
import org.eclipse.emf.compare.match.statistic.MetamodelFilter;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class StatisticBasedSimilarityChecker
extends AbstractSimilarityChecker {
    private static final double GENERAL_THRESHOLD = 0.96;
    private static final char TYPE_SIMILARITY = 't';
    private static final int MIN_ATTRIBUTES_COUNT = 5;
    private static final char NAME_SIMILARITY = 'n';
    private static final char RELATION_SIMILARITY = 'r';
    private static final char VALUE_SIMILARITY = 'v';
    private final Map<String, Double> metricsCache = new HashMap<String, Double>();
    private final Map<EObject, Integer> nonNullFeatureCounts = new HashMap<EObject, Integer>(20);
    private final Map<EObject, String> uriFragmentCache = new WeakHashMap<EObject, String>(20);
    @Deprecated
    private GenericMatchEngineToCheckerBridge bridge;

    public StatisticBasedSimilarityChecker(MetamodelFilter filter, GenericMatchEngineToCheckerBridge bridge) {
        super(filter);
        this.bridge = bridge;
    }

    public boolean isSimilar(EObject obj1, EObject obj2) throws FactoryException {
        boolean similar = false;
        double almostEquals = 0.999999;
        double nameOnlyMetricThreshold = 0.7;
        double fewerAttributesNameThreshold = 0.8;
        double relationsThreshold = 0.9;
        double nameThreshold = 0.2;
        double contentThreshold = 0.9;
        double triWayThreshold = 0.9;
        double generalThreshold = 0.96;
        double nameSimilarity = this.nameSimilarity(obj1, obj2);
        boolean hasSameUri = this.hasSameUri(obj1, obj2);
        int obj1NonNullFeatures = this.nonNullFeaturesCount(obj1);
        int obj2NonNullFeatures = this.nonNullFeaturesCount(obj2);
        if (obj1 instanceof EGenericType || obj2 instanceof EGenericType) {
            similar = this.isSimilar(obj1.eContainer(), obj2.eContainer());
        } else if (nameSimilarity > 0.999999 && hasSameUri) {
            similar = true;
        } else if (obj1NonNullFeatures == 1 && obj2NonNullFeatures == 1) {
            similar = nameSimilarity > 0.7;
        } else if (nameSimilarity > 0.8 && obj1NonNullFeatures <= 5 && obj2NonNullFeatures <= 5 && this.typeSimilarity(obj1, obj2) > 0.96) {
            similar = true;
        } else {
            double contentSimilarity = this.contentSimilarity(obj1, obj2);
            double relationsSimilarity = this.relationsSimilarity(obj1, obj2);
            if (relationsSimilarity > 0.999999 && hasSameUri && nameSimilarity > 0.2) {
                similar = true;
            } else if (contentSimilarity > 0.999999 && relationsSimilarity > 0.999999) {
                similar = true;
            } else if (contentSimilarity > 0.96 && relationsSimilarity > 0.9 && nameSimilarity > 0.2) {
                similar = true;
            } else if (relationsSimilarity > 0.96 && contentSimilarity > 0.9) {
                similar = true;
            } else if (contentSimilarity > 0.9 && nameSimilarity > 0.9 && relationsSimilarity > 0.9) {
                similar = true;
            } else if (contentSimilarity > 0.96 && nameSimilarity > 0.96 && this.typeSimilarity(obj1, obj2) > 0.96) {
                similar = true;
            }
        }
        return similar;
    }

    protected double nameSimilarity(EObject obj1, EObject obj2) {
        double similarity = 0.0;
        Double value = this.getSimilarityFromCache(obj1, obj2, 'n');
        if (value != null) {
            similarity = value;
        } else {
            similarity = this.bridge.nameSimilarity(obj1, obj2);
            this.setSimilarityInCache(obj1, obj2, 'n', similarity);
        }
        return similarity;
    }

    public double absoluteMetric(EObject obj1, EObject obj2) throws FactoryException {
        double nameSimilarity = this.nameSimilarity(obj1, obj2);
        double relationsSimilarity = this.relationsSimilarity(obj1, obj2);
        double sameUri = 0.0;
        if (this.hasSameUri(obj1, obj2)) {
            sameUri = 1.0;
        }
        double positionSimilarity = relationsSimilarity / 2.0 + sameUri / 2.0;
        double contentWeight = 0.5;
        if (this.nonNullFeaturesCount(obj1) > 5 && this.nonNullFeaturesCount(obj2) > 5) {
            double nameWeight = 0.4;
            double positionWeight = 0.4;
            double contentSimilarity = this.contentSimilarity(obj1, obj2);
            return (contentSimilarity * 0.5 + nameSimilarity * 0.4 + positionSimilarity * 0.4) / 1.3;
        }
        double nameWeight = 0.8;
        double positionWeight = 0.2;
        return (nameSimilarity * 0.8 + positionSimilarity * 0.2) / 1.0;
    }

    private double typeSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        double similarity = 0.0;
        Double value = this.getSimilarityFromCache(obj1, obj2, 't');
        if (value != null) {
            similarity = value;
        } else {
            similarity = StructureSimilarity.typeSimilarityMetric(obj1, obj2);
            this.setSimilarityInCache(obj1, obj2, 't', similarity);
        }
        return similarity;
    }

    protected double contentSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        double similarity = 0.0;
        Double value = this.getSimilarityFromCache(obj1, obj2, 'v');
        if (value == null) {
            value = this.getSimilarityFromCache(obj2, obj1, 'v');
        }
        if (value != null) {
            similarity = value;
        } else if (this.filter.getFilteredFeatures(obj1).size() < 5 || this.filter.getFilteredFeatures(obj2).size() < 5) {
            similarity = this.bridge.contentSimilarity(obj1, obj2);
            this.setSimilarityInCache(obj1, obj2, 'v', similarity);
        } else {
            similarity = NameSimilarity.nameSimilarityMetric(NameSimilarity.contentValue(obj1, this.filter), NameSimilarity.contentValue(obj2, this.filter));
            this.setSimilarityInCache(obj1, obj2, 'v', similarity);
        }
        return similarity;
    }

    private int nonNullFeaturesCount(EObject eobj) {
        Integer nonNullFeatures = this.nonNullFeatureCounts.get(eobj);
        if (nonNullFeatures == null) {
            int count = this.countNonNullFeatures(eobj);
            nonNullFeatures = count;
            this.nonNullFeatureCounts.put(eobj, nonNullFeatures);
        }
        return nonNullFeatures;
    }

    private int countNonNullFeatures(EObject eobj) {
        int count = 0;
        for (EStructuralFeature feature : this.filter.getFilteredFeatures(eobj)) {
            if (feature.isDerived()) continue;
            Object value = eobj.eGet(feature);
            if (feature.isMany()) {
                if (((Collection)value).size() <= 0) continue;
                ++count;
                continue;
            }
            if (value == null || "".equals(value.toString())) continue;
            ++count;
        }
        return count;
    }

    private static String pairHashCode(EObject obj1, EObject obj2, char similarityKind) {
        if (similarityKind == 'n' || similarityKind == 't' || similarityKind == 'v' || similarityKind == 'r') {
            int obj2Hash;
            StringBuilder hash = new StringBuilder(String.valueOf(similarityKind));
            int obj1Hash = obj1.hashCode();
            if (obj1Hash < (obj2Hash = obj2.hashCode())) {
                hash.append(String.valueOf(obj1Hash)).append(String.valueOf(obj2Hash));
            } else {
                hash.append(String.valueOf(obj2Hash)).append(String.valueOf(obj1Hash));
            }
            return hash.toString();
        }
        throw new IllegalArgumentException(EMFCompareMatchMessages.getString("DifferencesServices.illegalSimilarityKind", Character.valueOf(similarityKind)));
    }

    private Double getSimilarityFromCache(EObject obj1, EObject obj2, char similarityKind) {
        return this.metricsCache.get(StatisticBasedSimilarityChecker.pairHashCode(obj1, obj2, similarityKind));
    }

    protected boolean hasSameUri(EObject obj1, EObject obj2) {
        if (obj1.eResource() != null && obj2.eResource() != null) {
            String obj2URIFragment;
            String obj1URIFragment = this.uriFragmentCache.get(obj1);
            if (obj1URIFragment == null) {
                obj1URIFragment = obj1.eResource().getURIFragment(obj1);
                this.uriFragmentCache.put(obj1, obj1URIFragment);
            }
            if ((obj2URIFragment = this.uriFragmentCache.get(obj2)) == null) {
                obj2URIFragment = obj2.eResource().getURIFragment(obj2);
                this.uriFragmentCache.put(obj2, obj2URIFragment);
            }
            return obj1URIFragment.equals(obj2URIFragment);
        }
        return false;
    }

    private double relationsSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        double similarity = 0.0;
        Double value = this.getSimilarityFromCache(obj1, obj2, 'r');
        if (value != null) {
            similarity = value;
        } else {
            similarity = StructureSimilarity.relationsSimilarityMetric(obj1, obj2, this.filter);
            this.setSimilarityInCache(obj1, obj2, 'r', similarity);
        }
        return similarity;
    }

    private void setSimilarityInCache(EObject obj1, EObject obj2, char similarityKind, double similarity) {
        this.metricsCache.put(StatisticBasedSimilarityChecker.pairHashCode(obj1, obj2, similarityKind), new Double(similarity));
    }

    public void init(EObject leftObject, EObject rightObject) throws FactoryException {
    }

    public void init(Resource leftResource, Resource rightResource) throws FactoryException {
    }
}

