/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.actions;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.apply.generic.impl.MPatchDependencies;
import org.eclipse.emf.compare.mpatch.common.actions.AbstractCompareAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class DependencyAction
extends AbstractCompareAction {
    private static final String ACTION_NAME = "Dependency Graph";
    private static final String inputFileExtension = "mpatch";
    private static final String outputFileExtension = "mpatch";
    private static final String jobTitle = "Creating Dependency Graph for MPatch...";

    public DependencyAction() {
        super("mpatch", "mpatch", jobTitle);
    }

    protected Status runAction(Resource input, Resource output, IProgressMonitor monitor) {
        Exception exception;
        int code;
        String message;
        block7: {
            message = "";
            code = 0;
            exception = null;
            EObject content = (EObject)input.getContents().get(0);
            if (content instanceof MPatchModel) {
                MPatchModel mpatch = (MPatchModel)content;
                try {
                    int deps = MPatchDependencies.calculateDependencies(mpatch);
                    if (deps > 0) {
                        output.getContents().add((Object)mpatch);
                        try {
                            output.save(null);
                            message = "Dependency Graph successfully created with " + deps + " dependencies.";
                        }
                        catch (IOException e) {
                            exception = e;
                            message = "Could not save diff with Dependency Graph!";
                            code = 4;
                        }
                        break block7;
                    }
                    message = "No dependencies created/required for MPatch.";
                }
                catch (Exception e) {
                    exception = e;
                    message = "An exception occured during Dependency Graph creation";
                    code = 4;
                }
            } else {
                code = 4;
                message = "Could not find MPatch in:\n\n" + content;
            }
        }
        return new Status(code, "org.eclipse.emf.compare.mpatch.apply.generic", message, (Throwable)exception);
    }
}

