/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.actions;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.apply.generic.impl.InternalReferences;
import org.eclipse.emf.compare.mpatch.common.actions.AbstractCompareAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class InternalReferencesAction
extends AbstractCompareAction {
    private static final String ACTION_NAME = "Internal Symbolic References";
    private static final String inputFileExtension = "mpatch";
    private static final String outputFileExtension = "mpatch";
    private static final String jobTitle = "Creating Internal Symbolic References for MPatch...";

    public InternalReferencesAction() {
        super("mpatch", "mpatch", jobTitle);
    }

    protected Status runAction(Resource input, Resource output, IProgressMonitor monitor) {
        Exception exception;
        int code;
        String message;
        block7: {
            message = "";
            code = 0;
            exception = null;
            EObject content = (EObject)input.getContents().get(0);
            if (content instanceof MPatchModel) {
                MPatchModel mpatch = (MPatchModel)content;
                try {
                    int refs = InternalReferences.createInternalReferences(mpatch);
                    if (refs > 0) {
                        output.getContents().add((Object)mpatch);
                        try {
                            output.save(null);
                            message = "Internal Symbolic References successful: " + refs + " internal references created.";
                        }
                        catch (IOException e) {
                            code = 4;
                            exception = e;
                            message = "Could not save MPatch with Internal Symbolic References!";
                        }
                        break block7;
                    }
                    message = "No Internal Symbolic References created.";
                }
                catch (Exception e) {
                    code = 4;
                    exception = e;
                    message = "An exception occured during Internal Symbolic References creation";
                }
            } else {
                code = 4;
                message = "Could not find MPatch in:\n\n" + content;
            }
        }
        return new Status(code, "org.eclipse.emf.compare.mpatch.apply.generic", message, (Throwable)exception);
    }
}

