/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.apply.util.MPatchResolver;
import org.eclipse.emf.compare.mpatch.apply.util.MPatchValidator;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoMPatchResolver {
    static void resolve(ResolvedSymbolicReferences mapping) {
        AutoMPatchResolver.removeInvalidStateResolutions(mapping);
        AutoMPatchResolver.removeInvalidDependencies(mapping);
        AutoMPatchResolver.validateBinding(mapping);
    }

    private static void removeInvalidDependencies(ResolvedSymbolicReferences mapping) {
        Set<IndepChange> valid = mapping.getResolutionByChange().keySet();
        Set<IndepChange> invalid = AutoMPatchResolver.collectInvalidChanges(valid);
        AutoMPatchResolver.removeInvalidDependants(valid, invalid);
    }

    private static void removeInvalidDependants(Set<IndepChange> valid, Set<IndepChange> invalid) {
        HashSet<IndepChange> processed = new HashSet<IndepChange>(valid.size());
        LinkedList<IndepChange> queue2 = new LinkedList<IndepChange>();
        queue2.addAll(invalid);
        processed.clear();
        while (!queue2.isEmpty()) {
            IndepChange change = (IndepChange)queue2.poll();
            if (processed.contains(change)) continue;
            processed.add(change);
            valid.remove(change);
            queue2.addAll((Collection<IndepChange>)change.getDependants());
        }
    }

    private static Set<IndepChange> collectInvalidChanges(Set<IndepChange> valid) {
        HashSet<IndepChange> invalid = new HashSet<IndepChange>(valid.size());
        HashSet<IndepChange> processed = new HashSet<IndepChange>(valid.size());
        LinkedList<IndepChange> queue1 = new LinkedList<IndepChange>();
        queue1.addAll(valid);
        while (!queue1.isEmpty()) {
            IndepChange change = (IndepChange)queue1.poll();
            if (processed.contains(change)) continue;
            processed.add(change);
            if (!valid.contains(change)) {
                invalid.add(change);
            }
            queue1.addAll((Collection<IndepChange>)change.getDependsOn());
        }
        return invalid;
    }

    private static void removeInvalidStateResolutions(ResolvedSymbolicReferences mapping) {
        boolean forward = mapping.getDirection() == 1;
        ArrayList changes = new ArrayList(mapping.getResolutionByChange().keySet());
        for (IndepChange change : changes) {
            if (MPatchResolver.checkStateResolution((IndepChange)change, (ResolvedSymbolicReferences)mapping, (boolean)true, (boolean)forward)) continue;
            mapping.getResolutionByChange().remove(change);
        }
    }

    private static void validateBinding(ResolvedSymbolicReferences mapping) {
        List violations = MPatchValidator.validateResolutions((ResolvedSymbolicReferences)mapping);
        while (!violations.isEmpty()) {
            for (IndepChange change : violations) {
                mapping.getResolutionByChange().remove(change);
            }
            violations = MPatchValidator.validateResolutions((ResolvedSymbolicReferences)mapping);
        }
    }
}

