/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.apply.generic.impl.GenericMPatchResolver;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class ElementSelectionDialogCellEditor
extends DialogCellEditor {
    private final GenericMPatchResolver genericMPatchResolver;
    private List<? extends EObject> cachedFlattenedModel;
    private final ILabelProvider labelProvider;
    private final AdapterFactoryContentProvider adapterFactoryContentProvider;
    private final AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    private ResolvedSymbolicReferences mapping;
    private final Shell shell;

    void reset(ResolvedSymbolicReferences mapping) {
        this.cachedFlattenedModel = null;
        this.mapping = mapping;
    }

    public ElementSelectionDialogCellEditor(GenericMPatchResolver genericMPatchResolver, Composite composite, AdapterFactory adapterFactory, AdapterFactoryLabelProvider adapterFactoryLabelProvider, ResolvedSymbolicReferences mapping2) {
        super(composite);
        this.reset(this.mapping);
        this.shell = composite.getShell();
        this.genericMPatchResolver = genericMPatchResolver;
        this.adapterFactoryContentProvider = new AdapterFactoryContentProvider(adapterFactory);
        this.adapterFactoryLabelProvider = adapterFactoryLabelProvider;
        this.labelProvider = new AdapterFactoryLabelProvider(adapterFactory){

            public String getColumnText(Object object, int columnIndex) {
                return this.getText(object);
            }

            public String getText(Object object) {
                EObject obj;
                String text = super.getText(object);
                if (object != null && text != null && object instanceof EObject && (obj = (EObject)object).eResource() != null) {
                    String fragment = obj.eResource().getURIFragment(obj);
                    String resource = obj.eResource().getURI().lastSegment();
                    if (fragment != null && fragment.length() > 0) {
                        return String.valueOf(text) + "    [" + resource + "#" + fragment + "]";
                    }
                }
                return text;
            }
        };
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        if (this.genericMPatchResolver.getCurrentlySelectedElement() == null) {
            return null;
        }
        if (this.genericMPatchResolver.getCurrentlySelectedElement() instanceof IElementReference) {
            return this.refineSymref((IElementReference)this.genericMPatchResolver.getCurrentlySelectedElement());
        }
        if (this.genericMPatchResolver.getCurrentlySelectedElement() instanceof IndepAddElementChange) {
            return this.bindAddedElement((IndepAddElementChange)this.genericMPatchResolver.getCurrentlySelectedElement());
        }
        return null;
    }

    private Object bindAddedElement(IndepAddElementChange change) {
        List bound = (List)((Map)this.mapping.getResolutionByChange().get(change)).get(change.getSubModelReference());
        BindAddedElementDialog dialog = new BindAddedElementDialog(this.shell, this.mapping.getModel(), change.getSubModel(), bound);
        if (dialog.open() == 0) {
            List<EObject> result = dialog.getResult();
            return result;
        }
        return null;
    }

    private GenericMPatchResolver.SymrefRefinement refineSymref(IElementReference symref) {
        IndepChange change = MPatchUtil.getChangeFor((IElementReference)symref);
        if (this.cachedFlattenedModel == null) {
            this.cachedFlattenedModel = ExtEcoreUtils.flattenEObjects(Collections.singleton(this.mapping.getModel()));
        }
        ArrayList<EObject> selectionList = new ArrayList<EObject>();
        EClass filterEClass = symref.getType();
        for (EObject eObject : this.cachedFlattenedModel) {
            if (!filterEClass.isSuperTypeOf(eObject.eClass())) continue;
            selectionList.add(eObject);
        }
        List list = (List)((Map)this.mapping.getResolutionByChange().get(change)).get(symref);
        ArrayList currentList = new ArrayList(list);
        String bounds = GenericMPatchResolver.getCount(symref.getLowerBound(), symref.getUpperBound());
        SymrefResolutionDialog dialog = new SymrefResolutionDialog(this.shell, this.labelProvider, bounds, null, currentList, "Symbolic References resolution", selectionList, currentList, bounds, change);
        if (dialog.open() == 0) {
            EList result = dialog.getResult();
            List<IElementReference> refs = dialog.getReferences();
            GenericMPatchResolver genericMPatchResolver = this.genericMPatchResolver;
            genericMPatchResolver.getClass();
            return new GenericMPatchResolver.SymrefRefinement(genericMPatchResolver, (List<EObject>)result, refs);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BindAddedElementDialog
    extends Dialog
    implements ISelectionChangedListener {
        private final List<EObject> initialSelection;
        private final List<EObject> currentSelection;
        private final IModelDescriptor modelDescriptor;
        private final EObject input;
        private TreeViewer modelTreeViewer;
        private Label statusLabel;

        private BindAddedElementDialog(Shell parent, EObject model, IModelDescriptor modelDescriptor, List<EObject> currentList) {
            super(parent);
            this.initialSelection = currentList;
            this.modelDescriptor = modelDescriptor;
            this.input = model;
            this.currentSelection = new ArrayList<EObject>();
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Select existing model element");
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridData gd = new GridData(1808);
            gd.verticalIndent = 6;
            this.modelTreeViewer = new TreeViewer(composite, 68354);
            this.modelTreeViewer.getTree().setLayoutData((Object)gd);
            this.modelTreeViewer.setContentProvider((IContentProvider)ElementSelectionDialogCellEditor.this.adapterFactoryContentProvider);
            this.modelTreeViewer.setLabelProvider((IBaseLabelProvider)ElementSelectionDialogCellEditor.this.adapterFactoryLabelProvider);
            this.modelTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.modelTreeViewer.setInput((Object)this.input);
            if (this.initialSelection != null) {
                this.modelTreeViewer.setSelection((ISelection)new StructuredSelection(this.initialSelection.toArray()));
            }
            Button button = new Button(composite, 8);
            button.setText("Clear selection");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BindAddedElementDialog.this.modelTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            });
            this.addInfoLabels(composite);
            return composite;
        }

        private void addInfoLabels(Composite contents) {
            String info = "Please select one or multiple model elements that should be bound instead of adding new elements; if none is selected, a new model element is created.";
            Label infoLabel = new Label(contents, 0);
            infoLabel.setLayoutData((Object)new GridData(32, 2, true, false));
            infoLabel.setText(info);
            this.statusLabel = new Label(contents, 0);
            this.statusLabel.setLayoutData((Object)new GridData(32, 2, true, false));
        }

        private void setStatus(String message, boolean valid) {
            Button button;
            if (this.statusLabel != null) {
                this.statusLabel.setText(message);
            }
            if ((button = this.getButton(0)) != null) {
                button.setEnabled(valid);
            }
        }

        List<EObject> getResult() {
            return this.currentSelection;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            this.currentSelection.clear();
            if (event.getSelection() != null && event.getSelection() instanceof StructuredSelection && !(selection = (IStructuredSelection)event.getSelection()).isEmpty()) {
                this.currentSelection.addAll(selection.toList());
            }
            this.validateSelection();
        }

        private void validateSelection() {
            if (this.currentSelection.isEmpty()) {
                this.setStatus("No elements selected.", true);
            } else {
                EObject parent = null;
                for (EObject obj : this.currentSelection) {
                    if (parent == null) {
                        parent = obj.eContainer();
                        continue;
                    }
                    if (parent.equals(obj.eContainer())) continue;
                    this.setStatus("The selected elements must have the same parent!", false);
                    return;
                }
                ArrayList<EObject> invalid = new ArrayList<EObject>();
                for (EObject obj : this.currentSelection) {
                    if (this.modelDescriptor.isDescriptorFor(obj, false) != null) continue;
                    invalid.add(obj);
                }
                if (invalid.isEmpty()) {
                    this.setStatus(String.valueOf(this.currentSelection.size()) + " elements selected.", true);
                } else {
                    String message = "Invalid model element(s):\n";
                    for (EObject obj : invalid) {
                        message = String.valueOf(message) + ElementSelectionDialogCellEditor.this.adapterFactoryLabelProvider.getText((Object)obj) + "\n";
                    }
                    this.setStatus(message, false);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SymrefResolutionDialog
    extends FeatureEditorDialog {
        private final List<EObject> currentList;
        private final String bounds;
        private final IndepChange change;
        private final List<IElementReference> references;
        private TableViewer equalReferencesTable;

        private SymrefResolutionDialog(Shell parent, ILabelProvider labelProvider, Object object, EClassifier eClassifier, List<?> currentValues, String displayName, List<?> choiceOfValues, List<EObject> currentList, String bounds, IndepChange change) {
            super(parent, labelProvider, object, eClassifier, currentValues, displayName, choiceOfValues, false, true, true);
            this.currentList = currentList;
            this.bounds = bounds;
            this.change = change;
            this.references = new ArrayList<IElementReference>();
        }

        public List<IElementReference> getReferences() {
            return this.references;
        }

        protected void okPressed() {
            this.references.clear();
            if (this.equalReferencesTable != null && this.equalReferencesTable.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)this.equalReferencesTable.getSelection();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    this.references.add((IElementReference)iter.next());
                }
            }
            super.okPressed();
        }

        protected Control createDialogArea(Composite parent) {
            Composite contents = (Composite)super.createDialogArea(parent);
            this.addInfoLabel(contents);
            this.addEqualRefs(contents);
            return contents;
        }

        private void addEqualRefs(Composite contents) {
            List equalRefs = ElementSelectionDialogCellEditor.this.mapping.getEquallyResolvingReferences((IElementReference)ElementSelectionDialogCellEditor.this.genericMPatchResolver.getCurrentlySelectedElement());
            if (equalRefs != null && equalRefs.size() > 0) {
                Label separator = new Label(contents, 259);
                GridData data = new GridData(768);
                data.horizontalSpan = 3;
                separator.setLayoutData((Object)data);
                Label infoLabel = new Label(contents, 0);
                infoLabel.setLayoutData((Object)new GridData(32, 2, true, false, 3, 1));
                infoLabel.setText("Apply selection to the following equally resolving Symbolic References (CTRL + mouse click for selecting):");
                GridData gd = new GridData(272);
                gd.grabExcessHorizontalSpace = false;
                gd.grabExcessVerticalSpace = true;
                gd.horizontalSpan = 3;
                this.equalReferencesTable = new TableViewer(contents, 68098);
                this.equalReferencesTable.getTable().setLayoutData((Object)gd);
                this.equalReferencesTable.setContentProvider((IContentProvider)new ArrayContentProvider());
                this.equalReferencesTable.setLabelProvider((IBaseLabelProvider)ElementSelectionDialogCellEditor.this.adapterFactoryLabelProvider);
                for (IElementReference ref : equalRefs) {
                    List otherList;
                    IndepChange otherChange = MPatchUtil.getChangeFor((IElementReference)ref);
                    if (otherChange == null || !ElementSelectionDialogCellEditor.this.mapping.getResolutionByChange().containsKey(otherChange) || (otherList = (List)((Map)ElementSelectionDialogCellEditor.this.mapping.getResolutionByChange().get(otherChange)).get(ref)) == null || otherList.size() != this.currentList.size() || !otherList.containsAll(this.currentList)) continue;
                    this.references.add(ref);
                }
                this.equalReferencesTable.setInput((Object)equalRefs);
                this.equalReferencesTable.setSelection((ISelection)new StructuredSelection(this.references));
            }
        }

        private void addInfoLabel(Composite contents) {
            String info = "This Symbolic Reference ";
            if (ElementSelectionDialogCellEditor.this.genericMPatchResolver.getCurrentlySelectedElement().eContainmentFeature() != null) {
                info = String.valueOf(info) + "(" + this.change.getChangeKind() + "." + ElementSelectionDialogCellEditor.this.genericMPatchResolver.getCurrentlySelectedElement().eContainmentFeature().getName() + ") ";
            }
            info = String.valueOf(info) + "must resolve " + this.bounds + ".";
            Label infoLabel = new Label(contents, 0);
            infoLabel.setLayoutData((Object)new GridData(32, 2, true, false, 3, 1));
            infoLabel.setText(info);
        }
    }
}

