/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.impl;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchFactory;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.ModelDescriptorReference;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalReferences
implements IMPatchTransformation {
    public static final String LABEL = "Replace Internal Symbolic References";
    private static final String DESCRIPTION = "This transformation replaces internal Symbolic References with special references (ModelDescriptorReferences). This is required for the default MPatch application engine to work properly!\n\nDuring the application of MPatch, Symbolic References can be refined by the user. Since internal references refer to model elements that do not yet exist in the model, these elements cannot be refined.Hence the need for internal Symbolic References.";

    public String getLabel() {
        return LABEL;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getPriority() {
        return 10;
    }

    public boolean isOptional() {
        return false;
    }

    public int transform(MPatchModel mpatch) {
        return InternalReferences.createInternalReferences(mpatch);
    }

    public static int createInternalReferences(MPatchModel mpatch) {
        Map uriToDescriptorMap = MPatchUtil.collectDescriptors((List)mpatch.getChanges());
        Map crossReferences = MPatchUtil.collectCrossReferences((List)mpatch.getChanges());
        int replacements = InternalReferences.createInternalCrossReferences(crossReferences, uriToDescriptorMap);
        return replacements;
    }

    private static int createInternalCrossReferences(Map<IElementReference, IndepChange> crossReferences, Map<String, IModelDescriptor> uriToDescriptorMap) {
        int counter = 0;
        for (IElementReference ref : crossReferences.keySet()) {
            if (ref instanceof ModelDescriptorReference || !uriToDescriptorMap.containsKey(ref.getUriReference())) continue;
            ModelDescriptorReference newRef = MPatchFactory.eINSTANCE.createModelDescriptorReference();
            IModelDescriptor descriptor = uriToDescriptorMap.get(ref.getUriReference());
            newRef.setResolvesTo(descriptor);
            EcoreUtil.replace((EObject)ref, (EObject)newRef);
            ++counter;
        }
        return counter;
    }
}

