/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IndepAddRemElementChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.ModelDescriptorReference;
import org.eclipse.emf.compare.mpatch.UnknownChange;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;

public class ReferenceResolutionContentProvider
extends AdapterFactoryContentProvider {
    private static final Map<EClass, List<EReference>> RELEVANT_REFERENCES_BEFORE = new HashMap<EClass, List<EReference>>();
    private static final Map<EClass, List<EReference>> RELEVANT_REFERENCES_AFTER = new HashMap<EClass, List<EReference>>();
    private static final EReference[] ADD_REM_ELEMENT_LIST = new EReference[]{MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT};
    private static final EReference[] MOVE_ELEMENT_LIST_BEFORE = new EReference[]{MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT, MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE__OLD_PARENT};
    private static final EReference[] MOVE_ELEMENT_LIST_AFTER = new EReference[]{MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT, MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE__NEW_PARENT};
    private static final EReference[] ATTRIBUTE_LIST = new EReference[]{MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT};
    private static final EReference[] ADD_REM_REFERENCE_LIST = new EReference[]{MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT, MPatchPackage.Literals.INDEP_ADD_REM_REFERENCE_CHANGE__CHANGED_REFERENCE};
    private static final EReference[] UPDATE_REFERENCE_LIST_BEFORE = new EReference[]{MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT, MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE__OLD_REFERENCE};
    private static final EReference[] UPDATE_REFERENCE_LIST_AFTER = new EReference[]{MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT, MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE__NEW_REFERENCE};
    private final ResolvedSymbolicReferences mapping;

    static {
        RELEVANT_REFERENCES_BEFORE.put(MPatchPackage.Literals.INDEP_ADD_ELEMENT_CHANGE, Arrays.asList(ADD_REM_ELEMENT_LIST));
        RELEVANT_REFERENCES_BEFORE.put(MPatchPackage.Literals.INDEP_REMOVE_ELEMENT_CHANGE, Arrays.asList(ADD_REM_ELEMENT_LIST));
        RELEVANT_REFERENCES_BEFORE.put(MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE, Arrays.asList(MOVE_ELEMENT_LIST_BEFORE));
        RELEVANT_REFERENCES_BEFORE.put(MPatchPackage.Literals.INDEP_ADD_ATTRIBUTE_CHANGE, Arrays.asList(ATTRIBUTE_LIST));
        RELEVANT_REFERENCES_BEFORE.put(MPatchPackage.Literals.INDEP_REMOVE_ATTRIBUTE_CHANGE, Arrays.asList(ATTRIBUTE_LIST));
        RELEVANT_REFERENCES_BEFORE.put(MPatchPackage.Literals.INDEP_UPDATE_ATTRIBUTE_CHANGE, Arrays.asList(ATTRIBUTE_LIST));
        RELEVANT_REFERENCES_BEFORE.put(MPatchPackage.Literals.INDEP_ADD_REFERENCE_CHANGE, Arrays.asList(ADD_REM_REFERENCE_LIST));
        RELEVANT_REFERENCES_BEFORE.put(MPatchPackage.Literals.INDEP_REMOVE_REFERENCE_CHANGE, Arrays.asList(ADD_REM_REFERENCE_LIST));
        RELEVANT_REFERENCES_BEFORE.put(MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE, Arrays.asList(UPDATE_REFERENCE_LIST_BEFORE));
        RELEVANT_REFERENCES_AFTER.put(MPatchPackage.Literals.INDEP_ADD_ELEMENT_CHANGE, Arrays.asList(ADD_REM_ELEMENT_LIST));
        RELEVANT_REFERENCES_AFTER.put(MPatchPackage.Literals.INDEP_REMOVE_ELEMENT_CHANGE, Arrays.asList(ADD_REM_ELEMENT_LIST));
        RELEVANT_REFERENCES_AFTER.put(MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE, Arrays.asList(MOVE_ELEMENT_LIST_AFTER));
        RELEVANT_REFERENCES_AFTER.put(MPatchPackage.Literals.INDEP_ADD_ATTRIBUTE_CHANGE, Arrays.asList(ATTRIBUTE_LIST));
        RELEVANT_REFERENCES_AFTER.put(MPatchPackage.Literals.INDEP_REMOVE_ATTRIBUTE_CHANGE, Arrays.asList(ATTRIBUTE_LIST));
        RELEVANT_REFERENCES_AFTER.put(MPatchPackage.Literals.INDEP_UPDATE_ATTRIBUTE_CHANGE, Arrays.asList(ATTRIBUTE_LIST));
        RELEVANT_REFERENCES_AFTER.put(MPatchPackage.Literals.INDEP_ADD_REFERENCE_CHANGE, Arrays.asList(ADD_REM_REFERENCE_LIST));
        RELEVANT_REFERENCES_AFTER.put(MPatchPackage.Literals.INDEP_REMOVE_REFERENCE_CHANGE, Arrays.asList(ADD_REM_REFERENCE_LIST));
        RELEVANT_REFERENCES_AFTER.put(MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE, Arrays.asList(UPDATE_REFERENCE_LIST_AFTER));
    }

    public ReferenceResolutionContentProvider(ResolvedSymbolicReferences mapping, AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.mapping = mapping;
    }

    public Object[] getChildren(Object object) {
        Object[] result;
        if (object instanceof MPatchModel) {
            result = super.getChildren(object);
        } else if (object instanceof ChangeGroup) {
            result = super.getChildren(object);
        } else if (object instanceof UnknownChange) {
            result = new Object[]{};
        } else if (object instanceof IndepChange) {
            IndepChange change = (IndepChange)object;
            result = this.getReferencesForChange(change);
        } else {
            result = new Object[]{};
        }
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2 = objectArray[n2];
            if (object2 == null) {
                throw new IllegalStateException("A child is null for object: " + object.toString() + " - Children: " + Arrays.asList(result));
            }
            ++n2;
        }
        return result;
    }

    private Object[] getReferencesForChange(IndepChange change) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        ResolvedSymbolicReferences.ValidationResult state = (ResolvedSymbolicReferences.ValidationResult)this.mapping.getValidation().get(change);
        List<EReference> relevantRefs = ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)state) ? RELEVANT_REFERENCES_AFTER.get(change.eClass()) : RELEVANT_REFERENCES_BEFORE.get(change.eClass());
        if (relevantRefs != null) {
            boolean skipCrossRefs;
            for (EReference eRef : relevantRefs) {
                Object ref = change.eGet((EStructuralFeature)eRef);
                if (ref == null || ref instanceof ModelDescriptorReference) continue;
                resultList.add(ref);
            }
            boolean bl = skipCrossRefs = change instanceof IndepAddRemElementChange && ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)state);
            if (!skipCrossRefs) {
                Map crossRefs = MPatchUtil.collectCrossReferences(Collections.singletonList(change));
                for (IElementReference symRef : crossRefs.keySet()) {
                    if (change.equals(symRef.eContainer()) || resultList.contains(symRef) || symRef instanceof ModelDescriptorReference) continue;
                    resultList.add(symRef);
                }
            }
        }
        return resultList.toArray();
    }

    public boolean hasChildren(Object object) {
        if (object instanceof IElementReference) {
            return false;
        }
        return super.hasChildren(object);
    }
}

