/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.impl;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.ModelDescriptorReference;
import org.eclipse.emf.compare.mpatch.UnknownChange;
import org.eclipse.emf.compare.mpatch.apply.generic.GenericApplyActivator;
import org.eclipse.emf.compare.mpatch.apply.util.MPatchValidator;
import org.eclipse.emf.compare.mpatch.common.util.OverlayImageDescriptor;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ReferenceResolutionLabelProvider
extends AdapterFactoryLabelProvider {
    public static final ImageDescriptor GREEN = ImageDescriptor.createFromURL((URL)GenericApplyActivator.getDefault().getBundle().getEntry("icons/green.png"));
    public static final ImageDescriptor BLUE = ImageDescriptor.createFromURL((URL)GenericApplyActivator.getDefault().getBundle().getEntry("icons/blue.png"));
    public static final ImageDescriptor RED = ImageDescriptor.createFromURL((URL)GenericApplyActivator.getDefault().getBundle().getEntry("icons/red.png"));
    public static final ImageDescriptor SHADED = ImageDescriptor.createFromURL((URL)GenericApplyActivator.getDefault().getBundle().getEntry("icons/shaded.png"));
    private final ResolvedSymbolicReferences mapping;

    public ReferenceResolutionLabelProvider(ResolvedSymbolicReferences mapping, AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.mapping = mapping;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.firstColumnImage(element);
        }
        if (element instanceof ChangeGroup) {
            return null;
        }
        if (element instanceof UnknownChange) {
            return null;
        }
        if (columnIndex == 1) {
            boolean forward;
            boolean bl = forward = this.mapping.getDirection() == 1;
            if (element instanceof ModelDescriptorReference) {
                return this.secondColumnDescriptorImage(element);
            }
            if (element instanceof IElementReference) {
                return this.secondColumnReferenceImage(element, forward);
            }
            if (element instanceof IndepChange) {
                return this.secondColumnChangeImage(element, forward);
            }
        }
        return null;
    }

    private Image secondColumnChangeImage(Object element, boolean forward) {
        ImageDescriptor img = null;
        IndepChange change = (IndepChange)element;
        if (this.mapping.getResolutionByChange().containsKey(change)) {
            for (IElementReference ref : ((Map)this.mapping.getResolutionByChange().get(change)).keySet()) {
                if (ref.eContainer() instanceof IModelDescriptor || MPatchValidator.validateResolution((IElementReference)ref, (Collection)((Collection)((Map)this.mapping.getResolutionByChange().get(change)).get(ref)))) continue;
                img = BLUE;
                break;
            }
            if (img == null) {
                ResolvedSymbolicReferences.ValidationResult actualState = (ResolvedSymbolicReferences.ValidationResult)this.mapping.getValidation().get(change);
                img = ResolvedSymbolicReferences.ValidationResult.STATE_BEFORE.equals((Object)actualState) ? GREEN : (ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)actualState) ? GREEN : RED);
            }
        } else {
            img = SHADED;
        }
        return img.createImage();
    }

    private Image secondColumnReferenceImage(Object element, boolean forward) {
        IElementReference ref = (IElementReference)element;
        IndepChange change = MPatchUtil.getChangeFor((IElementReference)ref);
        if (!this.mapping.getResolutionByChange().containsKey(change)) {
            return null;
        }
        ImageDescriptor img = this.mapping.getResolutionByChange().containsKey(change) ? (MPatchValidator.validateResolution((IElementReference)ref, (Collection)((Collection)((Map)this.mapping.getResolutionByChange().get(change)).get(ref))) ? GREEN : BLUE) : SHADED;
        return img.createImage();
    }

    private Image secondColumnDescriptorImage(Object element) {
        ModelDescriptorReference ref = (ModelDescriptorReference)element;
        IndepChange change = MPatchUtil.getChangeFor((IElementReference)ref);
        if (!this.mapping.getResolutionByChange().containsKey(change)) {
            return null;
        }
        IModelDescriptor descriptor = ref.getResolvesTo();
        IndepChange otherChange = MPatchUtil.getChangeFor((IElementReference)descriptor.getSelfReference());
        if (this.mapping.getResolutionByChange().containsKey(otherChange)) {
            return GREEN.createImage();
        }
        return RED.createImage();
    }

    private Image firstColumnImage(Object element) {
        IndepChange change;
        if (element instanceof ChangeGroup) {
            return super.getImage(element);
        }
        if (element instanceof IndepChange) {
            change = (IndepChange)element;
        } else if (element instanceof IElementReference) {
            change = MPatchUtil.getChangeFor((IElementReference)((IElementReference)element));
        } else {
            return super.getImage(element);
        }
        if (!this.mapping.getResolutionByChange().containsKey(change)) {
            return ReferenceResolutionLabelProvider.createOverlayImage((EObject)element, SHADED, this.adapterFactory);
        }
        return super.getImage(element);
    }

    protected static Image createOverlayImage(EObject obj, ImageDescriptor imageDescriptor, AdapterFactory adapterFactory) {
        IItemLabelProvider lp = (IItemLabelProvider)adapterFactory.adapt((Notifier)obj, IItemLabelProvider.class);
        ImageDescriptor imgDescr = ImageDescriptor.createFromImage((Image)ExtendedImageRegistry.getInstance().getImage(lp.getImage((Object)obj)));
        return new OverlayImageDescriptor(imgDescr.createImage(), imageDescriptor).createImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return super.getColumnText(element, columnIndex);
        }
        if (columnIndex == 1) {
            return this.secondColumnText(element);
        }
        if (columnIndex == 2) {
            boolean forward;
            boolean bl = forward = this.mapping.getDirection() == 1;
            if (element instanceof ChangeGroup) {
                return this.thirdColumnGroupText(element, forward);
            }
            if (element instanceof IndepChange) {
                return this.thirdColumnChangeText(element, forward);
            }
            if (element instanceof ModelDescriptorReference) {
                return this.thirdColumnDescriptorText(element);
            }
            if (element instanceof IElementReference) {
                return this.thirdColumnReferenceText(element);
            }
        }
        return "";
    }

    private String thirdColumnReferenceText(Object element) {
        IElementReference ref = (IElementReference)element;
        IndepChange change = MPatchUtil.getChangeFor((IElementReference)ref);
        if (!this.mapping.getResolutionByChange().containsKey(change)) {
            return "";
        }
        if (this.mapping.getResolutionByChange().containsKey(change)) {
            String list = "";
            if (((Map)this.mapping.getResolutionByChange().get(change)).get(ref) != null) {
                for (EObject obj : (List)((Map)this.mapping.getResolutionByChange().get(change)).get(ref)) {
                    list = String.valueOf(list) + (list.length() == 0 ? "" : ", ") + this.getText(obj);
                }
            }
            return "[" + list + "]";
        }
        return "";
    }

    private String thirdColumnDescriptorText(Object element) {
        ModelDescriptorReference ref = (ModelDescriptorReference)element;
        IndepChange change = MPatchUtil.getChangeFor((IElementReference)ref);
        if (!this.mapping.getResolutionByChange().containsKey(change)) {
            return "";
        }
        IModelDescriptor descriptor = ref.getResolvesTo();
        IndepChange otherChange = MPatchUtil.getChangeFor((IElementReference)descriptor.getSelfReference());
        if (this.mapping.getResolutionByChange().containsKey(otherChange)) {
            return "ok";
        }
        return "depending change missing";
    }

    private String thirdColumnChangeText(Object element, boolean forward) {
        if (this.mapping.getResolutionByChange().containsKey(element)) {
            ResolvedSymbolicReferences.ValidationResult state = (ResolvedSymbolicReferences.ValidationResult)this.mapping.getValidation().get(element);
            if (element instanceof IndepAddElementChange) {
                IndepAddElementChange change = (IndepAddElementChange)element;
                List selfRef = (List)((Map)this.mapping.getResolutionByChange().get(change)).get(change.getSubModelReference());
                if (selfRef == null || selfRef.size() == 0) {
                    return (String)ResolvedSymbolicReferences.VALIDATION_RESULTS.get(state);
                }
                String list = "";
                for (EObject obj : selfRef) {
                    list = String.valueOf(list) + (list.length() == 0 ? "" : ", ") + this.getText(obj);
                }
                return "bound: [" + list + "]";
            }
            return (String)ResolvedSymbolicReferences.VALIDATION_RESULTS.get(state);
        }
        return "ignored";
    }

    private String thirdColumnGroupText(Object element, boolean forward) {
        ChangeGroup group = (ChangeGroup)element;
        int resolved = 0;
        int ignored = 0;
        int failed = 0;
        Set<EClass> types = Collections.singleton(MPatchPackage.eINSTANCE.getIndepChange());
        List changes = ExtEcoreUtils.collectTypedElements((List)group.getSubChanges(), types, (boolean)true);
        for (EObject change : changes) {
            ResolvedSymbolicReferences.ValidationResult actualState = (ResolvedSymbolicReferences.ValidationResult)this.mapping.getValidation().get(change);
            if (!this.mapping.getResolutionByChange().containsKey(change)) {
                ++ignored;
                continue;
            }
            if (!ResolvedSymbolicReferences.ValidationResult.STATE_BEFORE.equals((Object)actualState) && !ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)actualState)) {
                ++failed;
                continue;
            }
            ++resolved;
        }
        return "resolved: " + resolved + "; ignored: " + ignored + "; failed: " + failed;
    }

    private String secondColumnText(Object element) {
        if (element instanceof IElementReference && !(element instanceof ModelDescriptorReference)) {
            IElementReference ref = (IElementReference)element;
            IndepChange change = MPatchUtil.getChangeFor((IElementReference)ref);
            if (this.mapping.getResolutionByChange().containsKey(change)) {
                if (((Map)this.mapping.getResolutionByChange().get(change)).get(ref) != null) {
                    return String.valueOf(((List)((Map)this.mapping.getResolutionByChange().get(change)).get(ref)).size());
                }
                return "0";
            }
            return "";
        }
        return "";
    }
}

