/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.UnknownChange;
import org.eclipse.emf.compare.mpatch.apply.util.MPatchValidator;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPatchResolver {
    public static final int RESOLVE_UNCHANGED = 1;
    public static final int RESOLVE_CHANGED = 2;

    public static ResolvedSymbolicReferences resolveSymbolicReferences(MPatchModel mpatch, EObject model, int direction) {
        HashMap<IElementReference, List<EObject>> rawResult = new HashMap<IElementReference, List<EObject>>();
        LinkedHashMap<IndepChange, Map<IElementReference, List<EObject>>> resolution = new LinkedHashMap<IndepChange, Map<IElementReference, List<EObject>>>();
        LinkedHashMap equalRefs = new LinkedHashMap();
        LinkedHashMap validation = new LinkedHashMap();
        ResolvedSymbolicReferences result = new ResolvedSymbolicReferences(mpatch, model, direction, resolution, rawResult, equalRefs, validation);
        MPatchResolver.resolveRawSymbolicReferences(result);
        for (IndepChange change : mpatch.getChanges()) {
            MPatchResolver.analyzeChange(change, rawResult, direction, resolution);
        }
        boolean forward = direction == 1;
        List<IndepChange> orderedChanges = MPatchValidator.orderChanges(result.getResolutionByChange().keySet(), forward);
        for (IndepChange change : orderedChanges) {
            MPatchResolver.checkStateResolution(change, result, false, forward);
        }
        return result;
    }

    protected static void resolveRawSymbolicReferences(ResolvedSymbolicReferences result) {
        List references = ExtEcoreUtils.collectTypedElements((List)result.getMPatchModel().getChanges(), Collections.singleton(MPatchPackage.Literals.IELEMENT_REFERENCE), (boolean)true);
        for (EObject obj : references) {
            IElementReference ref = (IElementReference)obj;
            Object resolution = null;
            Map equallyResolvingRefs = result.getEquallyResolvingReferences();
            for (IElementReference ref2 : equallyResolvingRefs.keySet()) {
                if (!ref.resolvesEqual(ref2)) continue;
                MPatchUtil.addElementToListMap((Object)ref2, (Object)ref, (Map)equallyResolvingRefs);
                equallyResolvingRefs.put(ref, (List)equallyResolvingRefs.get(ref2));
                resolution = new ArrayList((Collection)result.getRawResolution().get(ref2));
                break;
            }
            if (resolution == null) {
                resolution = ref.resolve(result.getModel());
                MPatchUtil.addElementToListMap((Object)ref, (Object)ref, (Map)equallyResolvingRefs);
            }
            result.getRawResolution().put(ref, resolution);
        }
    }

    protected static void analyzeChange(IndepChange change, Map<IElementReference, List<EObject>> rawResult, int direction, Map<IndepChange, Map<IElementReference, List<EObject>>> accumulator) {
        if (change instanceof ChangeGroup) {
            ChangeGroup group = (ChangeGroup)change;
            for (IndepChange subChange : group.getSubChanges()) {
                MPatchResolver.analyzeChange(subChange, rawResult, direction, accumulator);
            }
        } else if (!(change instanceof UnknownChange)) {
            HashMap<IElementReference, List<EObject>> map = new HashMap<IElementReference, List<EObject>>();
            Collection<EReference> importantRefs = MPatchValidator.getImportantReferencesFor(change.eClass(), direction);
            for (EReference ref : importantRefs) {
                IElementReference symRef = (IElementReference)change.eGet((EStructuralFeature)ref);
                if (symRef == null) continue;
                map.put(symRef, rawResult.get(symRef));
            }
            Map crossRefs = MPatchUtil.collectCrossReferences(Collections.singletonList(change));
            for (IElementReference symRef : crossRefs.keySet()) {
                if (symRef == null || map.containsKey(symRef)) continue;
                map.put(symRef, rawResult.get(symRef));
            }
            accumulator.put(change, map);
        }
    }

    public static boolean checkStateResolution(IndepChange change, ResolvedSymbolicReferences mapping, boolean reduce, boolean forward) {
        Map changeMapping = (Map)mapping.getResolutionByChange().get(change);
        ResolvedSymbolicReferences.ValidationResult allValidStates = MPatchValidator.validateElementState(change, mapping, true, forward);
        switch (allValidStates) {
            case STATE_BEFORE: {
                List resolvedAdditions;
                if (change instanceof IndepAddElementChange && (resolvedAdditions = (List)changeMapping.get(((IndepAddElementChange)change).getSubModelReference())) != null && !resolvedAdditions.isEmpty()) {
                    resolvedAdditions.clear();
                }
                return true;
            }
            case STATE_AFTER: {
                return true;
            }
            case UNKNOWN_CHANGE: {
                return false;
            }
            case STATE_INVALID: {
                if (((List)changeMapping.get(change.getCorrespondingElement())).size() <= 1) {
                    return false;
                }
                ResolvedSymbolicReferences.ValidationResult anyValidState = MPatchValidator.validateElementState(change, mapping, false, forward);
                if (ResolvedSymbolicReferences.ValidationResult.STATE_BEFORE.equals((Object)anyValidState) || ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)anyValidState)) {
                    return MPatchResolver.filterValidStates(change, mapping, change.getCorrespondingElement().getUpperBound(), reduce, forward);
                }
                return false;
            }
            case REFERENCE: {
                IElementReference symref = change.getCorrespondingElement();
                List elements = (List)changeMapping.get(symref);
                if (elements == null || elements.isEmpty()) {
                    return false;
                }
                boolean valid = MPatchValidator.validateResolution(symref, elements);
                if (valid) {
                    return false;
                }
                if (symref.getUpperBound() < elements.size() && elements.size() > 1) {
                    return MPatchResolver.filterValidStates(change, mapping, symref.getUpperBound(), reduce, forward);
                }
                return false;
            }
        }
        throw new RuntimeException("Unknown status value received: " + allValidStates);
    }

    private static boolean filterValidStates(IndepChange change, ResolvedSymbolicReferences mapping, int maxElements, boolean reduce, boolean forward) {
        Map changeMapping = (Map)mapping.getResolutionByChange().get(change);
        List resolvedElements = (List)changeMapping.get(change.getCorrespondingElement());
        ArrayList allResolvedElements = new ArrayList(resolvedElements);
        ArrayList<EObject> beforeElements = new ArrayList<EObject>(resolvedElements.size());
        ArrayList<EObject> afterElements = new ArrayList<EObject>(resolvedElements.size());
        for (EObject element : allResolvedElements) {
            resolvedElements.clear();
            resolvedElements.add(element);
            ResolvedSymbolicReferences.ValidationResult state = MPatchValidator.validateElementState(change, mapping, true, forward);
            if (ResolvedSymbolicReferences.ValidationResult.STATE_BEFORE.equals((Object)state)) {
                beforeElements.add(element);
                continue;
            }
            if (!ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)state)) continue;
            afterElements.add(element);
        }
        resolvedElements.clear();
        ArrayList<EObject> validElements = beforeElements.isEmpty() ? afterElements : beforeElements;
        int count = reduce ? Math.min(maxElements, validElements.size()) : validElements.size();
        int i = 0;
        while (i < count) {
            resolvedElements.add((EObject)validElements.get(i));
            ++i;
        }
        return !resolvedElements.isEmpty();
    }
}

