/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class ApplyWizardNewEmfdiffPage
extends WizardNewFileCreationPage {
    private static final String FILE_EXTENSION = "emfdiff";

    public ApplyWizardNewEmfdiffPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(pageName);
        this.setDescription("Please select a file to store the emfdiff.");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
        }
    }

    private void initialize() {
        if (this.getFileName() == null || this.getFileName().length() == 0) {
            URI uri = ((ApplyWizard)this.getWizard()).getMPatch().eResource().getURI();
            String filename = uri.lastSegment();
            this.setFileName(String.valueOf(filename.substring(0, filename.lastIndexOf(".") + 1)) + FILE_EXTENSION);
        }
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String extension = new Path(this.getFileName()).getFileExtension();
            if (extension == null || !FILE_EXTENSION.equals(extension)) {
                this.setErrorMessage("Wrong file extension! 'emfdiff' expected.");
                return false;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
            ((ApplyWizard)this.getWizard()).setEmfdiff(file);
            return true;
        }
        return false;
    }
}

