/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class ApplyWizardNewModelPage
extends WizardNewFileCreationPage {
    public ApplyWizardNewModelPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(pageName);
        this.setDescription("Please select a file to store a copy of the model, e.g. for reviewing the changes made to the model.");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
        }
    }

    private void initialize() {
        if (this.getFileName() == null || this.getFileName().length() == 0) {
            URI uri = ((ApplyWizard)this.getWizard()).getModelResource().getURI();
            this.setFileName(String.valueOf(uri.trimFileExtension().lastSegment()) + "_copy." + uri.fileExtension());
        }
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String expectedExtension = ((ApplyWizard)this.getWizard()).getModelResource().getURI().fileExtension();
            String actualExtension = new Path(this.getFileName()).getFileExtension();
            if (actualExtension == null || !actualExtension.equals(expectedExtension)) {
                this.setErrorMessage("Wrong file extension! '" + expectedExtension + "' expected (same as input model).");
                return false;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
            ((ApplyWizard)this.getWizard()).setNewModelFile(file);
            return true;
        }
        return false;
    }
}

