/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class ApplyWizardSaveBindingPage
extends WizardNewFileCreationPage {
    private static final String DIFFBINDING_EXTENSION = "binding";

    public ApplyWizardSaveBindingPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(pageName);
        this.setDescription("Please select a file to store the binding between the MPatch and the model.");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
        }
    }

    private void initialize() {
        if (this.getFileName() == null || this.getFileName().length() == 0) {
            URI uri = ((ApplyWizard)this.getWizard()).getModelResource().getURI();
            this.setFileName(String.valueOf(uri.trimFileExtension().lastSegment()) + "." + DIFFBINDING_EXTENSION);
        }
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String actualExtension = new Path(this.getFileName()).getFileExtension();
            if (actualExtension == null || !actualExtension.equals(DIFFBINDING_EXTENSION)) {
                this.setErrorMessage("Wrong file extension! 'binding' expected.");
                return false;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
            ((ApplyWizard)this.getWizard()).setBindingFile(file);
            return true;
        }
        return false;
    }
}

