/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.common.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractCompareAction
implements IObjectActionDelegate {
    private IFile file;
    private Shell shell;
    private final String inputFileExtension;
    private final String outputFileExtension;
    private final String jobTitle;

    public AbstractCompareAction(String inputFileExtension, String outputFileExtension, String jobTitle) {
        this.inputFileExtension = inputFileExtension;
        this.outputFileExtension = outputFileExtension;
        this.jobTitle = jobTitle;
    }

    protected IFile promptFileDestination(IPath suggestedPath) {
        Shell shell = this.shell == null ? new Shell() : this.shell;
        String message = "Please select a folder where to store the output file.";
        IFile file = WorkspaceResourceDialog.openNewFile((Shell)shell, (String)"Save output file...", (String)"Please select a folder where to store the output file.", (IPath)suggestedPath, null);
        if (file != null) {
            if (file.exists()) {
                MessageDialog dialog = new MessageDialog(shell, "File already exists...", null, "The file '" + file.getName() + "' already exists in the specified folder.", 0, new String[]{"Overwrite", "Prompt again", "Cancel"}, 0);
                switch (dialog.open()) {
                    case 0: {
                        return file;
                    }
                    case 1: {
                        return this.promptFileDestination(file.getFullPath());
                    }
                }
                return null;
            }
            return file;
        }
        return null;
    }

    public void run(IAction action) {
        if (this.file != null) {
            final Resource diffResource = new ResourceSetImpl().getResource(URI.createFileURI((String)this.file.getFullPath().toString()), true);
            IPath path = this.file.getFullPath().removeFileExtension().addFileExtension(this.outputFileExtension);
            final IFile newFile = this.promptFileDestination(path);
            if (newFile != null) {
                Job job = new Job(this.jobTitle){

                    protected IStatus run(IProgressMonitor monitor) {
                        XMIResourceImpl resource = new XMIResourceImpl(URI.createURI((String)newFile.getFullPath().toString()));
                        final Status status = AbstractCompareAction.this.runAction(diffResource, (Resource)resource, monitor);
                        if (status.getSeverity() == 0) {
                            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    MessageDialog.openInformation((Shell)AbstractCompareAction.this.shell, (String)"Transformation successful", (String)status.getMessage());
                                }
                            });
                        } else {
                            StatusManager.getManager().handle((IStatus)status, 2);
                        }
                        return status;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        }
    }

    protected abstract Status runAction(Resource var1, Resource var2, IProgressMonitor var3);

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof IFile) {
                this.file = (IFile)structuredSelection.getFirstElement();
                if (!this.inputFileExtension.equals(this.file.getFileExtension())) {
                    this.file = null;
                }
            } else {
                this.file = null;
            }
        } else {
            this.file = null;
        }
        action.setEnabled(this.file != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

