/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.common.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.mpatch.common.CommonMPatchPlugin;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.common.util.ExtensionManager;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListDialog;
import org.osgi.service.prefs.BackingStoreException;

public class MPatchPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFERENCES_KEY_TRANSFORMATION_ORDER = "transformation.order";
    public static final String PREFERENCES_KEY_SHOW_TRANSFORMATIONS = "transformations.hide";
    public static final String PREFERENCES_KEY_RESOLUTION = "resolution";
    public static final String PREFERENCES_KEY_APPLICATION = "application";
    public static final String PREFERENCES_KEY_SYMBOLIC_REFERENCE = "symbolic.reference";
    public static final String PREFERENCES_KEY_MODEL_DESCRIPTOR = "model.descriptor";
    public static final String PREFERENCES_DESCRIPTION_TRANSFORMATION_ORDER = "Default selection and order of optional transformations";
    public static final String PREFERENCES_DESCRIPTION_SHOW_TRANSFORMATIONS = "Show mandatory transformations in MPatch creation wizard";
    public static final String PREFERENCES_DESCRIPTION_RESOLUTION = "Default symbolic reference resolution";
    public static final String PREFERENCES_DESCRIPTION_APPLICATION = "Default difference applier";
    public static final String PREFERENCES_DESCRIPTION_SYMBOLIC_REFERENCE = "Default symbolic reference creator";
    public static final String PREFERENCES_DESCRIPTION_MODEL_DESCRIPTOR = "Default model description creator";
    public static final String PREFERENCES_LABEL = "Settings for MPatch, a model patching technology based on EMF Compare.";
    public static final String PREFERENCES_LABEL_DIFFAPPLYGROUP = "MPatch Application";
    public static final String PREFERENCES_LABEL_DIFFCREATEGROUP = "MPatch Creation";
    public static final String PREFERENCES_LABEL_TRANSFORMATIONS = "Transformation Details";
    public static final String PREFERENCES_LABEL_TRANSFLIST = "Select Transformation";
    public static final String PREFERENCES_TRANSFORMATION_SEPERATOR = ":";

    public MPatchPreferencesPage() {
        super("MPatch", null, 1);
        this.setPreferenceStore(CommonMPatchPlugin.getDefault().getPreferenceStore());
        this.setDescription(PREFERENCES_LABEL);
    }

    protected void createFieldEditors() {
        this.createDiffCreationGroup();
        this.createDiffApplicationGroup();
    }

    protected void createDiffApplicationGroup() {
        Group diffApplicationGroup = new Group(this.getFieldEditorParent(), 16);
        diffApplicationGroup.setText(PREFERENCES_LABEL_DIFFAPPLYGROUP);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.verticalIndent = 10;
        diffApplicationGroup.setLayoutData((Object)gd);
        ArrayList<String[]> comboboxValues = new ArrayList<String[]>();
        for (String res : ExtensionManager.getAllResolutions().keySet()) {
            comboboxValues.add(new String[]{res, res});
        }
        this.addField((FieldEditor)new ComboFieldEditor(PREFERENCES_KEY_RESOLUTION, PREFERENCES_DESCRIPTION_RESOLUTION, (String[][])comboboxValues.toArray((T[])new String[0][0]), (Composite)diffApplicationGroup));
        comboboxValues.clear();
        for (String app : ExtensionManager.getAllApplications().keySet()) {
            comboboxValues.add(new String[]{app, app});
        }
        this.addField((FieldEditor)new ComboFieldEditor(PREFERENCES_KEY_APPLICATION, PREFERENCES_DESCRIPTION_APPLICATION, (String[][])comboboxValues.toArray((T[])new String[0][0]), (Composite)diffApplicationGroup));
    }

    protected void createDiffCreationGroup() {
        Group diffCreationGroup = new Group(this.getFieldEditorParent(), 64);
        diffCreationGroup.setText(PREFERENCES_LABEL_DIFFCREATEGROUP);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.verticalIndent = 10;
        diffCreationGroup.setLayoutData((Object)gd);
        this.addField((FieldEditor)new TransformationListEditor(PREFERENCES_KEY_TRANSFORMATION_ORDER, PREFERENCES_DESCRIPTION_TRANSFORMATION_ORDER, (Composite)diffCreationGroup));
        this.addField((FieldEditor)new BooleanFieldEditor(PREFERENCES_KEY_SHOW_TRANSFORMATIONS, PREFERENCES_DESCRIPTION_SHOW_TRANSFORMATIONS, (Composite)diffCreationGroup));
        ArrayList<String[]> comboboxValues = new ArrayList<String[]>();
        for (String symrefs : ExtensionManager.getAllSymbolicReferenceCreators().keySet()) {
            comboboxValues.add(new String[]{symrefs, symrefs});
        }
        this.addField((FieldEditor)new ComboFieldEditor(PREFERENCES_KEY_SYMBOLIC_REFERENCE, PREFERENCES_DESCRIPTION_SYMBOLIC_REFERENCE, (String[][])comboboxValues.toArray((T[])new String[0][0]), (Composite)diffCreationGroup));
        comboboxValues.clear();
        for (String modeldescr : ExtensionManager.getAllModelDescriptorCreators().keySet()) {
            comboboxValues.add(new String[]{modeldescr, modeldescr});
        }
        this.addField((FieldEditor)new ComboFieldEditor(PREFERENCES_KEY_MODEL_DESCRIPTOR, PREFERENCES_DESCRIPTION_MODEL_DESCRIPTOR, (String[][])comboboxValues.toArray((T[])new String[0][0]), (Composite)diffCreationGroup));
    }

    public void init(IWorkbench workbench) {
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(MPatchPreferencesPage.PREFERENCES_KEY_TRANSFORMATION_ORDER) || event.getProperty().equals(MPatchPreferencesPage.PREFERENCES_KEY_SHOW_TRANSFORMATIONS) || event.getProperty().equals(MPatchPreferencesPage.PREFERENCES_KEY_APPLICATION) || event.getProperty().equals(MPatchPreferencesPage.PREFERENCES_KEY_RESOLUTION) || event.getProperty().equals(MPatchPreferencesPage.PREFERENCES_KEY_SYMBOLIC_REFERENCE) || event.getProperty().equals(MPatchPreferencesPage.PREFERENCES_KEY_MODEL_DESCRIPTOR)) {
                    MPatchPreferencesPage.this.reflectOnCore();
                }
            }
        });
    }

    protected void reflectOnCore() {
        IEclipsePreferences corePreferences = new InstanceScope().getNode("org.eclipse.emf.compare.mpatch");
        corePreferences.put(PREFERENCES_KEY_TRANSFORMATION_ORDER, this.getPreferenceStore().getString(PREFERENCES_KEY_TRANSFORMATION_ORDER));
        corePreferences.putBoolean(PREFERENCES_KEY_SHOW_TRANSFORMATIONS, this.getPreferenceStore().getBoolean(PREFERENCES_KEY_SHOW_TRANSFORMATIONS));
        corePreferences.put(PREFERENCES_KEY_RESOLUTION, this.getPreferenceStore().getString(PREFERENCES_KEY_RESOLUTION));
        corePreferences.put(PREFERENCES_KEY_APPLICATION, this.getPreferenceStore().getString(PREFERENCES_KEY_APPLICATION));
        corePreferences.put(PREFERENCES_KEY_SYMBOLIC_REFERENCE, this.getPreferenceStore().getString(PREFERENCES_KEY_SYMBOLIC_REFERENCE));
        corePreferences.put(PREFERENCES_KEY_MODEL_DESCRIPTOR, this.getPreferenceStore().getString(PREFERENCES_KEY_MODEL_DESCRIPTOR));
        try {
            corePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private final class TransformationListEditor
    extends ListEditor {
        private Text infoText;

        private TransformationListEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
            Group group = new Group(parent, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = numColumns;
            gd.heightHint = 50;
            group.setLayoutData((Object)gd);
            group.setText(MPatchPreferencesPage.PREFERENCES_LABEL_TRANSFORMATIONS);
            group.setLayout((Layout)new FillLayout());
            this.infoText = new Text((Composite)group, 584);
            this.getList().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String info = "";
                    if (TransformationListEditor.this.getList().getSelectionCount() == 1) {
                        String selection = TransformationListEditor.this.getList().getSelection()[0];
                        IMPatchTransformation transformation = ExtensionManager.getAllTransformations().get(selection);
                        if (transformation != null) {
                            info = transformation.getDescription();
                        }
                    }
                    TransformationListEditor.this.infoText.setText(info);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        protected String[] parseString(String stringList) {
            if (stringList == null || stringList.length() == 0) {
                return new String[0];
            }
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(stringList.split(MPatchPreferencesPage.PREFERENCES_TRANSFORMATION_SEPERATOR)));
            Map<String, IMPatchTransformation> allTransformations = ExtensionManager.getAllTransformations();
            list.retainAll(allTransformations.keySet());
            int i = list.size() - 1;
            while (i >= 0) {
                if (!allTransformations.get(list.get(i)).isOptional()) {
                    list.remove(i);
                }
                --i;
            }
            return list.toArray(new String[list.size()]);
        }

        protected String getNewInputObject() {
            Map<String, IMPatchTransformation> allTransformations = ExtensionManager.getAllTransformations();
            ArrayList<String> optionalTransformations = new ArrayList<String>();
            for (IMPatchTransformation transformation : allTransformations.values()) {
                if (!transformation.isOptional()) continue;
                optionalTransformations.add(transformation.getLabel());
            }
            List<String> preferencesList = Arrays.asList(this.getList().getItems());
            if (optionalTransformations.size() > preferencesList.size()) {
                optionalTransformations.removeAll(preferencesList);
                ListDialog dialog = new ListDialog(this.getShell());
                dialog.setTitle(MPatchPreferencesPage.PREFERENCES_LABEL_TRANSFLIST);
                dialog.setBlockOnOpen(true);
                dialog.setAddCancelButton(true);
                dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                dialog.setInput((Object)optionalTransformations.toArray());
                if (dialog.open() == 0 && dialog.getResult().length > 0) {
                    return (String)dialog.getResult()[0];
                }
                return null;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)"No further Transformations available...", (String)"No more Transformations are registered.");
            return null;
        }

        protected String createList(String[] items) {
            return CommonUtils.join(items, (CharSequence)MPatchPreferencesPage.PREFERENCES_TRANSFORMATION_SEPERATOR);
        }
    }
}

