/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.compare.mpatch.MPatchFactory;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.provider.MPatchEditPlugin;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPatchModelItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public static final String copyright = "Copyright (c) 2010, 2011 Technical University of Denmark.\r\nAll rights reserved. This program and the accompanying materials \r\nare made available under the terms of the Eclipse Public License v1.0 \r\nwhich accompanies this distribution, and is available at \r\nhttp://www.eclipse.org/legal/epl-v10.html \r\n\r\nContributors:\r\n   Patrick Koenemann, DTU Informatics - initial API and implementation";

    public MPatchModelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addOldModelPropertyDescriptor(object);
            this.addNewModelPropertyDescriptor(object);
            this.addEmfdiffPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addOldModelPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_MPatchModel_oldModel_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_MPatchModel_oldModel_feature", "_UI_MPatchModel_type"), (EStructuralFeature)MPatchPackage.Literals.MPATCH_MODEL__OLD_MODEL, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNewModelPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_MPatchModel_newModel_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_MPatchModel_newModel_feature", "_UI_MPatchModel_type"), (EStructuralFeature)MPatchPackage.Literals.MPATCH_MODEL__NEW_MODEL, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addEmfdiffPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_MPatchModel_emfdiff_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_MPatchModel_emfdiff_feature", "_UI_MPatchModel_type"), (EStructuralFeature)MPatchPackage.Literals.MPATCH_MODEL__EMFDIFF, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(MPatchPackage.Literals.MPATCH_MODEL__CHANGES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/MPatchModel"));
    }

    public String getText(Object object) {
        String label = ((MPatchModel)object).getEmfdiff();
        String oldModel = ((MPatchModel)object).getOldModel();
        String newModel = ((MPatchModel)object).getNewModel();
        String string = label = label == null || label.length() == 0 ? "" : label.substring(label.lastIndexOf("/"));
        if (oldModel != null && oldModel.length() > 0 && newModel != null && newModel.length() > 0) {
            label = String.valueOf(oldModel.substring(oldModel.lastIndexOf("/") + 1)) + "  -->   " + newModel.substring(newModel.lastIndexOf("/") + 1) + (label.length() > 0 ? "  (" + label + ")" : "");
        }
        return String.valueOf(this.getString("_UI_MPatchModel_type")) + (label.length() == 0 ? "" : ":   " + label);
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(MPatchModel.class)) {
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 0: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createChangeGroup()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createIndepAddElementChange()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createIndepRemoveElementChange()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createIndepMoveElementChange()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createIndepAddAttributeChange()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createIndepRemoveAttributeChange()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createIndepUpdateAttributeChange()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createIndepAddReferenceChange()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createIndepRemoveReferenceChange()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createIndepUpdateReferenceChange()));
        newChildDescriptors.add(this.createChildParameter(MPatchPackage.Literals.MPATCH_MODEL__CHANGES, MPatchFactory.eINSTANCE.createUnknownChange()));
    }

    public ResourceLocator getResourceLocator() {
        return MPatchEditPlugin.INSTANCE;
    }
}

