/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.mpatch.MPatchFactory;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.presentation.MPatchEditorPlugin;
import org.eclipse.emf.compare.mpatch.provider.MPatchEditPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPatchModelWizard
extends Wizard
implements INewWizard {
    public static final String copyright = "Copyright (c) 2010, 2011 Technical University of Denmark.\r\nAll rights reserved. This program and the accompanying materials \r\nare made available under the terms of the Eclipse Public License v1.0 \r\nwhich accompanies this distribution, and is available at \r\nhttp://www.eclipse.org/legal/epl-v10.html \r\n\r\nContributors:\r\n   Patrick Koenemann, DTU Informatics - initial API and implementation";
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(MPatchEditorPlugin.INSTANCE.getString("_UI_MPatchEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = MPatchEditorPlugin.INSTANCE.getString("_UI_MPatchEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected MPatchPackage mPatchPackage = MPatchPackage.eINSTANCE;
    protected MPatchFactory mPatchFactory = this.mPatchPackage.getMPatchFactory();
    protected MPatchModelWizardNewFileCreationPage newFileCreationPage;
    protected MPatchModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(MPatchEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(MPatchEditorPlugin.INSTANCE.getImage("full/wizban/NewMPatch")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.mPatchPackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        EClass eClass = (EClass)this.mPatchPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        EObject rootObject = this.mPatchFactory.create(eClass);
        return rootObject;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = MPatchModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", MPatchModelWizard.this.initialObjectCreationPage.getEncoding());
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            MPatchEditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)MPatchEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            MPatchEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new MPatchModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(MPatchEditorPlugin.INSTANCE.getString("_UI_MPatchModelWizard_label"));
        this.newFileCreationPage.setDescription(MPatchEditorPlugin.INSTANCE.getString("_UI_MPatchModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(MPatchEditorPlugin.INSTANCE.getString("_UI_MPatchEditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = MPatchEditorPlugin.INSTANCE.getString("_UI_MPatchEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new MPatchModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(MPatchEditorPlugin.INSTANCE.getString("_UI_MPatchModelWizard_label"));
        this.initialObjectCreationPage.setDescription(MPatchEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MPatchModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public MPatchModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MPatchModelWizardInitialObjectCreationPage.this.setPageComplete(MPatchModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(MPatchEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.initialObjectField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data);
            for (String objectName : MPatchModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(objectName));
            }
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.select(0);
            }
            this.initialObjectField.addModifyListener(this.validator);
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(MPatchEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data2);
            this.encodingField = new Combo(composite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data2);
            for (String encoding : this.getEncodings()) {
                this.encodingField.add(encoding);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                    this.encodingField.setFocus();
                } else {
                    this.encodingField.clearSelection();
                    this.initialObjectField.setFocus();
                }
            }
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            for (String name : MPatchModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        protected String getLabel(String typeName) {
            try {
                return MPatchEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
            }
            catch (MissingResourceException mre) {
                MPatchEditorPlugin.INSTANCE.log(mre);
                return typeName;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(MPatchEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }

    public class MPatchModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public MPatchModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(MPatchEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

