/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.generic.impl;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.descriptor.DescriptorFactory;
import org.eclipse.emf.compare.mpatch.descriptor.EMFModelDescriptor;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.generic.util.QvtlibHelper;
import org.eclipse.emf.compare.mpatch.extension.IModelDescriptorCreator;
import org.eclipse.emf.compare.mpatch.extension.ISymbolicReferenceCreator;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelDescriptorCreator
implements IModelDescriptorCreator {
    public IModelDescriptor toModelDescriptor(EObject self, boolean serializable, ISymbolicReferenceCreator symbolicReferenceCreator) {
        EMFModelDescriptor descriptor = DescriptorFactory.eINSTANCE.createEMFModelDescriptor();
        descriptor.setType(self.eClass());
        descriptor.setDescriptorUri(symbolicReferenceCreator.getUriString(self));
        descriptor.setSelfReference(symbolicReferenceCreator.toSymbolicReference(self));
        descriptor.getSubDescriptors().putAll(this.extractSubElements(self, serializable, symbolicReferenceCreator));
        descriptor.getAttributes().putAll(this.extractAttributes(self, serializable));
        descriptor.getReferences().putAll(this.extractReferences(self, serializable, symbolicReferenceCreator));
        return descriptor;
    }

    protected EMap<EReference, EList<EMFModelDescriptor>> extractSubElements(EObject obj, boolean serializable, ISymbolicReferenceCreator symbolicReferenceCreator) {
        BasicEMap result = new BasicEMap();
        for (EReference containment : obj.eClass().getEAllContainments()) {
            if (!this.evaluateSerializable(serializable, (EStructuralFeature)containment)) continue;
            BasicEList containments = new BasicEList();
            if (containment.isMany()) {
                for (EObject listObj : (EList)obj.eGet((EStructuralFeature)containment)) {
                    containments.add((Object)((EMFModelDescriptor)this.toModelDescriptor(listObj, serializable, symbolicReferenceCreator)));
                }
            } else if (obj.eGet((EStructuralFeature)containment) != null) {
                containments.add((Object)((EMFModelDescriptor)this.toModelDescriptor((EObject)obj.eGet((EStructuralFeature)containment), serializable, symbolicReferenceCreator)));
            }
            if (containments.isEmpty()) continue;
            result.put((Object)containment, (Object)containments);
        }
        return result;
    }

    protected EMap<EReference, EList<IElementReference>> extractReferences(EObject obj, boolean serializable, ISymbolicReferenceCreator symbolicReferenceCreator) {
        BasicEMap result = new BasicEMap();
        for (EReference reference : obj.eClass().getEAllReferences()) {
            if (reference.isContainment() || reference.isContainer() || !this.evaluateSerializable(serializable, (EStructuralFeature)reference)) continue;
            BasicEList references = new BasicEList();
            if (reference.isMany()) {
                for (EObject listObj : (EList)obj.eGet((EStructuralFeature)reference)) {
                    references.add((Object)symbolicReferenceCreator.toSymbolicReference(listObj));
                }
            } else if (obj.eGet((EStructuralFeature)reference) != null) {
                references.add((Object)symbolicReferenceCreator.toSymbolicReference((EObject)obj.eGet((EStructuralFeature)reference)));
            }
            if (references.isEmpty()) continue;
            result.put((Object)reference, (Object)references);
        }
        return result;
    }

    protected EMap<EAttribute, EList<Object>> extractAttributes(EObject obj, boolean serializable) {
        BasicEMap result = new BasicEMap();
        for (EAttribute attribute : obj.eClass().getEAllAttributes()) {
            if (!this.evaluateSerializable(serializable, (EStructuralFeature)attribute)) continue;
            BasicEList values = new BasicEList();
            if (attribute.isMany()) {
                for (Object listObj : (EList)obj.eGet((EStructuralFeature)attribute)) {
                    values.add(this.deepCloneRequired(attribute) ? this.clone(listObj, attribute.getEAttributeType()) : listObj);
                }
            } else if (obj.eGet((EStructuralFeature)attribute) != null && !obj.eGet((EStructuralFeature)attribute).equals(attribute.getDefaultValue())) {
                values.add(this.deepCloneRequired(attribute) ? this.clone(obj.eGet((EStructuralFeature)attribute), attribute.getEAttributeType()) : obj.eGet((EStructuralFeature)attribute));
            }
            if (values.isEmpty()) continue;
            result.put((Object)attribute, (Object)values);
        }
        return result;
    }

    protected boolean evaluateSerializable(boolean serializable, EStructuralFeature feature) {
        if (!serializable) {
            return true;
        }
        return MPatchUtil.isRelevantFeature((EStructuralFeature)feature);
    }

    protected boolean deepCloneRequired(EAttribute eAttribute) {
        return !String.class.isAssignableFrom(eAttribute.getEAttributeType().getInstanceClass()) && !Integer.class.isAssignableFrom(eAttribute.getEAttributeType().getInstanceClass()) && !Boolean.class.isAssignableFrom(eAttribute.getEAttributeType().getInstanceClass()) && !Enum.class.isAssignableFrom(eAttribute.getEAttributeType().getInstanceClass());
    }

    public Object clone(Object copyObject, EDataType eDataType) {
        return QvtlibHelper.clone(copyObject, eDataType);
    }

    public String getLabel() {
        return "Default";
    }
}

