/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.symrefs.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.compare.mpatch.symrefs.util.LevenshteinDistance;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegexEvaluationEnvironment
extends EcoreEvaluationEnvironment {
    RegexEvaluationEnvironment() {
    }

    RegexEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        super(parent);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) {
        if (operation.getEAnnotation("RegexEnvironment") == null) {
            return super.callOperation(operation, opcode, source, args);
        }
        if ("regexMatch".equals(operation.getName())) {
            Pattern pattern = Pattern.compile((String)args[0]);
            Matcher matcher = pattern.matcher((String)source);
            return matcher.matches() ? matcher.group() : null;
        }
        if ("contains".equals(operation.getName())) {
            if (source == null) {
                if (args[0] == null) {
                    return true;
                }
                return false;
            }
            return ((String)source).contains((String)args[0]);
        }
        if ("containsIgnoreCase".equals(operation.getName())) {
            if (source == null) {
                if (args[0] == null) {
                    return true;
                }
                return false;
            }
            return ((String)source).toLowerCase().contains(((String)args[0]).toLowerCase());
        }
        if ("checkSimilarity".equals(operation.getName())) {
            if (source == null) {
                source = "";
            }
            String target = args[0] == null ? "" : (String)args[0];
            Double similarity = (Double)args[1];
            return RegexEvaluationEnvironment.checkSimilarity((String)source, target, similarity);
        }
        throw new UnsupportedOperationException("Unknown operation: " + operation.getName());
    }

    private static Boolean checkSimilarity(String source, String target, Double threshold) {
        double similarity;
        String b;
        String a;
        if (source.length() < target.length()) {
            a = source;
            b = target;
        } else {
            a = target;
            b = source;
        }
        double al = a.length();
        double bl = b.length();
        if (a.equals(b)) {
            similarity = 1.0;
        } else if (b.contains(a)) {
            similarity = 0.5 + 1.25 * al / (bl + 2.0 * al);
        } else if (b.toLowerCase().equals(a.toLowerCase())) {
            similarity = 0.9;
        } else if (b.toLowerCase().contains(a.toLowerCase())) {
            if (threshold > 0.9) {
                return false;
            }
            similarity = 0.4 + 1.25 * al / (bl + 2.0 * al);
        } else {
            if (threshold > 0.5) {
                return false;
            }
            int distance = LevenshteinDistance.calculateDistance(a, b);
            similarity = 0.5 - (double)distance / 2.0 / bl;
        }
        if (similarity >= threshold) {
            return true;
        }
        return false;
    }
}

