/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.actions;

import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.Emfdiff2mpatchActivator;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.util.WizardLauncher;
import org.eclipse.emf.compare.ui.export.IExportAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class EmfdiffExportAction
implements IExportAction {
    private static final String ACTION_TEXT = "MPatch";
    private static final String TOOL_TIP_TEXT = "Transform this emfdiff into MPatch";
    private static final String DEFAULT_FILE_NAME = "result.mpatch";
    private static final String DIFF_ICON = "icons/diff_16.gif";
    private static final Image IMAGE;

    static {
        URL imageURL = Emfdiff2mpatchActivator.getDefault().getBundle().getEntry(DIFF_ICON);
        IMAGE = ImageDescriptor.createFromURL((URL)imageURL).createImage();
    }

    public void exportSnapshot(ComparisonSnapshot snapshot) {
        EObject leftModel = CommonUtils.getModelFromEmfdiff((ComparisonSnapshot)snapshot, (boolean)true);
        if (leftModel != null && leftModel.eResource() != null) {
            IFile mPatchFile = CommonUtils.createNewIFile((URI)leftModel.eResource().getURI(), (String)DEFAULT_FILE_NAME);
            WizardLauncher.openWizard(snapshot, mPatchFile);
        } else {
            WizardLauncher.openWizard(snapshot);
        }
    }

    public Image getDisabledImage() {
        return IMAGE;
    }

    public Image getEnabledImage() {
        return IMAGE;
    }

    public String getText() {
        return ACTION_TEXT;
    }

    public String getToolTipText() {
        return TOOL_TIP_TEXT;
    }
}

