/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.IndepAddAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.IndepMoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateReferenceChange;
import org.eclipse.emf.compare.mpatch.MPatchFactory;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.UnknownChange;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.lib.MPatchLibrary;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.lib.MPatchLibraryComponents;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class Emfdiff2Mpatch {
    protected final MPatchLibrary lib = new MPatchLibrary();
    private StringBuffer log;

    public Emfdiff2Mpatch() {
        if (MPatchLibraryComponents.getModelDescriptorCreator() == null) {
            throw new IllegalStateException("There is no model descriptor creator configured for the MPatchLibrary! Please specify one before initializing this transformation!");
        }
        if (MPatchLibraryComponents.getSymbolicReferenceCreator() == null) {
            throw new IllegalStateException("There is no symbolic reference creator configured for the MPatchLibrary! Please specify one before initializing this transformation!");
        }
    }

    protected void log(String msg, Object obj) {
        if (this.log != null) {
            String time = String.format("[%1$tF %1$tT]: ", Calendar.getInstance());
            if (obj != null) {
                this.log.append(String.valueOf(time) + msg + "  - " + obj);
            } else {
                this.log.append(String.valueOf(time) + msg);
            }
        }
    }

    public MPatchModel transform(ComparisonSnapshot emfdiff, StringBuffer output) {
        this.log = output;
        this.log("starting transformation...", emfdiff);
        List diffModels = ExtEcoreUtils.collectTypedElements(Collections.singletonList(emfdiff), Collections.singleton(DiffPackage.Literals.DIFF_MODEL), (boolean)true);
        if (diffModels == null || diffModels.size() != 1) {
            this.log("Only one DiffModel is supported at the moment! Aborting transformation...", diffModels);
            throw new IllegalArgumentException("At the moment, only emfdiffs with exactly one DiffModel contained are supported! Found: " + diffModels);
        }
        DiffModel diffModel = (DiffModel)diffModels.get(0);
        MPatchModel mpatch = this.toMPatchModel(diffModel);
        this.log("transformation finished!", mpatch);
        return mpatch;
    }

    protected MPatchModel toMPatchModel(DiffModel diffModel) {
        if (diffModel.getLeftRoots().isEmpty() || diffModel.getRightRoots().isEmpty()) {
            this.log("leftRoots and rightRoots must not be empty in DiffModel! Aborting transformation...", diffModel);
            throw new IllegalArgumentException("Expecting leftRoots and rightRoots non-empty in the DiffModel!");
        }
        if (!diffModel.getAncestorRoots().isEmpty()) {
            this.log("ancestorRoots must be empty in DiffModel! Aborting transformation...", diffModel);
            throw new IllegalArgumentException("Expecting ancestorRoots to be empty in the DiffModel!");
        }
        MPatchModel mpatch = MPatchFactory.eINSTANCE.createMPatchModel();
        ArrayList<String> leftUris = new ArrayList<String>();
        ArrayList<String> rightUris = new ArrayList<String>();
        for (EObject left : diffModel.getLeftRoots()) {
            leftUris.add(this.lib.toUriString(left.eResource()));
        }
        for (EObject right : diffModel.getRightRoots()) {
            rightUris.add(this.lib.toUriString(right.eResource()));
        }
        mpatch.setNewModel(CommonUtils.join(leftUris, (CharSequence)" "));
        mpatch.setOldModel(CommonUtils.join(rightUris, (CharSequence)" "));
        mpatch.setEmfdiff(this.lib.toUriString(diffModel.eResource()));
        List diffElements = ExtEcoreUtils.collectTypedElements((List)diffModel.getOwnedElements(), Collections.singleton(DiffPackage.Literals.DIFF_ELEMENT), (boolean)true);
        for (EObject diffElement : diffElements) {
            if (!this.shallTransform((DiffElement)diffElement)) continue;
            mpatch.getChanges().add((Object)this.toIndepChange((DiffElement)diffElement));
        }
        this.log(String.valueOf(mpatch.getChanges().size()) + " DiffElements transformed.", null);
        return mpatch;
    }

    protected boolean shallTransform(DiffElement diffElement) {
        if (diffElement instanceof DiffGroup) {
            return false;
        }
        return diffElement.getIsHiddenBy().isEmpty();
    }

    protected IndepChange toIndepChange(DiffElement diffElement) {
        this.log("  transforming DiffElement", diffElement);
        if (diffElement instanceof DiffGroup) {
            return this.toIndepChange((DiffGroup)diffElement);
        }
        if (diffElement instanceof ConflictingDiffElement) {
            return this.toIndepChange((ConflictingDiffElement)diffElement);
        }
        if (diffElement instanceof MoveModelElement) {
            return this.toIndepChange((MoveModelElement)diffElement);
        }
        if (diffElement instanceof ModelElementChangeRightTarget) {
            return this.toIndepChange((ModelElementChangeRightTarget)diffElement);
        }
        if (diffElement instanceof ModelElementChangeLeftTarget) {
            return this.toIndepChange((ModelElementChangeLeftTarget)diffElement);
        }
        if (diffElement instanceof UpdateAttribute) {
            return this.toIndepChange((UpdateAttribute)diffElement);
        }
        if (diffElement instanceof AttributeChangeRightTarget) {
            return this.toIndepChange((AttributeChangeRightTarget)diffElement);
        }
        if (diffElement instanceof AttributeChangeLeftTarget) {
            return this.toIndepChange((AttributeChangeLeftTarget)diffElement);
        }
        if (diffElement instanceof UpdateReference) {
            return this.toIndepChange((UpdateReference)diffElement);
        }
        if (diffElement instanceof ReferenceChangeRightTarget) {
            return this.toIndepChange((ReferenceChangeRightTarget)diffElement);
        }
        if (diffElement instanceof ReferenceChangeLeftTarget) {
            return this.toIndepChange((ReferenceChangeLeftTarget)diffElement);
        }
        return this.toUnknownChange(diffElement);
    }

    protected IndepChange toUnknownChange(DiffElement diffElement) {
        UnknownChange change = MPatchFactory.eINSTANCE.createUnknownChange();
        change.setInfo("[" + diffElement.eClass().getName() + "]: \"" + diffElement + "\"");
        return change;
    }

    protected IndepChange toIndepChange(DiffGroup diffElement) {
        ChangeGroup group = MPatchFactory.eINSTANCE.createChangeGroup();
        if (diffElement.getRightParent() != null) {
            group.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightParent()));
        }
        return group;
    }

    protected IndepChange toIndepChange(ConflictingDiffElement diffElement) {
        this.log("Conflicting Diff Element found! Aborting transformation...", diffElement);
        throw new IllegalArgumentException("Conflicting elements are not supported! Please use this transformation on non-conflicting diffs only! " + diffElement);
    }

    protected IndepChange toIndepChange(MoveModelElement diffElement) {
        IndepMoveElementChange indepChange = MPatchFactory.eINSTANCE.createIndepMoveElementChange();
        indepChange.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightElement()));
        indepChange.setResultingElement(this.lib.toSymbolicReference(diffElement.getLeftElement()));
        indepChange.setOldContainment(diffElement.getRightElement().eContainmentFeature());
        indepChange.setNewContainment(diffElement.getLeftElement().eContainmentFeature());
        indepChange.setOldParent(this.lib.toSymbolicReference(diffElement.getRightElement().eContainer()));
        indepChange.setNewParent(this.lib.toSymbolicReference(diffElement.getLeftElement().eContainer()));
        return indepChange;
    }

    protected IndepChange toIndepChange(ModelElementChangeRightTarget diffElement) {
        IndepRemoveElementChange indepChange = MPatchFactory.eINSTANCE.createIndepRemoveElementChange();
        indepChange.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightElement().eContainer()));
        indepChange.setResultingElement(this.lib.toSymbolicReference(diffElement.getLeftParent()));
        indepChange.setContainment(diffElement.getRightElement().eContainmentFeature());
        indepChange.setSubModel(this.lib.toModelDescriptor(diffElement.getRightElement(), true));
        return indepChange;
    }

    protected IndepChange toIndepChange(ModelElementChangeLeftTarget diffElement) {
        IndepAddElementChange indepChange = MPatchFactory.eINSTANCE.createIndepAddElementChange();
        indepChange.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightParent()));
        indepChange.setResultingElement(this.lib.toSymbolicReference(diffElement.getLeftElement().eContainer()));
        indepChange.setContainment(diffElement.getLeftElement().eContainmentFeature());
        indepChange.setSubModel(this.lib.toModelDescriptor(diffElement.getLeftElement(), true));
        return indepChange;
    }

    protected IndepChange toIndepChange(UpdateAttribute diffElement) {
        IndepUpdateAttributeChange indepChange = MPatchFactory.eINSTANCE.createIndepUpdateAttributeChange();
        indepChange.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightElement()));
        indepChange.setResultingElement(this.lib.toSymbolicReference(diffElement.getLeftElement()));
        indepChange.setChangedAttribute(diffElement.getAttribute());
        indepChange.setOldValue(diffElement.getRightElement().eGet((EStructuralFeature)diffElement.getAttribute()));
        indepChange.setNewValue(diffElement.getLeftElement().eGet((EStructuralFeature)diffElement.getAttribute()));
        return indepChange;
    }

    protected IndepChange toIndepChange(AttributeChangeRightTarget diffElement) {
        IndepRemoveAttributeChange indepChange = MPatchFactory.eINSTANCE.createIndepRemoveAttributeChange();
        indepChange.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightElement()));
        indepChange.setResultingElement(this.lib.toSymbolicReference(diffElement.getLeftElement()));
        indepChange.setChangedAttribute(diffElement.getAttribute());
        indepChange.setValue(diffElement.getRightTarget());
        return indepChange;
    }

    protected IndepChange toIndepChange(AttributeChangeLeftTarget diffElement) {
        IndepAddAttributeChange indepChange = MPatchFactory.eINSTANCE.createIndepAddAttributeChange();
        indepChange.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightElement()));
        indepChange.setResultingElement(this.lib.toSymbolicReference(diffElement.getLeftElement()));
        indepChange.setChangedAttribute(diffElement.getAttribute());
        indepChange.setValue(diffElement.getLeftTarget());
        return indepChange;
    }

    protected IndepChange toIndepChange(UpdateReference diffElement) {
        IndepUpdateReferenceChange indepChange = MPatchFactory.eINSTANCE.createIndepUpdateReferenceChange();
        indepChange.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightElement()));
        indepChange.setResultingElement(this.lib.toSymbolicReference(diffElement.getLeftElement()));
        indepChange.setReference(diffElement.getReference());
        Object rightTarget = diffElement.getRightElement().eGet((EStructuralFeature)diffElement.getReference());
        Object leftTarget = diffElement.getLeftElement().eGet((EStructuralFeature)diffElement.getReference());
        if (rightTarget != null) {
            indepChange.setOldReference(this.lib.toSymbolicReference((EObject)rightTarget));
        }
        if (leftTarget != null) {
            indepChange.setNewReference(this.lib.toSymbolicReference((EObject)leftTarget));
        }
        return indepChange;
    }

    protected IndepChange toIndepChange(ReferenceChangeRightTarget diffElement) {
        IndepRemoveReferenceChange indepChange = MPatchFactory.eINSTANCE.createIndepRemoveReferenceChange();
        indepChange.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightElement()));
        indepChange.setResultingElement(this.lib.toSymbolicReference(diffElement.getLeftElement()));
        indepChange.setReference(diffElement.getReference());
        indepChange.setChangedReference(this.lib.toSymbolicReference(diffElement.getRightTarget()));
        return indepChange;
    }

    protected IndepChange toIndepChange(ReferenceChangeLeftTarget diffElement) {
        IndepAddReferenceChange indepChange = MPatchFactory.eINSTANCE.createIndepAddReferenceChange();
        indepChange.setCorrespondingElement(this.lib.toSymbolicReference(diffElement.getRightElement()));
        indepChange.setResultingElement(this.lib.toSymbolicReference(diffElement.getLeftElement()));
        indepChange.setReference(diffElement.getReference());
        indepChange.setChangedReference(this.lib.toSymbolicReference(diffElement.getLeftTarget()));
        return indepChange;
    }
}

