/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.impl.Emfdiff2Mpatch;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.lib.MPatchLibraryComponents;
import org.eclipse.emf.compare.mpatch.extension.IModelDescriptorCreator;
import org.eclipse.emf.compare.mpatch.extension.ISymbolicReferenceCreator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformationLauncher {
    public static MPatchModel transform(ComparisonSnapshot emfdiff, StringBuffer output, ISymbolicReferenceCreator symbolicReferenceCreator, IModelDescriptorCreator modelDescriptorCreator) throws Exception {
        MPatchLibraryComponents.setModelDescriptorCreator(modelDescriptorCreator);
        MPatchLibraryComponents.setSymbolicReferenceCreator(symbolicReferenceCreator);
        Set<Resource> modelResources = TransformationLauncher.getModelResourcesFromEmfdiff(emfdiff);
        symbolicReferenceCreator.setNonExternalResources(modelResources);
        return TransformationLauncher.transformJava(emfdiff, output);
    }

    private static MPatchModel transformJava(ComparisonSnapshot emfdiff, StringBuffer output) {
        return new Emfdiff2Mpatch().transform(emfdiff, output);
    }

    protected static MPatchModel transformQVTo(ComparisonSnapshot emfdiff, StringBuffer output) throws Exception {
        throw new UnsupportedOperationException("qvto transformation was replaced with pure Java transformation.");
    }

    private static Set<Resource> getModelResourcesFromEmfdiff(ComparisonSnapshot snapshot) {
        HashSet<Resource> modelResources = new HashSet<Resource>();
        if (snapshot instanceof ComparisonResourceSnapshot) {
            ComparisonResourceSnapshot resourceSnapshot = (ComparisonResourceSnapshot)snapshot;
            TransformationLauncher.addModelResourcesFromDiffModel(resourceSnapshot.getDiff(), modelResources);
        } else if (snapshot instanceof ComparisonResourceSetSnapshot) {
            ComparisonResourceSetSnapshot resourceSetSnapshot = (ComparisonResourceSetSnapshot)snapshot;
            for (DiffModel diffModel : resourceSetSnapshot.getDiffResourceSet().getDiffModels()) {
                TransformationLauncher.addModelResourcesFromDiffModel(diffModel, modelResources);
            }
        }
        return modelResources;
    }

    private static void addModelResourcesFromDiffModel(DiffModel diff, Set<Resource> modelResources) {
        for (EObject leftInModel : diff.getLeftRoots()) {
            if (leftInModel.eResource() == null) continue;
            modelResources.add(leftInModel.eResource());
        }
        for (EObject rightInModel : diff.getRightRoots()) {
            if (rightInModel.eResource() == null) continue;
            modelResources.add(rightInModel.eResource());
        }
    }
}

