/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.common.util.ExtensionManager;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.compare.mpatch.extension.IModelDescriptorCreator;
import org.eclipse.emf.compare.mpatch.extension.ISymbolicReferenceCreator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfdiffExportWizardTransformationPage
extends WizardPage
implements ISelectionChangedListener {
    private static final Map<String, IMPatchTransformation> allTransformations = ExtensionManager.getAllTransformations();
    private List<String> orderedTransformations;
    private List<String> selectedTransformations;
    private TableViewer transformationTableViewer;
    private Button upButton;
    private Button downButton;
    private Combo symrefCombo;
    private Combo descriptorCombo;
    private Text infoText;
    private Label warningLabel;

    public EmfdiffExportWizardTransformationPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Configuration of MPatch creation.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label1 = new Label(container, 0);
        label1.setText("Additional transformations for MPatch creation (in execution order):");
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = 2;
        label1.setLayoutData((Object)gd1);
        this.transformationTableViewer = new TableViewer(container, 2848);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        this.transformationTableViewer.getTable().setLayoutData((Object)gd2);
        this.transformationTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.upButton = new Button(container, 8);
        this.upButton.setText("Move selection up");
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmfdiffExportWizardTransformationPage.this.moveCurrentSelection(true);
                EmfdiffExportWizardTransformationPage.this.dialogChanged();
            }
        });
        this.downButton = new Button(container, 8);
        this.downButton.setText("Move selection down");
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmfdiffExportWizardTransformationPage.this.moveCurrentSelection(false);
                EmfdiffExportWizardTransformationPage.this.dialogChanged();
            }
        });
        Group infoGroup = new Group(container, 0);
        GridData gd3 = new GridData(1808);
        gd3.horizontalSpan = 2;
        infoGroup.setLayoutData((Object)gd3);
        infoGroup.setText("Transformation Details");
        infoGroup.setLayout((Layout)new FillLayout());
        this.infoText = new Text((Composite)infoGroup, 584);
        if (ExtensionManager.isShowMandatoryTransformationsSet()) {
            this.warningLabel = new Label(container, 64);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.warningLabel.setLayoutData((Object)gd);
            this.warningLabel.setForeground(container.getShell().getDisplay().getSystemColor(4));
            this.warningLabel.setText(" \n ");
        }
        new Label(container, 0).setText("Symbolic References Creator:");
        this.symrefCombo = new Combo(container, 8);
        new Label(container, 0).setText("Model Descriptor Creator:");
        this.descriptorCombo = new Combo(container, 8);
        Label label2 = new Label(container, 0);
        label2.setText("Tipp: the default values are defined in the preferences page!");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label2.setLayoutData((Object)gd);
        this.initialize();
        this.setControl((Control)container);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IMPatchTransformation transformation;
        Object element;
        IStructuredSelection selection;
        this.upButton.setEnabled(!event.getSelection().isEmpty());
        this.downButton.setEnabled(!event.getSelection().isEmpty());
        String info = "";
        if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1 && (element = selection.getFirstElement()) instanceof String && (transformation = allTransformations.get(element)) != null) {
            info = transformation.getDescription();
        }
        this.infoText.setText(info);
        this.selectedTransformations.clear();
        TableItem[] tableItemArray = this.transformationTableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                this.selectedTransformations.add(item.getText());
            }
            ++n2;
        }
        this.dialogChanged();
    }

    protected void moveCurrentSelection(boolean up) {
        if (!this.transformationTableViewer.getSelection().isEmpty() && this.transformationTableViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.transformationTableViewer.getSelection();
            List elements = selection.toList();
            boolean ignore = true;
            int i = 0;
            while (i < this.orderedTransformations.size()) {
                int j;
                int n = j = up ? i : this.orderedTransformations.size() - i - 1;
                if (ignore && !elements.contains(this.orderedTransformations.get(j))) {
                    ignore = false;
                } else if (!ignore || !elements.contains(this.orderedTransformations.get(j))) {
                    if (!ignore && elements.contains(this.orderedTransformations.get(j))) {
                        Collections.swap(this.orderedTransformations, j, up ? j - 1 : j + 1);
                    } else if (!ignore) {
                        elements.contains(this.orderedTransformations.get(j));
                    }
                }
                ++i;
            }
        }
    }

    private void initialize() {
        this.selectedTransformations = new ArrayList<String>(ExtensionManager.getSelectedOptionalTransformations());
        this.orderedTransformations = new ArrayList<String>(allTransformations.keySet());
        if (ExtensionManager.isShowMandatoryTransformationsSet()) {
            this.selectedTransformations.addAll(ExtensionManager.getMandatoryTransformations());
        } else {
            this.orderedTransformations.removeAll(ExtensionManager.getMandatoryTransformations());
        }
        this.transformationTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.transformationTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dialogChanged();
        Map allSymrefCreators = ExtensionManager.getAllSymbolicReferenceCreators();
        this.symrefCombo.setItems(allSymrefCreators.keySet().toArray(new String[0]));
        this.symrefCombo.setText(ExtensionManager.getSelectedSymbolicReferenceCreator().getLabel());
        Map allDescriptorCreators = ExtensionManager.getAllModelDescriptorCreators();
        this.descriptorCombo.setItems(allDescriptorCreators.keySet().toArray(new String[0]));
        this.descriptorCombo.setText(ExtensionManager.getSelectedModelDescriptorCreator().getLabel());
        this.dialogChanged();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void dialogChanged() {
        this.transformationTableViewer.setInput(this.orderedTransformations);
        String msg = null;
        ArrayList<String> missing = new ArrayList<String>();
        TableItem[] tableItemArray = this.transformationTableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String label = item.getText();
            boolean checked = this.selectedTransformations.contains(label);
            if (!checked && !allTransformations.get(label).isOptional()) {
                missing.add(label);
            }
            item.setChecked(checked);
            ++n2;
        }
        if (ExtensionManager.isShowMandatoryTransformationsSet()) {
            String warning = " \n ";
            if (!missing.isEmpty()) {
                warning = missing.size() == 1 ? " '" + (String)missing.get(0) + "' is" : "s '" + CommonUtils.join(missing, (CharSequence)"', '") + "' are";
                warning = "Warning: Mandatory transformation" + warning + " required for " + "MPatch" + " to be properly applicable!";
            }
            this.warningLabel.setText(warning);
        }
        this.updateStatus(msg);
    }

    public List<IMPatchTransformation> getTransformations() {
        ArrayList<IMPatchTransformation> result = new ArrayList<IMPatchTransformation>();
        if (!ExtensionManager.isShowMandatoryTransformationsSet()) {
            for (String label : ExtensionManager.getMandatoryTransformations()) {
                result.add(allTransformations.get(label));
            }
        }
        for (String label : this.selectedTransformations) {
            result.add(allTransformations.get(label));
        }
        return result;
    }

    public ISymbolicReferenceCreator getSymbolicReferenceCreator() {
        return (ISymbolicReferenceCreator)ExtensionManager.getAllSymbolicReferenceCreators().get(this.symrefCombo.getText());
    }

    public IModelDescriptorCreator getModelDescriptorCreator() {
        return (IModelDescriptorCreator)ExtensionManager.getAllModelDescriptorCreators().get(this.descriptorCombo.getText());
    }
}

