/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.ChangeKind;
import org.eclipse.emf.compare.mpatch.ChangeType;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IndepAddAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.IndepElementChange;
import org.eclipse.emf.compare.mpatch.IndepMoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateReferenceChange;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndepChangeImpl
extends EObjectImpl
implements IndepChange {
    public static final String copyright = "Copyright (c) 2010, 2011 Technical University of Denmark.\r\nAll rights reserved. This program and the accompanying materials \r\nare made available under the terms of the Eclipse Public License v1.0 \r\nwhich accompanies this distribution, and is available at \r\nhttp://www.eclipse.org/legal/epl-v10.html \r\n\r\nContributors:\r\n   Patrick Koenemann, DTU Informatics - initial API and implementation";
    protected IElementReference correspondingElement;
    protected static final ChangeKind CHANGE_KIND_EDEFAULT = ChangeKind.ADDITION;
    protected static final ChangeType CHANGE_TYPE_EDEFAULT = ChangeType.ELEMENT;
    protected EList<IndepChange> dependsOn;
    protected EList<IndepChange> dependants;
    protected IElementReference resultingElement;

    protected IndepChangeImpl() {
    }

    protected EClass eStaticClass() {
        return MPatchPackage.Literals.INDEP_CHANGE;
    }

    @Override
    public IElementReference getCorrespondingElement() {
        return this.correspondingElement;
    }

    public NotificationChain basicSetCorrespondingElement(IElementReference newCorrespondingElement, NotificationChain msgs) {
        IElementReference oldCorrespondingElement = this.correspondingElement;
        this.correspondingElement = newCorrespondingElement;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldCorrespondingElement, (Object)newCorrespondingElement);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setCorrespondingElement(IElementReference newCorrespondingElement) {
        if (newCorrespondingElement != this.correspondingElement) {
            NotificationChain msgs = null;
            if (this.correspondingElement != null) {
                msgs = ((InternalEObject)this.correspondingElement).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newCorrespondingElement != null) {
                msgs = ((InternalEObject)newCorrespondingElement).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetCorrespondingElement(newCorrespondingElement, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newCorrespondingElement, (Object)newCorrespondingElement));
        }
    }

    @Override
    public ChangeKind getChangeKind() {
        if (this instanceof IndepAddElementChange || this instanceof IndepAddAttributeChange || this instanceof IndepAddReferenceChange) {
            return ChangeKind.ADDITION;
        }
        if (this instanceof IndepRemoveElementChange || this instanceof IndepRemoveAttributeChange || this instanceof IndepRemoveReferenceChange) {
            return ChangeKind.DELETION;
        }
        if (this instanceof IndepUpdateAttributeChange || this instanceof IndepUpdateReferenceChange) {
            return ChangeKind.CHANGE;
        }
        if (this instanceof IndepMoveElementChange) {
            return ChangeKind.MOVE;
        }
        if (this instanceof ChangeGroup) {
            return ChangeKind.GROUP;
        }
        return ChangeKind.UNKNOWN;
    }

    @Override
    public ChangeType getChangeType() {
        if (this instanceof IndepElementChange) {
            return ChangeType.ELEMENT;
        }
        if (this instanceof IndepAttributeChange) {
            return ChangeType.ATTRIBUTE;
        }
        if (this instanceof IndepReferenceChange) {
            return ChangeType.REFERENCE;
        }
        if (this instanceof ChangeGroup) {
            return ChangeType.GROUP;
        }
        return ChangeType.UNKNOWN;
    }

    @Override
    public EList<IndepChange> getDependsOn() {
        if (this.dependsOn == null) {
            this.dependsOn = new EObjectWithInverseResolvingEList.ManyInverse(IndepChange.class, (InternalEObject)this, 3, 4);
        }
        return this.dependsOn;
    }

    @Override
    public EList<IndepChange> getDependants() {
        if (this.dependants == null) {
            this.dependants = new EObjectWithInverseResolvingEList.ManyInverse(IndepChange.class, (InternalEObject)this, 4, 3);
        }
        return this.dependants;
    }

    @Override
    public IElementReference getResultingElement() {
        return this.resultingElement;
    }

    public NotificationChain basicSetResultingElement(IElementReference newResultingElement, NotificationChain msgs) {
        IElementReference oldResultingElement = this.resultingElement;
        this.resultingElement = newResultingElement;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldResultingElement, (Object)newResultingElement);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setResultingElement(IElementReference newResultingElement) {
        if (newResultingElement != this.resultingElement) {
            NotificationChain msgs = null;
            if (this.resultingElement != null) {
                msgs = ((InternalEObject)this.resultingElement).eInverseRemove((InternalEObject)this, -6, null, msgs);
            }
            if (newResultingElement != null) {
                msgs = ((InternalEObject)newResultingElement).eInverseAdd((InternalEObject)this, -6, null, msgs);
            }
            if ((msgs = this.basicSetResultingElement(newResultingElement, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newResultingElement, (Object)newResultingElement));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getDependsOn()).basicAdd((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getDependants()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetCorrespondingElement(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getDependsOn()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getDependants()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return this.basicSetResultingElement(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getCorrespondingElement();
            }
            case 1: {
                return this.getChangeKind();
            }
            case 2: {
                return this.getChangeType();
            }
            case 3: {
                return this.getDependsOn();
            }
            case 4: {
                return this.getDependants();
            }
            case 5: {
                return this.getResultingElement();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setCorrespondingElement((IElementReference)newValue);
                return;
            }
            case 3: {
                this.getDependsOn().clear();
                this.getDependsOn().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getDependants().clear();
                this.getDependants().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setResultingElement((IElementReference)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setCorrespondingElement(null);
                return;
            }
            case 3: {
                this.getDependsOn().clear();
                return;
            }
            case 4: {
                this.getDependants().clear();
                return;
            }
            case 5: {
                this.setResultingElement(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.correspondingElement != null;
            }
            case 1: {
                return this.getChangeKind() != CHANGE_KIND_EDEFAULT;
            }
            case 2: {
                return this.getChangeType() != CHANGE_TYPE_EDEFAULT;
            }
            case 3: {
                return this.dependsOn != null && !this.dependsOn.isEmpty();
            }
            case 4: {
                return this.dependants != null && !this.dependants.isEmpty();
            }
            case 5: {
                return this.resultingElement != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

