/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtEcoreUtils {
    public static EObject wrapInGenericContainer(Collection<? extends EObject> collection) {
        EReference children = EcoreFactory.eINSTANCE.createEReference();
        children.setName("children");
        children.setLowerBound(0);
        children.setUpperBound(-1);
        children.setContainment(true);
        children.setEType((EClassifier)EcorePackage.Literals.EOBJECT);
        EClass containerClass = EcoreFactory.eINSTANCE.createEClass();
        containerClass.setName("GenericEContainer");
        containerClass.getEStructuralFeatures().add((Object)children);
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName("dynamic");
        ePackage.setNsPrefix("dynamic");
        ePackage.setNsURI("http://www.example.org/dynamic");
        ePackage.getEClassifiers().add((Object)containerClass);
        if (Diagnostician.INSTANCE.validate((EObject)ePackage).getCode() == 0) {
            EObject container = ePackage.getEFactoryInstance().create(containerClass);
            ((EList)container.eGet((EStructuralFeature)children)).addAll(collection);
            return container;
        }
        throw new UnknownError("Dynamic EMF wrapper model creation failed for whatever reason. Developer, please debug better!");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean setStructuralFeature(EObject obj, EStructuralFeature ref, Object value) {
        if (!ref.isChangeable()) {
            throw new IllegalArgumentException("Cannot set a non-changeable reference: " + obj.eClass().getName() + "." + ref.getName());
        }
        try {
            if (ref.isMany()) {
                List list = (List)obj.eGet(ref);
                if (value instanceof List) {
                    List valueList = (List)value;
                    for (Object listValue : valueList) {
                        if (list.contains(listValue) || list.add(listValue)) continue;
                        return false;
                    }
                } else if (!list.contains(value) && !list.add(value)) {
                    return false;
                }
                return true;
            }
            if (value instanceof List) {
                List valueList = (List)value;
                if (valueList.size() > 1) {
                    throw new IllegalArgumentException("Cannot set a list of values to a non-many feature!");
                }
                if (valueList.size() == 1) {
                    if (obj.eGet(ref) == null || !obj.eGet(ref).equals(valueList.get(0))) {
                        obj.eSet(ref, valueList.get(0));
                    }
                } else {
                    obj.eSet(ref, null);
                }
            } else if (obj.eGet(ref) == null || !obj.eGet(ref).equals(value)) {
                obj.eSet(ref, value);
            }
            return true;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not set value (" + value + ") to: " + obj.eClass().getName() + "." + ref.getName() + " of object " + obj, e);
        }
    }

    public static List<? extends EObject> flattenEObjects(Collection<? extends EObject> elements) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        LinkedList<? extends EObject> queue = new LinkedList<EObject>();
        queue.addAll(elements);
        while (!queue.isEmpty()) {
            EObject obj = (EObject)queue.poll();
            result.add(obj);
            queue.addAll((Collection<? extends EObject>)obj.eContents());
        }
        return result;
    }

    public static List<EObject> collectTypedElements(List<? extends EObject> elements, Set<EClass> types, boolean includeSubtypes) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        LinkedList<? extends EObject> queue = new LinkedList<EObject>();
        queue.addAll(elements);
        while (!queue.isEmpty()) {
            EObject element = (EObject)queue.poll();
            if (includeSubtypes) {
                for (EClass eClass : types) {
                    if (!eClass.isSuperTypeOf(element.eClass())) continue;
                    result.add(element);
                    break;
                }
            } else if (types.contains(element.eClass())) {
                result.add(element);
            }
            queue.addAll((Collection<? extends EObject>)element.eContents());
        }
        return result;
    }

    public static int checkDanglingReferences(Resource resource) {
        int counter = 0;
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            for (EObject ref : obj.eCrossReferences()) {
                if (ref.eResource() != null) continue;
                ++counter;
            }
        }
        return counter;
    }

    public static EObject getContainerOfType(EObject element, EClass container) {
        if (element == null || container == null) {
            return null;
        }
        if (container.isInstance((Object)element)) {
            return element;
        }
        return ExtEcoreUtils.getContainerOfType(element.eContainer(), container);
    }
}

