/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFCompareException;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.diff.service.IDiffEngineSelector;
import org.eclipse.emf.compare.match.engine.DefaultMatchScopeProvider;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.match.service.IMatchEngineSelector;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.ICompareInputDetailsProvider;
import org.eclipse.emf.compare.ui.internal.RevisionComparisonHandler;
import org.eclipse.emf.compare.ui.internal.VisualEngineSelector;
import org.eclipse.emf.compare.ui.team.AbstractTeamHandler;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class ModelComparator
implements ICompareInputDetailsProvider {
    protected static final boolean IS_LESS_GANYMEDE;
    private static final Set<TeamHandlerDescriptor> CACHED_HANDLERS;
    private static final Map<CompareConfiguration, ModelComparator> INSTANCES;
    private static final String TEAM_HANDLERS_EXTENSION_POINT = "org.eclipse.emf.compare.ui.team.handler";
    protected ComparisonSnapshot comparisonResult;
    private ITypedElement ancestorElement;
    private Resource ancestorResource;
    private final CompareConfiguration compareConfiguration;
    private AbstractTeamHandler comparisonHandler;
    private ITypedElement leftElement;
    private boolean leftIsRemote;
    private Resource leftResource;
    private ITypedElement rightElement;
    private boolean rightIsRemote;
    private Resource rightResource;
    private final ICompareInput compareInput;
    private boolean loadingSucceeded;

    static {
        CACHED_HANDLERS = new LinkedHashSet<TeamHandlerDescriptor>();
        INSTANCES = new HashMap<CompareConfiguration, ModelComparator>();
        ModelComparator.parseExtensionMetaData();
        boolean temp = false;
        try {
            Class.forName("org.eclipse.compare.internal.ICompareAsText");
            temp = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_LESS_GANYMEDE = temp;
    }

    private ModelComparator(CompareConfiguration configuration, ICompareInput input) {
        this.compareConfiguration = configuration;
        this.compareInput = input;
    }

    public static ModelComparator getComparator(CompareConfiguration configuration, ICompareInput input) {
        if (!INSTANCES.containsKey(configuration)) {
            INSTANCES.put(configuration, new ModelComparator(configuration, input));
        }
        return INSTANCES.get(configuration);
    }

    public static ModelComparator getComparator(CompareConfiguration configuration) {
        return INSTANCES.get(configuration);
    }

    public static void removeComparator(CompareConfiguration configuration) {
        if (IS_LESS_GANYMEDE) {
            INSTANCES.remove(configuration);
        }
    }

    private static void parseExtensionMetaData() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(TEAM_HANDLERS_EXTENSION_POINT).getExtensions();
        TeamHandlerDescriptor revisionHandler = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                TeamHandlerDescriptor descriptor = new TeamHandlerDescriptor(configElement);
                if (RevisionComparisonHandler.class.getName().equals(descriptor.getHandlerClass())) {
                    revisionHandler = descriptor;
                } else {
                    CACHED_HANDLERS.add(descriptor);
                }
                ++n4;
            }
            ++n2;
        }
        CACHED_HANDLERS.add(revisionHandler);
    }

    public ComparisonSnapshot compare(CompareConfiguration configuration) {
        if (!this.loadingSucceeded) {
            this.comparisonResult = DiffFactory.eINSTANCE.createComparisonResourceSetSnapshot();
        }
        if (this.comparisonResult == null) {
            Date start = Calendar.getInstance().getTime();
            MatchService.setMatchEngineSelector((IMatchEngineSelector)new VisualEngineSelector());
            DiffService.setDiffEngineSelector((IDiffEngineSelector)new VisualEngineSelector());
            MessageDialog queryMatchScopeDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), EMFCompareUIMessages.getString("ModelComparator.MatchModeSelectionDialogTitle"), null, EMFCompareUIMessages.getString("ModelComparator.MatchModeSelectionDialogMessage"), 0, new String[]{EMFCompareUIMessages.getString("ModelComparator.MatchModelSelectionDialogResourceOption"), EMFCompareUIMessages.getString("ModelComparator.MatchModelSelectionDialogResourceSetOption")}, 0);
            boolean doResourceMatchOnly = queryMatchScopeDialog.open() == 0;
            this.comparisonResult = doResourceMatchOnly ? this.doResourceCompare() : this.doResourceSetCompare();
            Date end = Calendar.getInstance().getTime();
            this.comparisonResult.setDate(end);
            configuration.setLeftEditable(configuration.isLeftEditable() && !this.isLeftRemote());
            configuration.setRightEditable(configuration.isRightEditable() && !this.isRightRemote());
            configuration.setProperty("comparison.time", (Object)(end.getTime() - start.getTime()));
            if (this.isLeftRemote()) {
                if (doResourceMatchOnly) {
                    configuration.setLeftLabel(EMFCompareUIMessages.getString(EMFCompareUIMessages.getString("ModelComparator.remoteResourceCompareLabel")));
                    configuration.setRightLabel(EMFCompareUIMessages.getString(EMFCompareUIMessages.getString("ModelComparator.localResourceCompareLabel")));
                } else {
                    configuration.setLeftLabel(EMFCompareUIMessages.getString(EMFCompareUIMessages.getString("ModelComparator.remoteResourceSetCompareLabel")));
                    configuration.setRightLabel(EMFCompareUIMessages.getString(EMFCompareUIMessages.getString("ModelComparator.localResourceSetCompareLabel")));
                }
            }
        }
        return this.comparisonResult;
    }

    protected ComparisonResourceSnapshot doResourceCompare() {
        final ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
        snapshot.setDiff(DiffFactory.eINSTANCE.createDiffModel());
        snapshot.setMatch(MatchFactory.eINSTANCE.createMatchModel());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    MatchModel match;
                    EMFCompareMap options = new EMFCompareMap();
                    options.put("match.progress.monitor", monitor);
                    if (ModelComparator.this.getAncestorResource() == null) {
                        options.put("match.scope.provider", new DefaultMatchScopeProvider(ModelComparator.this.getLeftResource(), ModelComparator.this.getRightResource()));
                        match = MatchService.doResourceMatch((Resource)ModelComparator.this.getLeftResource(), (Resource)ModelComparator.this.getRightResource(), (Map)options);
                    } else {
                        options.put("match.scope.provider", new DefaultMatchScopeProvider(ModelComparator.this.getLeftResource(), ModelComparator.this.getRightResource(), ModelComparator.this.getAncestorResource()));
                        match = MatchService.doResourceMatch((Resource)ModelComparator.this.getLeftResource(), (Resource)ModelComparator.this.getRightResource(), (Resource)ModelComparator.this.getAncestorResource(), (Map)options);
                    }
                    DiffModel diff = DiffService.doDiff((MatchModel)match, (ModelComparator.this.getAncestorResource() != null ? 1 : 0) != 0);
                    snapshot.setDiff(diff);
                    snapshot.setMatch(match);
                }
            });
        }
        catch (InterruptedException e) {
            EMFComparePlugin.log((Exception)e, (boolean)false);
        }
        catch (EMFCompareException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        catch (InvocationTargetException e) {
            EMFComparePlugin.log((Exception)e, (boolean)true);
        }
        return snapshot;
    }

    protected ComparisonResourceSetSnapshot doResourceSetCompare() {
        final ComparisonResourceSetSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSetSnapshot();
        snapshot.setDiffResourceSet(DiffFactory.eINSTANCE.createDiffResourceSet());
        snapshot.setMatchResourceSet(MatchFactory.eINSTANCE.createMatchResourceSet());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    MatchResourceSet match;
                    EMFCompareMap options = new EMFCompareMap();
                    options.put("match.progress.monitor", monitor);
                    if (ModelComparator.this.getAncestorResource() == null) {
                        options.put("match.scope.provider", new DefaultMatchScopeProvider(ModelComparator.this.getLeftResource().getResourceSet(), ModelComparator.this.getRightResource().getResourceSet()));
                        match = MatchService.doResourceSetMatch((ResourceSet)ModelComparator.this.getLeftResource().getResourceSet(), (ResourceSet)ModelComparator.this.getRightResource().getResourceSet(), (Map)options);
                    } else {
                        options.put("match.scope.provider", new DefaultMatchScopeProvider(ModelComparator.this.getLeftResource().getResourceSet(), ModelComparator.this.getRightResource().getResourceSet(), ModelComparator.this.getAncestorResource().getResourceSet()));
                        match = MatchService.doResourceSetMatch((ResourceSet)ModelComparator.this.getLeftResource().getResourceSet(), (ResourceSet)ModelComparator.this.getRightResource().getResourceSet(), (ResourceSet)ModelComparator.this.getAncestorResource().getResourceSet(), (Map)options);
                    }
                    DiffResourceSet diff = DiffService.doDiff((MatchResourceSet)match, (ModelComparator.this.getAncestorResource() != null ? 1 : 0) != 0);
                    snapshot.setDiffResourceSet(diff);
                    snapshot.setMatchResourceSet(match);
                }
            });
        }
        catch (InterruptedException e) {
            EMFComparePlugin.log((Exception)e, (boolean)false);
        }
        catch (EMFCompareException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        catch (InvocationTargetException e) {
            EMFComparePlugin.log((Exception)e, (boolean)true);
        }
        return snapshot;
    }

    public Resource getAncestorResource() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.getAncestorResource();
        }
        return this.ancestorResource;
    }

    public ComparisonSnapshot getComparisonResult() {
        return this.comparisonResult;
    }

    public Resource getLeftResource() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.getLeftResource();
        }
        return this.leftResource;
    }

    public Resource getRightResource() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.getRightResource();
        }
        return this.rightResource;
    }

    public boolean isLeftRemote() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.isLeftRemote();
        }
        return this.leftIsRemote;
    }

    public boolean isRightRemote() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.isRightRemote();
        }
        return this.rightIsRemote;
    }

    public ICompareInput getCompareInput() {
        return this.compareInput;
    }

    public boolean loadResources(ICompareInput input) {
        if (this.ancestorElement != input.getAncestor() || this.leftElement != input.getLeft() || this.rightElement != input.getRight()) {
            this.clear();
            this.leftElement = input.getLeft();
            this.rightElement = input.getRight();
            this.ancestorElement = input.getAncestor();
            try {
                this.loadingSucceeded = this.handleLocalResources(this.leftElement, this.rightElement, this.ancestorElement);
                if (!this.loadingSucceeded) {
                    Iterator<TeamHandlerDescriptor> handlerDescriptorIterator = CACHED_HANDLERS.iterator();
                    while (handlerDescriptorIterator.hasNext()) {
                        AbstractTeamHandler handler = handlerDescriptorIterator.next().getHandlerInstance();
                        this.loadingSucceeded |= handler.loadResources(input);
                        if (!this.loadingSucceeded) continue;
                        this.comparisonHandler = handler;
                        break;
                    }
                }
                if (!this.loadingSucceeded) {
                    this.loadingSucceeded |= this.handleGenericResources(this.leftElement, this.rightElement, this.ancestorElement);
                }
                this.loadingSucceeded = true;
            }
            catch (IOException e) {
                String dialogMessage = IS_LESS_GANYMEDE ? EMFCompareUIMessages.getString("ModelComparator.ResourceLoadingFailure") : EMFCompareUIMessages.getString("ModelComparator.ResourceLoadingFailureGanymede");
                CompareErrorDialog dialog = new CompareErrorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Comparison failed", dialogMessage, (IStatus)new Status(4, "org.eclipse.emf.compare.ui", e.getMessage(), (Throwable)e));
                int buttonPressed = dialog.open();
                if (buttonPressed == 1025) {
                    HashSet<Object> set = new HashSet<Object>();
                    CompareEditorInput editorInput = (CompareEditorInput)this.compareConfiguration.getContainer();
                    this.compareConfiguration.setProperty("org.eclipse.compare.TextInputs", set);
                    set.add(editorInput);
                    set.add(editorInput.getCompareResult());
                    CompareUI.openCompareEditorOnPage((CompareEditorInput)editorInput, null);
                }
            }
            catch (CoreException e) {
                EMFComparePlugin.log((IStatus)e.getStatus());
            }
        }
        return this.loadingSucceeded;
    }

    public void setComparisonResult(ComparisonSnapshot snapshot) {
        if (snapshot instanceof ComparisonResourceSnapshot) {
            this.comparisonResult = DiffFactory.eINSTANCE.createComparisonResourceSetSnapshot();
            this.comparisonResult.setDate(snapshot.getDate());
            DiffResourceSet diffRS = DiffFactory.eINSTANCE.createDiffResourceSet();
            diffRS.getDiffModels().add((Object)((ComparisonResourceSnapshot)snapshot).getDiff());
            ((ComparisonResourceSetSnapshot)this.comparisonResult).setDiffResourceSet(diffRS);
            MatchResourceSet matchRS = MatchFactory.eINSTANCE.createMatchResourceSet();
            matchRS.getMatchModels().add((Object)((ComparisonResourceSnapshot)snapshot).getMatch());
            ((ComparisonResourceSetSnapshot)this.comparisonResult).setMatchResourceSet(matchRS);
        } else {
            this.comparisonResult = snapshot;
        }
    }

    private void clear() {
        this.clearResourceSet(this.leftResource, this.rightResource, this.ancestorResource);
        this.leftResource = null;
        this.rightResource = null;
        this.ancestorResource = null;
        this.comparisonResult = null;
        this.comparisonHandler = null;
    }

    private void clearResourceSet(Resource ... resource) {
        int i = 0;
        while (i < resource.length) {
            if (resource[i] != null) {
                ResourceSet resourceSet = resource[i].getResourceSet();
                Iterator resourcesIterator = resourceSet.getResources().iterator();
                while (resourcesIterator.hasNext()) {
                    ((Resource)resourcesIterator.next()).unload();
                }
                resourceSet.getResources().clear();
            }
            ++i;
        }
    }

    private boolean handleGenericResources(ITypedElement left, ITypedElement right, ITypedElement ancestor) throws IOException, CoreException {
        if (left instanceof ResourceNode && right instanceof IStreamContentAccessor) {
            if (((ResourceNode)left).getResource().isAccessible()) {
                this.leftResource = EclipseModelUtils.load((IPath)((ResourceNode)left).getResource().getFullPath(), (ResourceSet)new ResourceSetImpl()).eResource();
            } else {
                this.leftResource = ModelUtils.createResource((URI)URI.createPlatformResourceURI((String)((ResourceNode)left).getResource().getFullPath().toOSString(), (boolean)true));
                this.leftIsRemote = true;
            }
            try {
                this.rightResource = ModelUtils.load((InputStream)((IStreamContentAccessor)right).getContents(), (String)right.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
            }
            catch (IOException e) {
                this.rightResource = ModelUtils.createResource((URI)URI.createURI((String)right.getName()));
                this.leftIsRemote = true;
            }
            this.rightIsRemote = true;
            if (ancestor != null) {
                try {
                    this.ancestorResource = ModelUtils.load((InputStream)((IStreamContentAccessor)ancestor).getContents(), (String)ancestor.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
                }
                catch (IOException e) {
                    this.ancestorResource = ModelUtils.createResource((URI)URI.createURI((String)ancestor.getName()));
                }
            }
            return true;
        }
        boolean result = false;
        if (left instanceof IStreamContentAccessor && right instanceof IStreamContentAccessor) {
            this.leftResource = ModelUtils.load((InputStream)((IStreamContentAccessor)left).getContents(), (String)left.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
            this.rightResource = ModelUtils.load((InputStream)((IStreamContentAccessor)right).getContents(), (String)right.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
            this.rightIsRemote = true;
            this.leftIsRemote = true;
            if (ancestor != null) {
                this.ancestorResource = ModelUtils.load((InputStream)((IStreamContentAccessor)ancestor).getContents(), (String)ancestor.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
            }
            result = true;
        }
        return result;
    }

    private boolean handleLocalResources(ITypedElement left, ITypedElement right, ITypedElement ancestor) throws IOException {
        if (left instanceof ResourceNode && right instanceof ResourceNode) {
            this.leftResource = EclipseModelUtils.load((IPath)((ResourceNode)left).getResource().getFullPath(), (ResourceSet)new ResourceSetImpl()).eResource();
            this.rightResource = EclipseModelUtils.load((IPath)((ResourceNode)right).getResource().getFullPath(), (ResourceSet)new ResourceSetImpl()).eResource();
            if (ancestor != null) {
                this.ancestorResource = EclipseModelUtils.load((IPath)((ResourceNode)ancestor).getResource().getFullPath(), (ResourceSet)new ResourceSetImpl()).eResource();
            }
            return true;
        }
        return false;
    }

    final class CompareErrorDialog
    extends ErrorDialog {
        static final int COMPARE_AS_TEXT_ID = 1025;

        public CompareErrorDialog(Shell parentShell, String dialogTitle, String dialogMessage, IStatus status) {
            super(parentShell, dialogTitle, dialogMessage, status, 7);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1, IDialogConstants.OK_LABEL, true);
            if (IS_LESS_GANYMEDE) {
                this.createButton(parent, 1025, "Compare As Text", false);
            }
            this.createDetailsButton(parent);
        }

        protected void buttonPressed(int id) {
            if (id == 1025) {
                this.setReturnCode(1025);
                this.close();
            } else {
                super.buttonPressed(id);
            }
        }
    }

    private static final class TeamHandlerDescriptor {
        private static final String ATTRIBUTE_HANDLER_CLASS = "class";
        private final IConfigurationElement element;
        private AbstractTeamHandler handler;

        public TeamHandlerDescriptor(IConfigurationElement configuration) {
            this.element = configuration;
        }

        public AbstractTeamHandler getHandlerInstance() {
            if (this.handler == null) {
                try {
                    this.handler = (AbstractTeamHandler)this.element.createExecutableExtension(ATTRIBUTE_HANDLER_CLASS);
                }
                catch (CoreException e) {
                    EMFComparePlugin.log((Exception)((Object)e), (boolean)true);
                }
            }
            return this.handler;
        }

        String getHandlerClass() {
            return this.element.getAttribute(ATTRIBUTE_HANDLER_CLASS);
        }
    }
}

