/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.structure;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.ui.viewer.OrderingListener;
import org.eclipse.emf.compare.ui.viewer.content.UpdateCenterCanvasListener;
import org.eclipse.emf.compare.ui.viewer.filter.DifferenceFilterRegistry;
import org.eclipse.emf.compare.ui.viewer.filter.FiltersMenu;
import org.eclipse.emf.compare.ui.viewer.group.DifferenceGroupingFacilityRegistry;
import org.eclipse.emf.compare.ui.viewer.group.GroupsMenu;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureContentProvider;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.emf.compare.ui.viewer.structure.ParameterizedStructureContentProvider;
import org.eclipse.emf.compare.ui.viewer.structure.UpdateStructureListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ParameterizedStructureMergeViewer
extends ModelStructureMergeViewer {
    private ParameterizedStructureContentProvider mProvider;
    private List<OrderingListener> listeners = new ArrayList<OrderingListener>();

    public ParameterizedStructureMergeViewer(Composite parent, CompareConfiguration compareConfiguration) {
        super(parent, compareConfiguration);
        this.listeners.add(new UpdateStructureListener((ContentViewer)this));
        this.listeners.add(new UpdateCenterCanvasListener());
    }

    protected ModelStructureContentProvider createContentProvider(CompareConfiguration compareConfiguration) {
        this.mProvider = new ParameterizedStructureContentProvider(compareConfiguration);
        return this.mProvider;
    }

    protected void createToolItems() {
        ImageDescriptor imgDesc2;
        super.createToolItems();
        String orderingGroupName = "ordering";
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)this.getControl().getParent());
        tbm.add((IContributionItem)new Separator("ordering"));
        if (DifferenceFilterRegistry.INSTANCE.getDescriptors().size() > 0) {
            FiltersMenu filtersMenu = new FiltersMenu(this);
            try {
                imgDesc2 = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.emf.compare.ui").getEntry("icons/full/filter.gif")));
                filtersMenu.setImageDescriptor(imgDesc2);
            }
            catch (IOException imgDesc2) {
                // empty catch block
            }
            tbm.appendToGroup("ordering", (IAction)filtersMenu);
        }
        if (DifferenceGroupingFacilityRegistry.INSTANCE.getDescriptors().size() > 0) {
            GroupsMenu groupsMenu = new GroupsMenu(this);
            imgDesc2 = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
            groupsMenu.setImageDescriptor(imgDesc2);
            tbm.appendToGroup("ordering", (IAction)groupsMenu);
        }
    }

    public void fireOrderingChanged(int event, Object descriptor) {
        for (OrderingListener listener : this.listeners) {
            listener.notifyChanged(event, descriptor);
        }
    }
}

