/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.engine.GenericDiffEngine;
import org.eclipse.emf.compare.diff.engine.check.ReferencesCheck;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.uml2.diff.internal.extension.DiffExtensionFactoryRegistry;
import org.eclipse.emf.compare.uml2.diff.internal.extension.IDiffExtensionFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class UML2DiffEngine
extends GenericDiffEngine {
    private Set<IDiffExtensionFactory> uml2ExtensionFactories;

    public DiffModel doDiff(MatchModel match, boolean threeWay) {
        DiffModel ret = super.doDiff(match, threeWay);
        this.postProcess(ret);
        return ret;
    }

    public DiffModel doDiffResourceSet(MatchModel match, boolean threeWay, EcoreUtil.CrossReferencer crossReferencer) {
        DiffModel ret = super.doDiffResourceSet(match, threeWay, crossReferencer);
        this.postProcess(ret);
        return ret;
    }

    void postProcess(DiffModel dg) {
        EcoreUtil.CrossReferencer diffModelCrossReferencer = new EcoreUtil.CrossReferencer((EObject)dg){
            private static final long serialVersionUID = -7188045763674814697L;
            {
                this.crossReference();
            }
        };
        this.uml2ExtensionFactories = DiffExtensionFactoryRegistry.createExtensionFactories(this, diffModelCrossReferencer);
        ArrayList<DiffElement> toBrowse = new ArrayList<DiffElement>();
        TreeIterator tit = dg.eAllContents();
        while (tit.hasNext()) {
            EObject next = (EObject)tit.next();
            if (!(next instanceof DiffElement)) continue;
            toBrowse.add((DiffElement)next);
        }
        for (DiffElement diffElement : toBrowse) {
            this.applyManagedTypes(diffElement);
        }
    }

    void applyManagedTypes(DiffElement element) {
        for (IDiffExtensionFactory factory : this.uml2ExtensionFactories) {
            if (!factory.handles(element)) continue;
            AbstractDiffExtension extension = factory.create(element);
            DiffElement diffParent = factory.getParentDiff(element);
            diffParent.getSubDiffElements().add((Object)((DiffElement)extension));
        }
    }

    public EObject getMatched(EObject from, int side) {
        return this.getMatchedEObject(from, side);
    }

    public static int getRightSide() {
        return 2;
    }

    public static int getLeftSide() {
        return 1;
    }

    public static int getAncestorSide() {
        return 0;
    }

    protected ReferencesCheck getReferencesChecker() {
        return new UML2ReferencesCheck(this.matchCrossReferencer);
    }

    private static final class UML2ReferencesCheck
    extends ReferencesCheck {
        private static final String SUBSETS_OF_CONTAINMENT_PROPERTIES = "/org/eclipse/emf/compare/uml2/diff/internal/subsets.of.containment.properties";
        private static final Properties subsetsOfContainment = new Properties();

        static {
            try {
                subsetsOfContainment.load(UML2DiffEngine.class.getResourceAsStream(SUBSETS_OF_CONTAINMENT_PROPERTIES));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private UML2ReferencesCheck(EcoreUtil.CrossReferencer referencer) {
            super(referencer);
        }

        protected boolean shouldBeIgnored(EReference reference) {
            String fqn = this.fqn(reference);
            return super.shouldBeIgnored(reference) || subsetsOfContainment.getProperty(fqn) != null;
        }

        private String fqn(EReference reference) {
            StringBuilder fqn = new StringBuilder(reference.getEContainingClass().getName());
            fqn.append('.').append(reference.getName());
            return fqn.toString();
        }
    }
}

