/**
 * Copyright (c) 2011 Mia-Software.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 	Nicolas Guyomar (Mia-Software) - Bug 338813 - [EMF Facet Framework] basic Facet actions
 */
package org.eclipse.emf.facet.efacet.core;

import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.efacet.Facet;
import org.eclipse.emf.facet.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.core.internal.FacetActionImpl;

/**
 * This interface contains methods declaration to deal with {@link Facet}, {@link FacetSet}.
 * @since 0.2
 */
public interface IFacetAction {
	
	IFacetAction INSTANCE = new FacetActionImpl();

	/**
	 * Creates a new {@link Facet} in the given {@link FacetSet}
	 * @param facetSet the parent facetSet, cannot be null
	 * @param facet the {@link Facet}, cannot be null, or contained by a resource
	 * @param editingDomain the editing domain needed to perform the Add EMF command, cannot be null
	 * @return the new facet
	 */
	public Facet createFacetInFacetSet(FacetSet facetSet, Facet facet, EditingDomain editingDomain);

	/**
	 * 
	 * @param facet the parent {@link Facet}, cannot be null
	 * @param facetAttribute the {@link FacetAttribute}, cannot be null, or contained by a resource
	 * @param editingDomain the editing domain needed to perform the Add Emf command, cannot be null
	 */
	public void addAttributeInFacet(Facet facet, FacetAttribute facetAttribute, EditingDomain editingDomain);

	/**
	 * 
	 * @param facet the parent {@link Facet}, cannot be null
	 * @param facetReference the {@link FacetReference}, cannot be null, or contained by a resource
	 * @param editingDomain the editing domain needed to perform the Add Emf command, cannot be null
	 */
	public void addReferenceInFacet(Facet facet, FacetReference facetReference, EditingDomain editingDomain);

	/**
	 * Add a new {@link FacetOperation} to the given {@link Facet}
	 * @param facet the parent {@link Facet}, cannot be null
	 * @param facetOperation the new {@link FacetOperation}, cannot be null, or contained by a resource
	 * @param editingDomain the editing domain needed to perform the Add Emf command, cannot be null
	 */
	public void addOperationInFacet(Facet facet, FacetOperation facetOperation, EditingDomain editingDomain);

	/**
	 * Add a new {@link EParameter} to the given {@link FacetOperation}
	 * @param operation the parent {@link EOperation}
	 * @param parameter the new {@link EParameter}
	 * @param editingDomain the editing domain needed to perform the Add Emf command, cannot be null
	 */
	public void addParameterInOperation(FacetOperation operation, EParameter parameter, EditingDomain editingDomain);

	/**
	 * Set the given URI to the given {@link FacetSet}
	 * @param facetSet the {@link FacetSet} to be modified
	 * @param nsUri the Uri 
	 * @param editingDomain the editing domain needed to perform the Set Emf command, cannot be null
	 */
	public void setFacetSetNsUri(FacetSet facetSet, String nsUri, EditingDomain editingDomain);

}
