/**
 * Copyright (c) 2011 Mia-Software.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 	Nicolas Guyomar (Mia-Software) - Bug 338813 - [EMF Facet Framework] basic Facet actions
 */
package org.eclipse.emf.facet.efacet.core.internal;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.efacet.EFacetPackage;
import org.eclipse.emf.facet.efacet.Facet;
import org.eclipse.emf.facet.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.core.IFacetAction;

public class FacetActionImpl implements IFacetAction {

	public Facet createFacetInFacetSet(final FacetSet facetSet, final Facet facet,
			final EditingDomain editingDomain) {

		if (facetSet == null) {
			throw new IllegalArgumentException("The given FacetSet cannot be null"); //$NON-NLS-1$
		}
		if (facet == null) {
			throw new IllegalArgumentException("The given Facet cannot be null"); //$NON-NLS-1$
		}
		if (facet.eResource() != null || facet.eContainer() != null) {
			throw new IllegalArgumentException(
					"The given Facet cannot be contained by a resource"); //$NON-NLS-1$
		}
		if (editingDomain == null) {
			throw new IllegalArgumentException("The given EditingDomain cannot be null"); //$NON-NLS-1$
		}

		// If the current editingDomain's resourceSet does not contain the facetSet resource, then
		// we need to add it so that we can edit the facetSet
		if (!editingDomain.getResourceSet().getResources().contains(facetSet.eResource())) {
			editingDomain.getResourceSet().getResources().add(facetSet.eResource());
		}

		Command command = new AddCommand(editingDomain, facetSet,
				EFacetPackage.eINSTANCE.getFacetSet_Facets(), facet);
		editingDomain.getCommandStack().execute(command);
		return facet;
	}

	public void addAttributeInFacet(final Facet facet, final FacetAttribute facetAttribute,
			final EditingDomain editingDomain) {

		if (facet == null) {
			throw new IllegalArgumentException("The given Facet cannot be null"); //$NON-NLS-1$
		}
		if (facetAttribute == null) {
			throw new IllegalArgumentException("The given FacetAttribute cannot be null"); //$NON-NLS-1$
		}
		if (facetAttribute.eResource() != null || facetAttribute.eContainer() != null) {
			throw new IllegalArgumentException(
					"The given FacetAttribute cannot be contained by a resource"); //$NON-NLS-1$
		}
		if (editingDomain == null) {
			throw new IllegalArgumentException("The given EditingDomain cannot be null"); //$NON-NLS-1$
		}

		Command command = new AddCommand(editingDomain, facet,
				EFacetPackage.eINSTANCE.getFacet_FacetElements(), facetAttribute);
		editingDomain.getCommandStack().execute(command);
	}

	public void addReferenceInFacet(final Facet facet, final FacetReference facetReference,
			final EditingDomain editingDomain) {
		if (facet == null) {
			throw new IllegalArgumentException("The given Facet cannot be null."); //$NON-NLS-1$
		}
		if (facetReference == null) {
			throw new IllegalArgumentException("The given FacetReference cannot be null"); //$NON-NLS-1$
		}
		if (facetReference.eResource() != null || facetReference.eContainer() != null) {
			throw new IllegalArgumentException(
					"The given FacetReference cannot be contained by a resource"); //$NON-NLS-1$
		}
		if (editingDomain == null) {
			throw new IllegalArgumentException("The given EditingDomain cannot be null."); //$NON-NLS-1$
		}

		Command command = new AddCommand(editingDomain, facet,
				EFacetPackage.eINSTANCE.getFacet_FacetElements(), facetReference);
		editingDomain.getCommandStack().execute(command);
	}

	public void addOperationInFacet(final Facet facet, final FacetOperation facetOperation,
			final EditingDomain editingDomain) {
		if (editingDomain == null) {
			throw new IllegalArgumentException("The given EditingDomain cannot be null"); //$NON-NLS-1$
		}
		if (facetOperation == null) {
			throw new IllegalArgumentException("The given FacetOperation cannot be null"); //$NON-NLS-1$
		}
		if (facetOperation.eResource() != null || facetOperation.eContainer() != null) {
			throw new IllegalArgumentException(
					"The given FacetOperation cannot be contained by a resource"); //$NON-NLS-1$
		}
		if (facet == null) {
			throw new IllegalArgumentException("The given Facet cannot be null"); //$NON-NLS-1$
		}

		Command command = new AddCommand(editingDomain, facet,
				EFacetPackage.eINSTANCE.getFacet_FacetElements(), facetOperation);
		editingDomain.getCommandStack().execute(command);
	}

	public void setFacetSetNsUri(final FacetSet facetSet, final String nsUri,
			final EditingDomain editingDomain) {
		if (editingDomain == null) {
			throw new IllegalArgumentException("The given EditingDomain cannot be null"); //$NON-NLS-1$
		}
		if (facetSet == null) {
			throw new IllegalArgumentException("The given FacetSet cannot be null"); //$NON-NLS-1$
		}
		Command command = new SetCommand(editingDomain, facetSet,
				EcorePackage.eINSTANCE.getEPackage_NsURI(), nsUri);
		editingDomain.getCommandStack().execute(command);
	}

	public void addParameterInOperation(final FacetOperation operation, final EParameter parameter,
			final EditingDomain editingDomain) {
		if (operation == null) {
			throw new IllegalArgumentException("The given FacetOperation cannot be null"); //$NON-NLS-1$
		}
		if (parameter == null) {
			throw new IllegalArgumentException("The given EParameter cannot be null"); //$NON-NLS-1$
		}
		if (parameter.eResource() != null || parameter.eContainer() != null) {
			throw new IllegalArgumentException(
					"The given EParameter cannot be contained by a resource"); //$NON-NLS-1$
		}
		if (editingDomain == null) {
			throw new IllegalArgumentException("The given EditingDomain cannot be null"); //$NON-NLS-1$
		}

		Command command = new AddCommand(editingDomain, operation,
				EcorePackage.eINSTANCE.getEOperation_EParameters(), parameter);
		editingDomain.getCommandStack().execute(command);
	}
}
