/**
 * Copyright (c) 2011 Mia-Software.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 	Gregoire Dupe (Mia-Software) - Bug 333553 - The user has not to deal with two files to create a facet
 */
package org.eclipse.emf.facet.efacet.core.query;

import org.eclipse.emf.facet.efacet.Query;
import org.eclipse.emf.facet.efacet.catalog.efacetcatalog.QuerySetCatalog;
import org.eclipse.emf.facet.efacet.core.internal.query.QueryUtilsImpl;

/**
 * This interface gathers utility methods for manipulating queries.
 */
public interface IQueryUtils {

	IQueryUtils INSTANCE = new QueryUtilsImpl();

	/**
	 * This method searches in all registered {@link QuerySetCatalog}s the
	 * corresponding query in all the querySet
	 * 
	 * @param querySetName the name of the querySet to search into.
	 * @param queryName the name of the query to search for.
	 * @return the query if found, <code>null</code> otherwise
	 */
	public Query searchQuery(String querySetName, String queryName);
}
