/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.efacet.EFacetFactory;
import org.eclipse.emf.facet.efacet.ParameterValue;
import org.eclipse.emf.facet.efacet.Query;
import org.eclipse.emf.facet.efacet.QueryContext;
import org.eclipse.emf.facet.efacet.QueryResult;
import org.eclipse.emf.facet.efacet.core.IEFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.QueryException;
import org.eclipse.emf.facet.efacet.core.exception.QueryTypeCheckingException;
import org.eclipse.emf.facet.efacet.core.internal.query.QueryEvaluatorFactoryRegistry;
import org.eclipse.emf.facet.efacet.core.query.IQueryEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EFacetManager
implements IEFacetManager {
    @Override
    public Object basicEvaluate(Query query, EObject eObject, List<ParameterValue> parameterValues) throws QueryException {
        IQueryEvaluator evaluator = QueryEvaluatorFactoryRegistry.INSTANCE.getEvaluatorFor(query);
        evaluator.startEvaluate();
        Object result = this.evaluateAndCheck(query, eObject, parameterValues, evaluator);
        evaluator.endEvaluate();
        return result;
    }

    private Object evaluateAndCheck(Query query, EObject eObject, List<ParameterValue> parameterValues, IQueryEvaluator evaluator) throws QueryException {
        if (!query.getScope().isInstance((Object)eObject)) {
            StringBuffer message = new StringBuffer();
            message.append("Wrong context type (for query " + this.toString() + "): ");
            message.append(eObject.eClass().getName());
            message.append(" found; expected scopes are {");
            message.append(query.getScope().getName());
            message.append("}");
            QueryTypeCheckingException e = new QueryTypeCheckingException(message.toString());
            throw e;
        }
        Object result = evaluator.basicEvaluate(query, eObject, parameterValues);
        this.checkResult(query, result, evaluator.getCheckResultType());
        return result;
    }

    @Override
    public final Object basicEvaluate(Query query, EObject eObject) throws QueryException {
        return this.basicEvaluate(query, eObject, null);
    }

    @Override
    public final QueryResult evaluate(Query query, EObject context, List<ParameterValue> parameterValues) {
        QueryResult queryResult = EFacetFactory.eINSTANCE.createQueryResult();
        try {
            queryResult.setSource(context);
            queryResult.setResult(this.basicEvaluate(query, context, parameterValues));
        }
        catch (Exception e) {
            queryResult.setException(e);
        }
        return queryResult;
    }

    @Override
    public final synchronized List<QueryResult> evaluate(Query query, QueryContext queryContext, List<ParameterValue> parameterValues) throws QueryException {
        ArrayList<QueryResult> resultList = new ArrayList<QueryResult>();
        IQueryEvaluator evaluator = QueryEvaluatorFactoryRegistry.INSTANCE.getEvaluatorFor(query);
        try {
            evaluator.startEvaluate();
            for (EObject eObject : queryContext.getSelectedModelElements()) {
                QueryResult queryResult = this.executeQuery(query, parameterValues, eObject, evaluator);
                resultList.add(queryResult);
            }
            for (Resource resource : queryContext.getSelectedModels()) {
                TreeIterator treeIterator = resource.getAllContents();
                while (treeIterator.hasNext()) {
                    EObject eObject = (EObject)treeIterator.next();
                    QueryResult queryResult = this.executeQuery(query, parameterValues, eObject, evaluator);
                    resultList.add(queryResult);
                }
            }
        }
        finally {
            evaluator.endEvaluate();
        }
        return resultList;
    }

    @Override
    public final QueryResult evaluate(Query query, EObject eObject) {
        QueryResult queryResult = this.evaluate(query, eObject, null);
        return queryResult;
    }

    private final QueryResult executeQuery(Query query, List<ParameterValue> parameterValues, EObject eObject, IQueryEvaluator evaluator) {
        QueryResult queryResult = EFacetFactory.eINSTANCE.createQueryResult();
        queryResult.setSource(eObject);
        try {
            Object result = this.evaluateAndCheck(query, eObject, parameterValues, evaluator);
            queryResult.setResult(result);
        }
        catch (QueryException e) {
            queryResult.setException((Exception)e);
        }
        return queryResult;
    }

    private final void checkResult(Query query, Object object, boolean checkResultType) throws QueryTypeCheckingException {
        if (query.getUpperBound() > 1 || query.getUpperBound() == -1) {
            if (!(object instanceof Collection)) {
                throw new QueryTypeCheckingException("A collection is expected as result. The result is: " + object + " (on " + this.toString() + ")");
            }
            for (Object collectionElement : (Collection)object) {
                if (!checkResultType || query.getEType().isInstance(collectionElement)) continue;
                QueryTypeCheckingException e = new QueryTypeCheckingException("Wrong result collection element type (" + query.getEType().getName() + " is expected): " + collectionElement + " (on " + this.toString() + ")");
                throw e;
            }
        } else {
            if (object instanceof Collection) {
                throw new QueryTypeCheckingException("A " + query.getEType().getName() + " instance is expected as result. The result is: " + object + " (on " + this.toString() + ")");
            }
            if (checkResultType && !query.getEType().isInstance(object) && object != null) {
                throw new QueryTypeCheckingException("Wrong result type: " + object.getClass().getName() + " is returned while " + query.getEType().getInstanceClassName() + " is expected." + " (on " + this.toString() + ")");
            }
        }
    }
}

