/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.core.internal.query;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.efacet.Query;
import org.eclipse.emf.facet.efacet.core.exception.QueryException;
import org.eclipse.emf.facet.efacet.core.internal.Activator;
import org.eclipse.emf.facet.efacet.core.query.IQueryEvaluator;
import org.eclipse.emf.facet.efacet.core.query.IQueryEvaluatorFactory;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.ICatalogSetManager;

public class QueryEvaluatorFactoryRegistry {
    private static final String QUERY_EVALUATOR_REGISTRATION_ID = "org.eclipse.emf.facet.efacet.core.query.evaluatorregistration";
    private static final String CLASS = "class";
    public static final QueryEvaluatorFactoryRegistry INSTANCE = new QueryEvaluatorFactoryRegistry();
    private final List<IQueryEvaluatorFactory> queryEvaluatorFactories = new ArrayList<IQueryEvaluatorFactory>();

    public QueryEvaluatorFactoryRegistry() {
        this.initRegisteredEntries();
    }

    private void initRegisteredEntries() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(QUERY_EVALUATOR_REGISTRATION_ID);
        if (extPoint != null) {
            IExtension[] iExtensionArray = extPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElt = iConfigurationElementArray[n4];
                    try {
                        IQueryEvaluatorFactory queryEvaluatorFactory = (IQueryEvaluatorFactory)configElt.createExecutableExtension(CLASS);
                        this.queryEvaluatorFactories.add(queryEvaluatorFactory);
                    }
                    catch (CoreException e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public IQueryEvaluator getEvaluatorFor(Query query) throws QueryException {
        IQueryEvaluator queryEvaluator = null;
        boolean factoryFound = false;
        for (IQueryEvaluatorFactory queryEvaluatorFactory : this.queryEvaluatorFactories) {
            boolean bl = factoryFound = queryEvaluatorFactory.getManagedQueryType() == query.eClass();
            if (!factoryFound) continue;
            queryEvaluator = queryEvaluatorFactory.create(query, ICatalogSetManager.INSTANCE.getBundleByResource(query.eResource()));
            break;
        }
        if (!factoryFound) {
            StringBuffer sb = new StringBuffer();
            sb.append("No factory implementation found for: ");
            sb.append(query.eClass().getName());
            sb.append(":");
            sb.append(query.getName());
            sb.append("\n Available Query types are: ");
            for (IQueryEvaluatorFactory queryEvaluatorFactory : this.queryEvaluatorFactories) {
                sb.append(queryEvaluatorFactory.getManagedQueryType().getName());
                sb.append(", ");
            }
            QueryException e = new QueryException(sb.toString());
            throw e;
        }
        return queryEvaluator;
    }
}

