/**
 *  Copyright (c) 2011 Mia-Software.
 *  
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *  
 *  Contributors:
 * 	Gregoire Dupe (Mia-Software) - Design
 * 	Nicolas Guyomar (Mia-Software) - Implementation
 *  
 */
package org.eclipse.emf.facet.efacet.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.ETypedElementImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.emf.facet.efacet.EFacetPackage;
import org.eclipse.emf.facet.efacet.Parameter;
import org.eclipse.emf.facet.efacet.Query;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Query</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.efacet.impl.QueryImpl#getScope <em>Scope</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.efacet.impl.QueryImpl#isHasSideEffect <em>Has Side Effect</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.efacet.impl.QueryImpl#isCanBeCached <em>Can Be Cached</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.efacet.impl.QueryImpl#getParameters <em>Parameters</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class QueryImpl extends ETypedElementImpl implements Query {
	/**
	 * The cached value of the '{@link #getScope() <em>Scope</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScope()
	 * @generated
	 * @ordered
	 */
	protected EClass scope;

	/**
	 * The default value of the '{@link #isHasSideEffect() <em>Has Side Effect</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isHasSideEffect()
	 * @generated
	 * @ordered
	 */
	protected static final boolean HAS_SIDE_EFFECT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isHasSideEffect() <em>Has Side Effect</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isHasSideEffect()
	 * @generated
	 * @ordered
	 */
	protected boolean hasSideEffect = HAS_SIDE_EFFECT_EDEFAULT;

	/**
	 * The default value of the '{@link #isCanBeCached() <em>Can Be Cached</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCanBeCached()
	 * @generated
	 * @ordered
	 */
	protected static final boolean CAN_BE_CACHED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isCanBeCached() <em>Can Be Cached</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCanBeCached()
	 * @generated
	 * @ordered
	 */
	protected boolean canBeCached = CAN_BE_CACHED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getParameters() <em>Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<Parameter> parameters;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return EFacetPackage.Literals.QUERY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getScope() {
		if (scope != null && scope.eIsProxy()) {
			InternalEObject oldScope = (InternalEObject)scope;
			scope = (EClass)eResolveProxy(oldScope);
			if (scope != oldScope) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EFacetPackage.QUERY__SCOPE, oldScope, scope));
			}
		}
		return scope;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass basicGetScope() {
		return scope;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setScope(EClass newScope) {
		EClass oldScope = scope;
		scope = newScope;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EFacetPackage.QUERY__SCOPE, oldScope, scope));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isHasSideEffect() {
		return hasSideEffect;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHasSideEffect(boolean newHasSideEffect) {
		boolean oldHasSideEffect = hasSideEffect;
		hasSideEffect = newHasSideEffect;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EFacetPackage.QUERY__HAS_SIDE_EFFECT, oldHasSideEffect, hasSideEffect));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isCanBeCached() {
		return canBeCached;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCanBeCached(boolean newCanBeCached) {
		boolean oldCanBeCached = canBeCached;
		canBeCached = newCanBeCached;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EFacetPackage.QUERY__CAN_BE_CACHED, oldCanBeCached, canBeCached));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Parameter> getParameters() {
		if (parameters == null) {
			parameters = new EObjectContainmentEList<Parameter>(Parameter.class, this, EFacetPackage.QUERY__PARAMETERS);
		}
		return parameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case EFacetPackage.QUERY__PARAMETERS:
				return ((InternalEList<?>)getParameters()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case EFacetPackage.QUERY__SCOPE:
				if (resolve) return getScope();
				return basicGetScope();
			case EFacetPackage.QUERY__HAS_SIDE_EFFECT:
				return isHasSideEffect();
			case EFacetPackage.QUERY__CAN_BE_CACHED:
				return isCanBeCached();
			case EFacetPackage.QUERY__PARAMETERS:
				return getParameters();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case EFacetPackage.QUERY__SCOPE:
				setScope((EClass)newValue);
				return;
			case EFacetPackage.QUERY__HAS_SIDE_EFFECT:
				setHasSideEffect((Boolean)newValue);
				return;
			case EFacetPackage.QUERY__CAN_BE_CACHED:
				setCanBeCached((Boolean)newValue);
				return;
			case EFacetPackage.QUERY__PARAMETERS:
				getParameters().clear();
				getParameters().addAll((Collection<? extends Parameter>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case EFacetPackage.QUERY__SCOPE:
				setScope((EClass)null);
				return;
			case EFacetPackage.QUERY__HAS_SIDE_EFFECT:
				setHasSideEffect(HAS_SIDE_EFFECT_EDEFAULT);
				return;
			case EFacetPackage.QUERY__CAN_BE_CACHED:
				setCanBeCached(CAN_BE_CACHED_EDEFAULT);
				return;
			case EFacetPackage.QUERY__PARAMETERS:
				getParameters().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case EFacetPackage.QUERY__SCOPE:
				return scope != null;
			case EFacetPackage.QUERY__HAS_SIDE_EFFECT:
				return hasSideEffect != HAS_SIDE_EFFECT_EDEFAULT;
			case EFacetPackage.QUERY__CAN_BE_CACHED:
				return canBeCached != CAN_BE_CACHED_EDEFAULT;
			case EFacetPackage.QUERY__PARAMETERS:
				return parameters != null && !parameters.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (hasSideEffect: "); //$NON-NLS-1$
		result.append(hasSideEffect);
		result.append(", canBeCached: "); //$NON-NLS-1$
		result.append(canBeCached);
		result.append(')');
		return result.toString();
	}

} //QueryImpl
