/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.uicore.examples.cnf;

import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.browser.editors.EcoreBrowser;
import org.eclipse.emf.facet.infra.browser.uicore.examples.cnf.Activator;
import org.eclipse.emf.facet.infra.common.ui.internal.editorInputs.IResourceEditorInput;
import org.eclipse.emf.facet.infra.common.ui.internal.editorInputs.ResourceEditorInput;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.ILinkHelper;

public class LinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        if (anInput instanceof IResourceEditorInput) {
            IResourceEditorInput resourceEditorInput = (IResourceEditorInput)anInput;
            URI uri = resourceEditorInput.getResource().getURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            try {
                IFile[] files = root.findFilesForLocationURI(new java.net.URI(uri.toString()));
                if (files.length > 0) {
                    return new StructuredSelection((Object)files[0]);
                }
            }
            catch (URISyntaxException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            if (uri.isPlatformResource()) {
                String location = uri.toPlatformString(true);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(location);
                if (resource != null) {
                    return new StructuredSelection((Object)resource);
                }
            }
        }
        return null;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        ResourceEditorInput resourceEditorInput;
        IEditorPart editorPart;
        Object firstElement = aSelection.getFirstElement();
        EObject eObject = (EObject)Platform.getAdapterManager().getAdapter(firstElement, EObject.class);
        if (eObject != null && (editorPart = aPage.findEditor((IEditorInput)(resourceEditorInput = new ResourceEditorInput(eObject.eResource())))) instanceof EcoreBrowser) {
            EcoreBrowser browser = (EcoreBrowser)editorPart;
            String uriFragment = eObject.eResource().getURIFragment(eObject);
            browser.browseToByURI(uriFragment);
        }
    }
}

