/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.facet.infra.browser.BrowserPlugin;
import org.eclipse.emf.facet.infra.browser.Messages;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.AttributeItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class BrowserUtils {
    private BrowserUtils() {
    }

    public static URIConverter createURIConverter() {
        List defaultHandlers = URIHandler.DEFAULT_HANDLERS;
        ArrayList<Object> uriHandlers = new ArrayList<Object>();
        for (URIHandler uriHandler : defaultHandlers) {
            if (uriHandler.getClass() == URIHandlerImpl.class) continue;
            uriHandlers.add(uriHandler);
        }
        uriHandlers.add(new URIHandlerImpl(){

            public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
                return new HashMap();
            }
        });
        return new ExtensibleURIConverterImpl(uriHandlers, (Collection)ContentHandler.Registry.INSTANCE.contentHandlers());
    }

    public static int askUserForDepthToLoadReferencedResources(int initialValue, final Shell shell) {
        final IInputValidator validator = new IInputValidator(){

            public String isValid(String inputText) {
                if ("*".equals(inputText)) {
                    return null;
                }
                try {
                    Integer.parseInt(inputText);
                }
                catch (NumberFormatException e) {
                    return NLS.bind((String)Messages.EcoreBrowser_notAPositiveInteger, (Object)inputText);
                }
                return null;
            }
        };
        final String initialValueStr = initialValue == -1 ? "*" : Integer.toString(initialValue);
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                InputDialog inputDialog = new InputDialog(shell, Messages.EcoreBrowser_selectDepthReferencedResources, String.valueOf(Messages.EcoreBrowser_modelContainsProxies) + Messages.EcoreBrowser_chooseLoadProxiesDepth, initialValueStr, validator);
                if (inputDialog.open() == 0) {
                    String value = inputDialog.getValue();
                    if (value == null) {
                        result[0] = 0;
                    }
                    if ("*".equals(value)) {
                        result[0] = -1;
                    }
                    try {
                        result[0] = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        BrowserPlugin.logException(e);
                        result[0] = 0;
                    }
                }
            }
        });
        return result[0];
    }

    public static void handleCopyToClipboard(ISelection selection) {
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            StringBuilder builder = new StringBuilder();
            Iterator iterator = treeSelection.iterator();
            while (iterator.hasNext()) {
                Object selectedElement;
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                if ((selectedElement = iterator.next()) instanceof ModelElementItem) {
                    ModelElementItem modelElementItem = (ModelElementItem)selectedElement;
                    builder.append(modelElementItem.getName());
                    continue;
                }
                if (selectedElement instanceof AttributeItem) {
                    AttributeItem attributeItem = (AttributeItem)selectedElement;
                    String valueText = attributeItem.getValueText();
                    builder.append(valueText);
                    continue;
                }
                if (selectedElement instanceof LinkItem) {
                    LinkItem linkItem = (LinkItem)selectedElement;
                    builder.append(linkItem.getReference().getName());
                    continue;
                }
                if (selectedElement instanceof ITreeElement) {
                    ITreeElement treeElement = (ITreeElement)selectedElement;
                    builder.append(treeElement.getText());
                    continue;
                }
                builder.append(selectedElement.toString());
            }
            Clipboard clipboard = new Clipboard(Display.getDefault());
            clipboard.setContents(new Object[]{builder.toString()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    public static ISelection unwrapSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<Object> elements = new ArrayList<Object>();
            for (Object element : structuredSelection) {
                if (element instanceof ModelElementItem) {
                    ModelElementItem modelElementItem = (ModelElementItem)element;
                    elements.add(modelElementItem.getEObject());
                    continue;
                }
                if (element instanceof LinkItem) {
                    LinkItem linkItem = (LinkItem)element;
                    elements.add(linkItem.getReference());
                    continue;
                }
                if (element instanceof AttributeItem) {
                    AttributeItem attributeItem = (AttributeItem)element;
                    elements.add(attributeItem.getAttribute());
                    continue;
                }
                elements.add(element);
            }
            return new StructuredSelection(elements);
        }
        return selection;
    }
}

