/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.editors;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.emf.facet.infra.browser.BrowserPlugin;
import org.eclipse.emf.facet.infra.browser.Messages;
import org.eclipse.emf.facet.infra.browser.core.DragAndDropOnLinkCommand;
import org.eclipse.emf.facet.infra.browser.core.DragAndDropOnModelElementCommand;
import org.eclipse.emf.facet.infra.browser.core.InstancesForMetaclass;
import org.eclipse.emf.facet.infra.browser.core.InstancesForMetaclasses;
import org.eclipse.emf.facet.infra.browser.core.MetaclassList;
import org.eclipse.emf.facet.infra.browser.core.ModelElementItemEx;
import org.eclipse.emf.facet.infra.browser.core.QueryItem;
import org.eclipse.emf.facet.infra.browser.core.SearchResults;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.editors.BrowserActionBarContributor;
import org.eclipse.emf.facet.infra.browser.editors.BrowserConfiguration;
import org.eclipse.emf.facet.infra.browser.editors.BrowserContentProvider;
import org.eclipse.emf.facet.infra.browser.editors.BrowserEditingDomain;
import org.eclipse.emf.facet.infra.browser.editors.BrowserLabelProvider;
import org.eclipse.emf.facet.infra.browser.editors.BrowserNavigationLocation;
import org.eclipse.emf.facet.infra.browser.editors.BrowserSettingsPersistence;
import org.eclipse.emf.facet.infra.browser.editors.BrowserUtils;
import org.eclipse.emf.facet.infra.browser.editors.DragAdapter;
import org.eclipse.emf.facet.infra.browser.editors.FacetTooltip;
import org.eclipse.emf.facet.infra.browser.editors.IBrowserSelectionChangedListener;
import org.eclipse.emf.facet.infra.browser.editors.LeftPane;
import org.eclipse.emf.facet.infra.browser.editors.MetaclassViewer;
import org.eclipse.emf.facet.infra.browser.editors.ReadOnlyCommandStack;
import org.eclipse.emf.facet.infra.browser.editors.TreeToolBar;
import org.eclipse.emf.facet.infra.browser.editors.UnwrappingSelectionProvider;
import org.eclipse.emf.facet.infra.browser.editors.WorkspaceChangeListener;
import org.eclipse.emf.facet.infra.browser.extensions.LoadingDepthRegistry;
import org.eclipse.emf.facet.infra.browser.queries.SelectedQueriesManager;
import org.eclipse.emf.facet.infra.browser.queries.SelectedQuery;
import org.eclipse.emf.facet.infra.browser.uicore.ChangeListener;
import org.eclipse.emf.facet.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.emf.facet.infra.browser.uicore.internal.CustomTreePainter;
import org.eclipse.emf.facet.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.AttributeItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.BigListItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.EMFUtil;
import org.eclipse.emf.facet.infra.common.core.internal.adapters.instances.MetaclassInstances;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.ui.internal.controls.FormStyleSashForm;
import org.eclipse.emf.facet.infra.common.ui.internal.controls.Tooltip;
import org.eclipse.emf.facet.infra.common.ui.internal.editorInputs.IResourceEditorInput;
import org.eclipse.emf.facet.infra.common.ui.internal.util.DialogUtils;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.facet.core.adapters.instances.MetaclassInstancesAdapterFactoryWithFacet;
import org.eclipse.emf.facet.infra.facet.core.adapters.instances.MetaclassInstancesAdapterWithFacet;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreBrowser
extends EditorPart
implements ISelectionProvider,
IMenuListener,
IViewerProvider,
INavigationLocationProvider,
InstancesForMetaclasses.MetaclassesChangeListener,
IEditingDomainProvider,
IGotoMarker {
    public static final String MENU_ID = "org.eclipse.emf.facet.infra.browser.editorID.menu";
    private static final int MAIN_FORM_MARGIN_HEIGHT = 6;
    private static final int MAIN_FORM_MARGIN_WIDTH = 4;
    private static final int RIGHT_PANE_SASH_WEIGHT = 65;
    private static final int LEFT_PANE_SASH_WEIGHT = 35;
    private static final int SASH_WIDTH = 4;
    public static final String EDITOR_ID = "org.eclipse.emf.facet.infra.browser.editorID";
    private static final String PROPERTY_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    private ResourceSet fResourceSet;
    private Resource model;
    private ComposedAdapterFactory adapterFactoryWithRegistry;
    private IPropertySheetPage propertySheetPage;
    private TreeViewer treeViewer;
    private Tree fTree;
    private MetaclassViewer metaclassViewer;
    private ISelectionChangedListener selectionChangedListener;
    private final Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private ISelection editorSelection = StructuredSelection.EMPTY;
    private final Collection<Resource> removedResources = new ArrayList<Resource>();
    private final Collection<Resource> changedResources = new ArrayList<Resource>();
    private final Collection<Resource> savedResources = new ArrayList<Resource>();
    private final IResourceChangeListener resourceChangeListener;
    private boolean updateProblemIndication = true;
    private final Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    private final MarkerHelper markerHelper = new EditUIMarkerHelper();
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == EcoreBrowser.this.getPropertySheetPage()) {
                    EcoreBrowser.this.getActionBarContributor().setActiveEditor((IEditorPart)EcoreBrowser.this);
                    EcoreBrowser.this.handleActivate();
                }
            } else if (p == EcoreBrowser.this) {
                EcoreBrowser.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    private AdapterFactoryEditingDomain editingDomain;
    private final BrowserConfiguration browserConfiguration = new BrowserConfiguration(this);
    private Composite parentComposite;
    private Text searchBox;
    private Job searchJob = null;
    private Object savedInput;
    private IPropertyChangeListener fontChangeListener;
    private ChangeListener fCustomizationEngineChangeListener = null;
    private AbstractEmfFacetCatalog.EmfFacetCatalogChangeListener fFacetsChangeListener = null;
    private Job refreshJob = null;
    private FormStyleSashForm sashForm;
    private int styleSashForm = 256;
    private CustomTreePainter customTreePainter;
    private FormToolkit fFormToolkit;
    private Form form;
    private LeftPane leftPane;
    private TreeToolBar instancesToolBar;
    private BrowserSettingsPersistence settingsPersistence;
    private boolean disposing = false;
    protected static final String LOADING_MESSAGE = Messages.EcoreBrowser_loadingModelPlaceholder;
    public static final String HUMAN_READABLE_NAME = Messages.EcoreBrowser_EMF_Facet_Model_Browser;
    private Collection<EPackage> referencedEPackages = null;
    private Composite typesPaneComposite;
    private Composite instancesPaneComposite;
    private Job openModelJob = null;

    public EcoreBrowser() {
        this.browserConfiguration.getAppearanceConfiguration().load();
        this.resourceChangeListener = new WorkspaceChangeListener(this);
    }

    public void setSelectionToViewer(Collection<?> selection) {
        final Collection<?> theSelection = selection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (EcoreBrowser.this.treeViewer != null) {
                        EcoreBrowser.this.treeViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public MetaclassViewer getMetaclassViewer() {
        return this.metaclassViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(MENU_ID, contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
    }

    protected Resource createModel() {
        Resource result = null;
        this.fResourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        try {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof FileEditorInput) {
                result = this.editingDomain.getResourceSet().getResource(resourceURI, true);
                this.fResourceSet = this.editingDomain.getResourceSet();
            } else if (editorInput instanceof IResourceEditorInput) {
                IResourceEditorInput resourceEditorInput = (IResourceEditorInput)editorInput;
                result = resourceEditorInput.getResource();
                ResourceSet resourceSet = result.getResourceSet();
                if (resourceSet != null) {
                    this.fResourceSet = resourceSet;
                }
                this.setPartName(resourceEditorInput.getName());
            } else if (editorInput instanceof IStorageEditorInput) {
                IStorageEditorInput storageEditorInput = (IStorageEditorInput)editorInput;
                IStorage storage = storageEditorInput.getStorage();
                InputStream inputStream = storage.getContents();
                Resource resource = this.fResourceSet.createResource(URI.createURI((String)resourceURI.toString()));
                resource.load(inputStream, Collections.emptyMap());
                result = resource;
            } else {
                String resolveURI = resourceURI.toString();
                EPackage ePackage = this.fResourceSet.getPackageRegistry().getEPackage(resolveURI);
                if (ePackage != null) {
                    result = ePackage.eResource();
                    if (result != null) {
                        this.fResourceSet.getResources().add((Object)result);
                        this.setPartName(ePackage.getName());
                    }
                } else {
                    MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)Messages.EcoreBrowser_cannotOpenModelFromURI, (String)NLS.bind((String)Messages.EcoreBrowser_cannotFindEPackageWithThatURI, (Object)resolveURI));
                }
            }
        }
        catch (Exception e) {
            BrowserPlugin.logException(e);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)EcoreBrowser.this.parentComposite.getShell(), (String)Messages.EcoreBrowser_errorLoadingModel, (String)e.toString());
                }
            });
            this.fResourceSet.getResource(resourceURI, false);
        }
        this.fResourceSet.setURIConverter(BrowserUtils.createURIConverter());
        return result;
    }

    protected void setPartName(final String partName) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                EcoreBrowser.super.setPartName(partName);
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.fFormToolkit = new FormToolkit(parent.getDisplay());
        this.form = this.fFormToolkit.createForm(parent);
        this.parentComposite = parent;
        parent.setLayout((Layout)new FillLayout());
        this.initializeEditingDomain();
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 4;
        fillLayout.marginHeight = 6;
        this.form.getBody().setLayout((Layout)fillLayout);
        this.browserConfiguration.getAppearanceConfiguration().setAdapterFactory(this.adapterFactoryWithRegistry);
        this.browserConfiguration.setSelectedQueriesManager(new SelectedQueriesManager());
        this.sashForm = new FormStyleSashForm(this.form.getBody(), this.styleSashForm, this.fFormToolkit){

            protected void createContents() {
                EcoreBrowser.this.createLeftPane((Composite)this);
                EcoreBrowser.this.createTreePane((Composite)this);
            }
        };
        this.sashForm.setSashWidth(4);
        this.setupInitialTreeFont();
        this.sashForm.setWeights(new int[]{35, 65});
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EcoreBrowser.this.markNavigationLocation();
            }
        });
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
        DragAdapter.create((StructuredViewer)this.treeViewer);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        EditingDomainViewerDropAdapter editingDomainViewerDropAdapter = new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)this.treeViewer);
        this.treeViewer.addDropSupport(dndOperations, transfers, (DropTargetListener)editingDomainViewerDropAdapter);
        this.getMetaclassViewer().setInput(LOADING_MESSAGE);
        this.treeViewer.setInput((Object)LOADING_MESSAGE);
        this.createAttributeItemTooltip();
    }

    private void createAttributeItemTooltip() {
        Tooltip tooltip = new Tooltip(){

            protected String getText(TreeItem item) {
                AttributeItem attributeItem;
                Object data = item.getData();
                if (data instanceof AttributeItem && !(attributeItem = (AttributeItem)data).getText().contains(attributeItem.getValueText())) {
                    return attributeItem.getValueText();
                }
                return null;
            }

            protected void positionTooltip(TreeItem treeItem, Point pt, Point tooltipSize) {
                Point point = EcoreBrowser.this.treeViewer.getTree().toDisplay(treeItem.getBounds().x, treeItem.getBounds().y);
                pt.x = point.x;
                pt.y = point.y;
            }
        };
        tooltip.installOn(this.treeViewer.getTree());
    }

    protected boolean backgroundOpenModel(IProgressMonitor monitor) {
        try {
            this.checkCancelled(monitor);
            this.initResourceSet();
            this.checkCancelled(monitor);
            this.loadDefaultFacetSets(this.model);
            IDialogSettings settingsForCurrentMetamodel = this.getSettingsPersistence().loadLastSettingsForCurrentMetamodel();
            List<Facet> lastFacets = this.getSettingsPersistence().getLastFacets(settingsForCurrentMetamodel);
            for (Facet facet : lastFacets) {
                this.browserConfiguration.getAppearanceConfiguration().loadFacet(facet);
                this.checkCancelled(monitor);
            }
            List<MetamodelView> lastCustomizations = this.getSettingsPersistence().getLastCustomizations(settingsForCurrentMetamodel);
            if (lastCustomizations.size() > 0) {
                this.loadCustomizations(lastCustomizations);
            } else {
                this.loadDefaultCustomizations();
            }
            this.checkCancelled(monitor);
            this.browserConfiguration.getInstancesForMetaclasses().buildDerivationTree();
            this.reloadOnFacetChange();
            this.checkCancelled(monitor);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    EcoreBrowser.this.getMetaclassViewer().setInput(EcoreBrowser.this.getBrowserConfiguration().getInstancesForMetaclasses());
                    EcoreBrowser.this.getMetaclassViewer().selectRootElement();
                }
            });
        }
        catch (CancellationException e) {
            return false;
        }
        catch (ThreadDeath e) {
            return false;
        }
        return true;
    }

    private void checkCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled() || this.treeViewer.getTree().isDisposed()) {
            throw new CancellationException();
        }
    }

    public BrowserSettingsPersistence getSettingsPersistence() {
        if (this.settingsPersistence == null) {
            this.settingsPersistence = new BrowserSettingsPersistence(this.getMetamodelURI(), (IWorkbenchPart)this, this.browserConfiguration);
        }
        return this.settingsPersistence;
    }

    public String getMetamodelURI() {
        try {
            EObject eObject;
            EClass eClass;
            EList contents = this.model.getContents();
            if (contents.size() > 0 && (eClass = (eObject = (EObject)contents.get(0)).eClass()) != null) {
                return eClass.getEPackage().getNsURI();
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)BrowserPlugin.getPlugin());
        }
        return "";
    }

    public Collection<EPackage> getReferencedEPackages() {
        if (this.referencedEPackages != null) {
            return this.referencedEPackages;
        }
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        try {
            TreeIterator allContents = this.model.getAllContents();
            while (allContents.hasNext()) {
                EPackage ePackage;
                EObject eObject = (EObject)allContents.next();
                EClass eClass = eObject.eClass();
                if (eClass == null || (ePackage = eClass.getEPackage()) == null) continue;
                ePackages.add(ePackage);
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)BrowserPlugin.getPlugin());
        }
        this.referencedEPackages = ePackages;
        return ePackages;
    }

    protected void initResourceSet() {
        this.fResourceSet = this.createResourceSet();
        HashSet<Resource> browsedResources = new HashSet<Resource>();
        Resource mainResource = this.model = this.createModel();
        browsedResources.add(mainResource);
        this.browserConfiguration.setResourceSet(this.fResourceSet);
        this.addReferencedResources(mainResource, browsedResources);
        this.browserConfiguration.setBrowsedResources(browsedResources);
        this.browserConfiguration.getAppearanceConfiguration().getFacetContext().setResources(browsedResources);
        final InstancesForMetaclasses instancesForMetaclasses = this.createInstancesForMetaclasses(browsedResources);
        this.browserConfiguration.setInstancesForMetaclasses(instancesForMetaclasses);
        instancesForMetaclasses.addListener(this);
        this.fResourceSet.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object newValue;
                int eventType;
                if (notification.getFeatureID(ResourceSet.class) == 0 && (eventType = notification.getEventType()) == 3 && (newValue = notification.getNewValue()) instanceof Resource) {
                    Resource resource = (Resource)newValue;
                    instancesForMetaclasses.watchResource(resource);
                    EcoreBrowser.this.refreshDelayed(true);
                }
            }
        });
    }

    protected InstancesForMetaclasses createInstancesForMetaclasses(Set<Resource> browsedResources) {
        return new InstancesForMetaclasses(this.browserConfiguration, browsedResources);
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    private void loadDefaultFacetSets(Resource resource) {
        for (EObject root : resource.getContents()) {
            EPackage rootEPackage = root.eClass().getEPackage();
            Set defaultFacetSets = FacetSetCatalog.getSingleton().getDefaultFacetSets(rootEPackage);
            if (defaultFacetSets == null) continue;
            for (FacetSet facetSet : defaultFacetSets) {
                if (facetSet == null) continue;
                this.browserConfiguration.getAppearanceConfiguration().getFacetContext().addFacetSet(facetSet);
            }
        }
    }

    private void addReferencedResources(Resource resource, Set<Resource> allResources) {
        IPreferenceStore preferenceStore = BrowserPlugin.getPlugin().getPreferenceStore();
        int registryLoadingDepth = LoadingDepthRegistry.getInstance().getLoadingDepth(this.getMetamodelURI());
        if (preferenceStore.getInt("browser_loading_depth") != 0 || preferenceStore.getBoolean("browser_ask_loading_depth") || registryLoadingDepth != -2 && registryLoadingDepth != 0) {
            this.addReferencedResourcesInternal(resource, allResources, 1);
        }
    }

    private void addReferencedResourcesInternal(Resource resource, Set<Resource> allResources, int currentDepth) {
        HashSet<Resource> directReferencedResources = new HashSet<Resource>();
        for (EObject root : resource.getContents()) {
            Map externalReferences = EcoreUtil.ExternalCrossReferencer.find((EObject)root);
            if (externalReferences.isEmpty()) continue;
            int loadingDepth = this.browserConfiguration.getReferencedResourcesLoadingDepth();
            if (loadingDepth == -2) {
                int registryLoadingDepth = LoadingDepthRegistry.getInstance().getLoadingDepth(this.getMetamodelURI());
                boolean overridden = BrowserPlugin.getPlugin().getPreferenceStore().getBoolean("override_metamodel_specific_settings");
                if (registryLoadingDepth == -2 || overridden) {
                    int defaultLoadingDepth = BrowserPlugin.getPlugin().getPreferenceStore().getInt("browser_loading_depth");
                    if (BrowserPlugin.getPlugin().getPreferenceStore().getBoolean("browser_ask_loading_depth")) {
                        loadingDepth = BrowserUtils.askUserForDepthToLoadReferencedResources(defaultLoadingDepth, this.getSite().getShell());
                    } else {
                        loadingDepth = defaultLoadingDepth;
                        if (loadingDepth < -1) {
                            loadingDepth = 0;
                        }
                    }
                } else {
                    loadingDepth = registryLoadingDepth;
                }
                this.browserConfiguration.setReferencedResourcesLoadingDepth(loadingDepth);
            }
            if (loadingDepth != -1 && loadingDepth < currentDepth) {
                return;
            }
            for (EObject external : externalReferences.keySet()) {
                Resource externalResource = external.eIsProxy() ? EcoreUtil.resolve((EObject)external, (EObject)root).eResource() : external.eResource();
                if (externalResource != null) {
                    directReferencedResources.add(externalResource);
                    continue;
                }
                Logger.logError((String)("Failed to load an external element: " + external.eClass().getName() + " " + EcoreUtil.getURI((EObject)external)), (Plugin)BrowserPlugin.getPlugin());
            }
        }
        int loadingDepth = this.browserConfiguration.getReferencedResourcesLoadingDepth();
        for (Resource directlyReferencedResource : directReferencedResources) {
            if (allResources.contains(directlyReferencedResource)) continue;
            allResources.add(directlyReferencedResource);
            if (loadingDepth != -1 && currentDepth + 1 > loadingDepth) continue;
            this.addReferencedResourcesInternal(directlyReferencedResource, allResources, currentDepth + 1);
        }
    }

    protected void createLeftPane(Composite parent) {
        Section section = this.fFormToolkit.createSection(parent, 320);
        section.setText(Messages.EcoreBrowser_metaclasses);
        this.typesPaneComposite = this.fFormToolkit.createComposite((Composite)section);
        section.setClient((Control)this.typesPaneComposite);
        this.leftPane = this.initLeftPane(section, this.fFormToolkit);
        Composite toolBar = this.leftPane.getToolBarComposite();
        section.setTextClient((Control)toolBar);
        this.typesPaneComposite.setLayout((Layout)new FillLayout());
        this.metaclassViewer = this.leftPane.getMetaclassViewer();
        this.metaclassViewer.addSelectionChangedListener(new MetaclassListViewerSelectionChangedListener());
    }

    protected LeftPane initLeftPane(Section section, FormToolkit formToolkit) {
        return new LeftPane((Composite)section, (Composite)section.getClient(), this.browserConfiguration, formToolkit, this.getSite());
    }

    protected void createTreePane(Composite parent) {
        Section section = this.fFormToolkit.createSection(parent, 320);
        section.setText(Messages.EcoreBrowser_instances);
        this.instancesPaneComposite = this.fFormToolkit.createComposite((Composite)section, 0);
        section.setClient((Control)this.instancesPaneComposite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.instancesPaneComposite.setLayout((Layout)layout);
        Composite treeToolBar = this.createTreeToolBar((Composite)section);
        section.setTextClient((Control)treeToolBar);
        this.createSearchPanel(this.instancesPaneComposite);
        this.fTree = this.fFormToolkit.createTree(this.instancesPaneComposite, 2050);
        GridData treeGridData = new GridData();
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.horizontalAlignment = 4;
        treeGridData.verticalAlignment = 4;
        this.fTree.setLayoutData((Object)treeGridData);
        this.fTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    EcoreBrowser.this.searchBox.setText("");
                    EcoreBrowser.this.search();
                } else if (e.keyCode == 13) {
                    EcoreBrowser.this.handleEnter();
                } else if (e.keyCode == 99 && e.stateMask == 262144) {
                    BrowserUtils.handleCopyToClipboard(EcoreBrowser.this.getEditorSelection());
                } else if (e.keyCode == 127) {
                    EcoreBrowser.this.handleDel();
                }
            }
        });
        this.customTreePainter = new CustomTreePainter(this.fTree, this.browserConfiguration.getAppearanceConfiguration());
        FacetTooltip.create(this.fTree, this.browserConfiguration.getAppearanceConfiguration());
        this.treeViewer = new TreeViewer(this.fTree);
        this.treeViewer.setUseHashlookup(true);
        this.hookViewerToSelection((Viewer)this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new BrowserContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BrowserLabelProvider());
        this.registerShowPropertyViewOnDblClick(this.fTree);
    }

    protected void handleEnter() {
        ISelection selection = this.getEditorSelection();
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            Object selectedElement = treeSelection.getFirstElement();
            if (selectedElement instanceof ModelElementItem) {
                this.browse();
            } else if (selectedElement instanceof AttributeItem || selectedElement instanceof LinkItem) {
                this.openPropertiesView();
            } else if (selectedElement instanceof QueryItem) {
                QueryItem queryItem = (QueryItem)selectedElement;
                SelectedQuery query = queryItem.getQuery();
                query.executeQuery();
            }
        }
    }

    protected void handleDel() {
        ISelection selection = this.getEditorSelection();
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            for (Object selectedElement : treeSelection) {
                if (!(selectedElement instanceof QueryItem)) continue;
                QueryItem queryItem = (QueryItem)selectedElement;
                this.browserConfiguration.getSelectedQueriesManager().remove(queryItem.getQuery());
            }
        }
    }

    private void setupInitialTreeFont() {
        this.setupPreferredFont();
        this.fontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.jface.dialogfont")) {
                    EcoreBrowser.this.setupPreferredFont();
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fontChangeListener);
    }

    private void setupPreferredFont() {
        FontDescriptor descriptor = FontDescriptor.createFrom((Font)JFaceResources.getDialogFont());
        descriptor = descriptor.increaseHeight(this.browserConfiguration.getAppearanceConfiguration().getFontSizeDelta());
        Font customFont = descriptor.createFont((Device)Display.getDefault());
        descriptor = descriptor.setStyle(2);
        Font customItalicFont = descriptor.createFont((Device)Display.getDefault());
        this.browserConfiguration.getAppearanceConfiguration().setCustomFont(customFont);
        this.browserConfiguration.getAppearanceConfiguration().setCustomItalicFont(customItalicFont);
        this.fTree.setFont(customFont);
        this.treeViewer.refresh();
        this.metaclassViewer.setFont(customFont);
        this.metaclassViewer.refresh();
    }

    protected Composite createTreeToolBar(Composite parent) {
        Composite treeToolBarComposite = new Composite(parent, 64);
        this.instancesToolBar = TreeToolBar.create(treeToolBarComposite, this);
        return treeToolBarComposite;
    }

    private void registerShowPropertyViewOnDblClick(final Tree tree) {
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                boolean handled = false;
                if (event.button == 1) {
                    TreeItem[] selection;
                    TreeItem[] treeItemArray = selection = tree.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem treeItem = treeItemArray[n2];
                        Object element = treeItem.getData();
                        if (element instanceof QueryItem) {
                            QueryItem queryItem = (QueryItem)element;
                            SelectedQuery query = queryItem.getQuery();
                            query.executeQuery();
                            handled = true;
                        }
                        ++n2;
                    }
                    if (!handled) {
                        EcoreBrowser.this.openPropertiesView();
                    }
                }
            }
        });
    }

    protected void createSearchPanel(Composite parent) {
        Composite searchPanel = new Composite(parent, 0);
        searchPanel.setLayout((Layout)new GridLayout());
        searchPanel.setLayout((Layout)new FillLayout());
        GridData searchPanelGridData = new GridData();
        searchPanelGridData.grabExcessHorizontalSpace = true;
        searchPanelGridData.horizontalAlignment = 4;
        searchPanel.setLayoutData((Object)searchPanelGridData);
        this.searchBox = new Text(searchPanel, 128);
        this.searchBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    EcoreBrowser.this.search();
                } else if (e.keyCode == 27) {
                    EcoreBrowser.this.searchBox.setText("");
                    EcoreBrowser.this.search();
                }
            }
        });
        this.searchBox.setMessage(Messages.EcoreBrowser_typeFilterText);
        this.searchBox.setData("org.eclipse.swtbot.widget.key", (Object)"EcoreBrowser.searchBox");
    }

    protected void search() {
        final String searchText = this.searchBox.getText().toLowerCase();
        if (searchText.trim().length() == 0) {
            if (this.savedInput != null && this.savedInput != this.treeViewer.getInput()) {
                this.treeViewer.setInput(this.savedInput);
            }
            return;
        }
        final List<EClass> selectedMetaclasses = this.findSelectedEClasses();
        if (selectedMetaclasses.isEmpty()) {
            return;
        }
        this.searchJob = new Job(Messages.EcoreBrowser_jobName_SearchInModelEditor){

            protected IStatus run(IProgressMonitor monitor) {
                ResourceSet resourceSet = EcoreBrowser.this.fResourceSet;
                EList resources = resourceSet.getResources();
                if (resources.size() < 1) {
                    return Status.OK_STATUS;
                }
                final SearchResults searchResults = new SearchResults(EcoreBrowser.this.browserConfiguration);
                Resource resource = (Resource)resources.get(0);
                TreeIterator allContents = resource.getAllContents();
                while (allContents.hasNext()) {
                    ModelElementItemEx modelElementItem;
                    String objectText;
                    EObject eObject = (EObject)allContents.next();
                    if (selectedMetaclasses.contains(eObject.eClass()) && (objectText = (modelElementItem = new ModelElementItemEx(eObject, null, EcoreBrowser.this.browserConfiguration)).getName().toLowerCase()).contains(searchText)) {
                        searchResults.add(eObject);
                    }
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        EcoreBrowser.this.treeViewer.setSelection(null);
                        EcoreBrowser.this.treeViewer.setInput((Object)searchResults);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.searchJob.setUser(true);
        this.searchJob.setPriority(30);
        this.searchJob.schedule();
    }

    private List<EClass> findSelectedEClasses() {
        ArrayList<EClass> selectedMetaclasses = new ArrayList<EClass>();
        ISelection selection = this.metaclassViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof EClass)) continue;
                EClass eClass = (EClass)element;
                this.addMetaclassToSelection(eClass, selectedMetaclasses, this.browserConfiguration.getAppearanceConfiguration().isDisplayInstancesOfSubclasses());
            }
        }
        return selectedMetaclasses;
    }

    private void addMetaclassToSelection(EClass eClass, ArrayList<EClass> selectedMetaclasses, boolean addSubclasses) {
        selectedMetaclasses.add(eClass);
        if (addSubclasses) {
            InstancesForMetaclasses instancesForMetaclasses = this.browserConfiguration.getInstancesForMetaclasses();
            InstancesForMetaclass instancesForMetaclass = instancesForMetaclasses.getInstancesForMetaclass(eClass);
            if (instancesForMetaclass != null) {
                InstancesForMetaclass[] subclasses;
                InstancesForMetaclass[] instancesForMetaclassArray = subclasses = instancesForMetaclass.getSubclasses();
                int n = subclasses.length;
                int n2 = 0;
                while (n2 < n) {
                    InstancesForMetaclass subclass = instancesForMetaclassArray[n2];
                    this.addMetaclassToSelection(subclass.getEClass(), selectedMetaclasses, addSubclasses);
                    ++n2;
                }
            } else {
                Logger.logError((String)("Could not find subclasses of '" + eClass.getName() + "'"), (Plugin)BrowserPlugin.getPlugin());
            }
        }
    }

    public void setShowEmptyLinks(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowEmptyLinks(value);
        this.internalRefreshTree();
    }

    public boolean isShowEmptyLinks() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowEmptyLinks();
    }

    public void setSortInstances(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setSortInstances(value);
        this.internalRefreshTree();
    }

    public boolean isSortInstances() {
        return this.browserConfiguration.getAppearanceConfiguration().isSortInstances();
    }

    public void setShowDerivedLinks(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowDerivedLinks(value);
        this.internalRefreshTree();
    }

    public boolean isShowDerivedLinks() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowDerivedLinks();
    }

    public void setShowFullQualifiedNames(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowFullQualifiedNames(value);
        this.internalRefreshTree();
        this.metaclassViewer.refresh();
    }

    public boolean isShowFullQualifiedNames() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowFullQualifiedNames();
    }

    public void setShowMultiplicity(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowMultiplicity(value);
        this.internalRefreshTree();
    }

    public boolean isShowMultiplicity() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowMultiplicity();
    }

    public void setShowOppositeLinks(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowOppositeLinks(value);
        this.internalRefreshTree();
    }

    public boolean isShowOppositeLinks() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowOppositeLinks();
    }

    public void setShowContainer(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowContainer(value);
        this.internalRefreshTree();
    }

    public boolean isShowContainer() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowContainer();
    }

    public void setSortLinks(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setSortLinks(value);
        this.internalRefreshTree();
    }

    public boolean isSortLinks() {
        return this.browserConfiguration.getAppearanceConfiguration().isSortLinks();
    }

    public void setSortLinksByType(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setSortLinksByType(value);
        this.internalRefreshTree();
    }

    public boolean isSortLinksByType() {
        return this.browserConfiguration.getAppearanceConfiguration().isSortLinksByType();
    }

    public void setShowAttributes(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowAttributes(value);
        this.internalRefreshTree();
    }

    public boolean isShowAttributes() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowAttributes();
    }

    public void setShowEmptyAttributes(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowEmptyAttributes(value);
        this.internalRefreshTree();
    }

    public boolean isShowEmptyAttributes() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowEmptyAttributes();
    }

    public void setFontSizeDelta(int value) {
        this.browserConfiguration.getAppearanceConfiguration().setFontSizeDelta(value);
        this.setupPreferredFont();
    }

    public int getFontSizeDelta() {
        return this.browserConfiguration.getAppearanceConfiguration().getFontSizeDelta();
    }

    public void setShowOrdering(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowOrdering(value);
        this.internalRefreshTree();
    }

    public boolean isShowOrdering() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowOrdering();
    }

    public void setShowTypeOfLinks(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowTypeOfLinks(value);
        this.internalRefreshTree();
    }

    public boolean isShowTypeOfLinks() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowTypeOfLinks();
    }

    public void setShowElementIDs(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowElementIDs(value);
        this.internalRefreshTree();
    }

    public boolean isShowElementIDs() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowElementIDs();
    }

    public void setShowURI(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowURI(value);
        this.internalRefreshTree();
    }

    public boolean isShowURI() {
        return this.browserConfiguration.getAppearanceConfiguration().isShowURI();
    }

    public void showOnlyInstancesPanel() {
        this.sashForm.setSashWidth(0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.sashForm.setWeights(nArray);
    }

    public void showOnlyTypesPanel() {
        this.sashForm.setSashWidth(0);
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.sashForm.setWeights(nArray);
    }

    public void showBothPanels() {
        this.sashForm.setSashWidth(4);
        this.sashForm.setWeights(new int[]{35, 65});
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = this.getPropertySheetPage();
            }
            return this.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    EcoreBrowser.this.setSelectionToViewer(selection);
                    EcoreBrowser.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    EcoreBrowser.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }

                public void selectionChanged(IWorkbenchPart part, ISelection selection0) {
                    ISelection selection = EcoreBrowser.this.getEditorSelection();
                    boolean selectionNotified = false;
                    if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).toArray().length == 1) {
                        Object objSelected = ((IStructuredSelection)selection).getFirstElement();
                        if (objSelected instanceof ModelElementItem) {
                            ModelElementItem modelElementItem = (ModelElementItem)objSelected;
                            super.selectionChanged(part, (ISelection)new StructuredSelection((Object)modelElementItem.getEObject()));
                            selectionNotified = true;
                        } else if (objSelected instanceof AttributeItem) {
                            super.selectionChanged(part, (ISelection)new StructuredSelection((Object)((AttributeItem)objSelected).getParent()));
                            selectionNotified = true;
                        } else if (objSelected instanceof LinkItem) {
                            super.selectionChanged(part, (ISelection)new StructuredSelection((Object)((LinkItem)objSelected).getParent()));
                            selectionNotified = true;
                        }
                    }
                    if (!selectionNotified) {
                        super.selectionChanged(part, (ISelection)StructuredSelection.EMPTY);
                    }
                }
            };
            if (this.propertySheetPage instanceof PropertySheetPage) {
                ((PropertySheetPage)this.propertySheetPage).setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactoryWithRegistry){

                    protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
                        return new PropertySource(object, itemPropertySource){

                            protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
                                return new PropertyDescriptor(this.object, itemPropertyDescriptor);
                            }
                        };
                    }
                });
            }
        }
        return this.propertySheetPage;
    }

    public boolean isDirty() {
        if (this.isReadOnly()) {
            return false;
        }
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.isReadOnly()) {
            return;
        }
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : EcoreBrowser.this.editingDomain.getResourceSet().getResources()) {
                    URI uri = resource.getURI();
                    if (!first && resource.getContents().isEmpty() && !EcoreBrowser.this.isPersisted(resource) || EcoreBrowser.this.editingDomain.isReadOnly(resource) || uri == null || !uri.isPlatformResource() && !uri.isFile()) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            EcoreBrowser.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception e) {
                        Logger.logError((Throwable)e, (Plugin)BrowserPlugin.getPlugin());
                        DialogUtils.openErrorDialog((Shell)EcoreBrowser.this.getSite().getShell(), (Throwable)e, (String)Messages.EcoreBrowser_errorSavingResource);
                        EcoreBrowser.this.resourceToDiagnosticMap.put(resource, EcoreBrowser.this.analyzeResourceProblems(resource, e));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            BrowserPlugin.getPlugin().log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        Object progressMonitor = statusLineManager != null ? statusLineManager.getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public boolean isSaveAsAllowed() {
        return !this.isReadOnly();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        try {
            this.setSite((IWorkbenchPartSite)site);
            this.setInputWithNotify(editorInput);
            this.setPartName(editorInput.getName());
            site.setSelectionProvider((ISelectionProvider)this);
            site.getPage().addPartListener(this.partListener);
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)BrowserPlugin.getPlugin());
        }
    }

    public void setFocus() {
        if (this.openModelJob == null) {
            this.openModelJob = new Job(Messages.EcoreBrowser_jobOpeningModelInEmfFacetBrowser){

                protected IStatus run(IProgressMonitor monitor) {
                    boolean result = EcoreBrowser.this.backgroundOpenModel(monitor);
                    if (result) {
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            this.openModelJob.setPriority(30);
            this.openModelJob.schedule();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return BrowserUtils.unwrapSelection(this.editorSelection);
    }

    public ISelection getEditorSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            if (listener instanceof IBrowserSelectionChangedListener) {
                listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                continue;
            }
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, BrowserUtils.unwrapSelection(selection)));
        }
        this.setStatusLineMessage(selection);
    }

    private void hookViewerToSelection(Viewer viewer) {
        if (viewer == null) {
            return;
        }
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    EcoreBrowser.this.setSelection(selectionChangedEvent.getSelection());
                }
            };
        }
        viewer.addSelectionChangedListener(this.selectionChangedListener);
        this.setSelection(viewer.getSelection());
    }

    public void setStatusLineMessage(ISelection selection) {
        block5: {
            IStatusLineManager statusLineManager;
            block6: {
                statusLineManager = this.getActionBars().getStatusLineManager();
                if (statusLineManager == null) break block5;
                if (!(selection instanceof IStructuredSelection)) break block6;
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(Messages.EcoreBrowser_noObjectSelected);
                        break;
                    }
                    case 1: {
                        Object object = collection.iterator().next();
                        if (object instanceof ITreeElement) {
                            ITreeElement treeElement = (ITreeElement)object;
                            statusLineManager.setMessage(NLS.bind((String)Messages.EcoreBrowser_singleObjectSelected, (Object)treeElement.getText()));
                            break;
                        }
                        break block5;
                    }
                    default: {
                        statusLineManager.setMessage(NLS.bind((String)Messages.EcoreBrowser_multiObjectSelected, (Object)Integer.toString(collection.size())));
                        break;
                    }
                }
                break block5;
            }
            statusLineManager.setMessage("");
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public BrowserActionBarContributor getActionBarContributor() {
        return (BrowserActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public void dispose() {
        this.stopOpeningModel();
        this.disposing = true;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactoryWithRegistry.dispose();
        this.sashForm.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.treeViewer != null && this.selectionChangedListener != null) {
            this.treeViewer.removeSelectionChangedListener(this.selectionChangedListener);
            this.selectionChangedListener = null;
        }
        this.browserConfiguration.getAppearanceConfiguration().setCustomFont(null);
        this.browserConfiguration.getAppearanceConfiguration().setCustomItalicFont(null);
        this.browserConfiguration.dispose();
        JFaceResources.getFontRegistry().removeListener(this.fontChangeListener);
        this.customTreePainter.dispose();
        this.browserConfiguration.getAppearanceConfiguration().getCustomizationEngine().dispose();
        this.fCustomizationEngineChangeListener = null;
        FacetSetCatalog.getSingleton().removeChangeListener(this.fFacetsChangeListener);
        this.fFormToolkit.dispose();
        Set<Resource> browsedResources = this.browserConfiguration.getBrowsedResources();
        if (browsedResources != null) {
            for (Resource resource : browsedResources) {
                ListIterator listIterator = resource.eAdapters().listIterator();
                while (listIterator.hasNext()) {
                    MetaclassInstancesAdapterWithFacet adapterWithFacet;
                    Adapter adapter = (Adapter)listIterator.next();
                    if (!(adapter instanceof MetaclassInstancesAdapterWithFacet) || (adapterWithFacet = (MetaclassInstancesAdapterWithFacet)adapter).getFacetContext() != this.getBrowserConfiguration().getAppearanceConfiguration().getFacetContext()) continue;
                    listIterator.remove();
                }
            }
        }
        MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(null);
        super.dispose();
    }

    private void stopOpeningModel() {
        if (this.openModelJob != null && this.openModelJob.getState() == 4) {
            this.openModelJob.cancel();
            Thread thread = this.openModelJob.getThread();
            if (thread != null) {
                thread.stop();
            }
        }
    }

    public void browse() {
        ITreeSelection treeSelection;
        Object selectedElement;
        ISelection selection = this.getEditorSelection();
        if (selection instanceof ITreeSelection && (selectedElement = (treeSelection = (ITreeSelection)selection).getFirstElement()) instanceof ModelElementItem) {
            ModelElementItem modelElementItem = (ModelElementItem)selectedElement;
            this.browseTo(modelElementItem);
        }
    }

    public void browseTo(ModelElementItem modelElementItem) {
        EObject modelElement = modelElementItem.getEObject();
        this.browseTo(modelElement);
    }

    public void browseTo(EObject modelElement) {
        this.browseTo(modelElement, modelElement.eClass());
    }

    public void browseTo(EObject modelElement, EClass eClass) {
        this.markNavigationLocation();
        this.metaclassViewer.selectMetaclass(eClass);
        TreePath treePath = this.findTreePathForElement(modelElement);
        if (treePath != null) {
            this.treeViewer.setSelection(null);
            this.treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
            this.markNavigationLocation();
        }
    }

    public void browseToByURI(String uriFragment) {
        EObject eObject = EMFUtil.findElementByURI((String)uriFragment, (ResourceSet)this.fResourceSet);
        if (eObject != null) {
            this.browseTo(eObject);
        }
    }

    private TreePath findTreePathForElement(EObject eObject) {
        Object input = this.treeViewer.getInput();
        if (input instanceof MetaclassList) {
            MetaclassList metaclassListItemProvider = (MetaclassList)input;
            Collection<?> elements = metaclassListItemProvider.getElements();
            for (Object element : elements) {
                ModelElementItem other;
                if (element instanceof BigListItem) {
                    BigListItem bigListItemProvider = (BigListItem)element;
                    List subElements = bigListItemProvider.getChildren();
                    for (Object subElement : subElements) {
                        ModelElementItem other2;
                        if (!(subElement instanceof ModelElementItem) || !(other2 = (ModelElementItem)subElement).getEObject().equals(eObject)) continue;
                        return new TreePath(new Object[]{subElement});
                    }
                }
                if (!(element instanceof ModelElementItem) || !(other = (ModelElementItem)element).getEObject().equals(eObject)) continue;
                return new TreePath(new Object[]{element});
            }
        }
        return null;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new BrowserNavigationLocation((IEditorPart)this);
    }

    public INavigationLocation createNavigationLocation() {
        EClass firstSelectedMetaclass = this.metaclassViewer.getFirstSelectedMetaclass();
        return new BrowserNavigationLocation((IEditorPart)this, firstSelectedMetaclass, (ITreeSelection)this.treeViewer.getSelection());
    }

    protected void markNavigationLocation() {
        this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
    }

    public void restoreLocation(EClass eClass, ITreeSelection selection) {
        this.metaclassViewer.selectMetaclass(eClass);
        this.treeViewer.setSelection((ISelection)selection);
    }

    public void refreshDelayed(final boolean metaclassViewerToo) {
        if (this.disposing) {
            return;
        }
        if (this.refreshJob == null) {
            this.refreshJob = new Job(Messages.EcoreBrowser_refreshingModelViewers){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            EcoreBrowser.this.internalRefreshTree();
                            if (metaclassViewerToo) {
                                EcoreBrowser.this.getMetaclassViewer().refresh();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        } else {
            this.refreshJob.cancel();
        }
        this.refreshJob.setPriority(10);
        this.refreshJob.schedule();
    }

    public void clearInstancesCache() {
        AppearanceConfiguration appearanceConfiguration = this.browserConfiguration.getAppearanceConfiguration();
        MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(appearanceConfiguration.getFacetContext());
        Set<Resource> browsedResources = this.browserConfiguration.getBrowsedResources();
        if (browsedResources != null) {
            for (Resource resource : browsedResources) {
                MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
                instances.clearCache();
            }
        }
    }

    private void internalRefreshTree() {
        if (!this.treeViewer.getTree().isDisposed()) {
            try {
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.refresh();
            }
            finally {
                this.treeViewer.getTree().setRedraw(true);
            }
        }
    }

    public BrowserConfiguration getBrowserConfiguration() {
        return this.browserConfiguration;
    }

    private void openPropertiesView() {
        try {
            this.getEditorSite().getPage().showView(PROPERTY_VIEW_ID);
        }
        catch (PartInitException e) {
            BrowserPlugin.logException(e);
        }
    }

    public ResourceSet getResourceSet() {
        return this.getEditingDomain().getResourceSet();
    }

    public void loadCustomizations(List<MetamodelView> customizationsToLoad) {
        CustomizationEngine customizationEngine = this.browserConfiguration.getAppearanceConfiguration().getCustomizationEngine();
        if (this.fCustomizationEngineChangeListener == null) {
            this.fCustomizationEngineChangeListener = new ChangeListener(){

                public void changed() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            EcoreBrowser.this.refreshDelayed(true);
                        }
                    });
                }
            };
            customizationEngine.addChangeListener(this.fCustomizationEngineChangeListener);
        }
        customizationEngine.clear();
        for (MetamodelView customizationToLoad : customizationsToLoad) {
            customizationEngine.registerCustomization(customizationToLoad);
        }
        customizationEngine.loadCustomizations();
    }

    private void loadDefaultCustomizations() {
        this.loadCustomizations(CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations());
    }

    protected TreeToolBar getInstancesToolBar() {
        return this.instancesToolBar;
    }

    protected void reloadOnFacetChange() {
        if (this.fFacetsChangeListener == null) {
            this.fFacetsChangeListener = new AbstractEmfFacetCatalog.EmfFacetCatalogChangeListener(){

                private void changed() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ArrayList<String> facetsToReload = new ArrayList<String>();
                            Set loadedFacets = EcoreBrowser.this.getBrowserConfiguration().getAppearanceConfiguration().getLoadedFacets();
                            for (Facet facet : loadedFacets) {
                                FacetSet facetSet = facet.getFacetSet();
                                facetsToReload.add(String.valueOf(facetSet.getName()) + "#" + facet.getName());
                            }
                            EcoreBrowser.this.getBrowserConfiguration().getAppearanceConfiguration().clearFacets();
                            Collection allFacetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
                            for (FacetSet facetSet : allFacetSets) {
                                EList facets = facetSet.getFacets();
                                block2: for (Facet facet : facets) {
                                    for (String fullname : facetsToReload) {
                                        if (!fullname.equals(String.valueOf(facetSet.getName()) + "#" + facet.getName())) continue;
                                        EcoreBrowser.this.getBrowserConfiguration().getAppearanceConfiguration().loadFacet(facet);
                                        continue block2;
                                    }
                                }
                            }
                            EcoreBrowser.this.getBrowserConfiguration().getInstancesForMetaclasses().buildDerivationTree();
                        }
                    });
                }

                public void removed(IFile file) {
                    this.changed();
                }

                public void changed(EObject eObject, IFile file) {
                    this.changed();
                }

                public void added(EObject eObject, IFile file) {
                    this.changed();
                }
            };
            FacetSetCatalog.getSingleton().addChangeListener(this.fFacetsChangeListener);
        }
    }

    @Override
    public void modelChanged() {
        this.getBrowserConfiguration().getAppearanceConfiguration().touch();
        this.refreshDelayed(true);
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getEditorSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.UI_FileConflict_label, (String)Messages.WARN_FileConflict);
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    Logger.logError((Throwable)e, (Plugin)BrowserPlugin.getPlugin());
                    DialogUtils.openErrorDialog((Shell)this.getSite().getShell(), (Throwable)e, (String)Messages.EcoreBrowser_errorLoadingResource);
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, e));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.facet.infra.browser", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        BrowserPlugin.getPlugin().log((Object)exception);
                    }
                }
            }
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            Object errorData = exception == null ? resource : exception;
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.facet.infra.browser", 0, NLS.bind((String)Messages.UI_ErrorFile_message, (Object)resource.getURI()), new Object[]{errorData});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.emf.facet.infra.browser", 0, NLS.bind((String)Messages.UI_ErrorFile_message, (Object)resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void initializeEditingDomain() {
        if (this.editingDomain == null) {
            this.adapterFactoryWithRegistry = new BrowserAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.adapterFactoryWithRegistry.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            this.adapterFactoryWithRegistry.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            ReadOnlyCommandStack commandStack = this.isReadOnly() ? new ReadOnlyCommandStack() : new BasicCommandStack();
            commandStack.addCommandStackListener(new CommandStackListener(){

                public void commandStackChanged(final EventObject event) {
                    Composite composite = EcoreBrowser.this.getParentComposite();
                    if (composite.isDisposed()) {
                        return;
                    }
                    composite.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IPropertySheetPage page;
                            EcoreBrowser.this.firePropertyChange(257);
                            final Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                            if (mostRecentCommand != null) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        try {
                                            EcoreBrowser.this.treeViewer.getTree().setRedraw(false);
                                            EcoreBrowser.this.selectAffectedElements(mostRecentCommand);
                                        }
                                        finally {
                                            EcoreBrowser.this.treeViewer.getTree().setRedraw(true);
                                        }
                                    }
                                });
                            }
                            if ((page = EcoreBrowser.this.getPropertySheetPage()) != null && page.getControl() != null && !page.getControl().isDisposed()) {
                                TabbedPropertySheetPage tabbedPropertyPage;
                                if (page instanceof PropertySheetPage) {
                                    PropertySheetPage propertyPage = (PropertySheetPage)page;
                                    propertyPage.refresh();
                                } else if (page instanceof TabbedPropertySheetPage && (tabbedPropertyPage = (TabbedPropertySheetPage)page).getCurrentTab() != null) {
                                    tabbedPropertyPage.refresh();
                                }
                            }
                        }
                    });
                }
            });
            this.setEditingDomain(new BrowserEditingDomain(this.adapterFactoryWithRegistry, commandStack, new HashMap<Resource, Boolean>(), this));
        }
    }

    protected void setEditingDomain(AdapterFactoryEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void gotoMarker(IMarker marker) {
        try {
            URI uri;
            EObject eObject;
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null && (eObject = this.fResourceSet.getEObject(uri = URI.createURI((String)uriAttribute), true)) != null) {
                this.browseTo(eObject);
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)BrowserPlugin.getPlugin());
        }
    }

    public Composite getParentComposite() {
        return this.parentComposite;
    }

    public EditingDomain getEditingDomain() {
        this.initializeEditingDomain();
        return this.editingDomain;
    }

    public Collection<Resource> getSavedResources() {
        return this.savedResources;
    }

    public Collection<Resource> getChangedResources() {
        return this.changedResources;
    }

    public Collection<Resource> getRemovedResources() {
        return this.removedResources;
    }

    public boolean isReadOnly() {
        return !(this.getEditorInput() instanceof FileEditorInput);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setStyleSashForm(int styleSashForm) {
        this.styleSashForm = styleSashForm;
    }

    protected void selectAffectedElements(Command command) {
        if (command instanceof DragAndDropOnLinkCommand) {
            DragAndDropOnLinkCommand dragAndDropOnLinkCommand = (DragAndDropOnLinkCommand)command;
            Command dropCommand = dragAndDropOnLinkCommand.getDropCommand();
            this.selectAffectedElements(dropCommand, null, dragAndDropOnLinkCommand.getLinkItem());
        } else if (command instanceof DragAndDropOnModelElementCommand) {
            DragAndDropOnModelElementCommand dragAndDropOnModelElementCommand = (DragAndDropOnModelElementCommand)command;
            Command dropCommand = dragAndDropOnModelElementCommand.getDropCommand();
            this.selectAffectedElements(dropCommand, dragAndDropOnModelElementCommand.getModelElementItem(), null);
        } else if (this.editingDomain instanceof BrowserEditingDomain) {
            BrowserEditingDomain browserEditingDomain = (BrowserEditingDomain)this.editingDomain;
            Object selectedElementForCommand = browserEditingDomain.getEditorSelectionForCommand(command);
            if (selectedElementForCommand instanceof ModelElementItem) {
                ModelElementItem selectedModelElementItem = (ModelElementItem)selectedElementForCommand;
                this.selectAffectedElements(command, selectedModelElementItem, null);
            } else if (selectedElementForCommand instanceof LinkItem) {
                LinkItem linkItem = (LinkItem)selectedElementForCommand;
                this.selectAffectedElements(command, (ModelElementItem)linkItem.getTreeParent(), linkItem);
            }
        }
    }

    private void selectAffectedElements(Command command, ModelElementItem contextModelElementItem, LinkItem contextLinkItem) {
        if (command instanceof AddCommand) {
            AddCommand addCommand = (AddCommand)command;
            if (contextLinkItem != null) {
                boolean result = this.selectElements(contextLinkItem, addCommand.getCollection());
                if (!result) {
                    this.setSelection(Collections.singletonList(contextLinkItem), true);
                    this.treeViewer.expandToLevel((Object)contextLinkItem, 1);
                }
            } else if (contextModelElementItem != null) {
                this.selectElements(contextModelElementItem, addCommand.getFeature(), addCommand.getCollection());
            } else {
                this.selectElements(addCommand.getOwner(), addCommand.getFeature(), addCommand.getCollection());
            }
        } else if (command instanceof SetCommand) {
            SetCommand setCommand = (SetCommand)command;
            if (contextModelElementItem != null) {
                boolean result = this.selectElements(contextModelElementItem, setCommand.getFeature(), Collections.singleton(setCommand.getValue()));
                if (!result) {
                    ITreeElement treeParent = contextModelElementItem.getTreeParent();
                    this.setSelection(Collections.singletonList(treeParent), true);
                    this.treeViewer.expandToLevel((Object)treeParent, 1);
                }
            } else {
                this.selectElements(setCommand.getOwner(), setCommand.getFeature(), Collections.singleton(setCommand.getValue()));
            }
        } else if (command instanceof CreateChildCommand) {
            CreateChildCommand createChildCommand = (CreateChildCommand)command;
            Command command2 = createChildCommand.getCommand();
            this.selectAffectedElements(command2, contextModelElementItem, contextLinkItem);
        } else if (command instanceof DeleteCommand) {
            DeleteCommand deleteCommand = (DeleteCommand)command;
            List commandList = deleteCommand.getCommandList();
            if (commandList.size() > 0) {
                this.selectAffectedElements((Command)commandList.get(0), contextModelElementItem, contextLinkItem);
            }
        } else if (command instanceof RemoveCommand) {
            RemoveCommand removeCommand = (RemoveCommand)command;
            LinkItem linkItem = null;
            if (contextModelElementItem != null) {
                ITreeElement parent = contextModelElementItem.getTreeParent();
                if (parent instanceof LinkItem) {
                    linkItem = (LinkItem)parent;
                } else if (parent instanceof ModelElementItem) {
                    ModelElementItem modelElementItem = (ModelElementItem)parent;
                    this.setSelection(Collections.singletonList(modelElementItem), true);
                    return;
                }
            }
            if (linkItem == null) {
                this.browseTo(removeCommand.getOwner());
                ModelElementItem modelElementItem = this.getSelectedModelElementItem();
                linkItem = this.getLink(modelElementItem, removeCommand.getFeature());
            }
            if (linkItem != null) {
                this.treeViewer.expandToLevel((Object)linkItem, 1);
                this.setSelection(Collections.singletonList(linkItem), true);
            }
        } else if (command instanceof CompoundCommand) {
            CompoundCommand compoundCommand = (CompoundCommand)command;
            List commandList = compoundCommand.getCommandList();
            if (commandList.size() > 0) {
                this.selectAffectedElements((Command)commandList.get(commandList.size() - 1), contextModelElementItem, contextLinkItem);
            }
        } else if (command instanceof CommandWrapper) {
            CommandWrapper commandWrapper = (CommandWrapper)command;
            this.selectAffectedElements(commandWrapper.getCommand(), contextModelElementItem, contextLinkItem);
        }
    }

    protected void selectElements(EObject owner, EStructuralFeature feature, Collection<?> collection) {
        this.browseTo(owner);
        ModelElementItem modelElementItem = this.getSelectedModelElementItem();
        this.selectElements(modelElementItem, feature, collection);
    }

    protected boolean selectElements(ModelElementItem modelElementItem, EStructuralFeature feature, Collection<?> collection) {
        LinkItem linkItem;
        if (modelElementItem != null && (linkItem = this.getLink(modelElementItem, feature)) != null) {
            boolean result = this.selectElements(linkItem, collection);
            if (!result) {
                this.setSelection(Collections.singletonList(linkItem), true);
                this.treeViewer.expandToLevel((Object)linkItem, 1);
            }
            return true;
        }
        return false;
    }

    protected boolean selectElements(LinkItem linkItem, Collection<?> collection) {
        ArrayList<ModelElementItem> elementItems = new ArrayList<ModelElementItem>();
        for (Object object : collection) {
            EObject eObject;
            ModelElementItem elementItem;
            if (!(object instanceof EObject) || (elementItem = this.getElement(linkItem, eObject = (EObject)object)) == null) continue;
            elementItems.add(elementItem);
        }
        if (!elementItems.isEmpty()) {
            this.setSelection(elementItems, true);
            return true;
        }
        return false;
    }

    protected void setSelection(List<? extends ITreeElement> treeElements, boolean reveal) {
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        for (ITreeElement iTreeElement : treeElements) {
            ArrayList<ITreeElement> segments = new ArrayList<ITreeElement>();
            ITreeElement current = iTreeElement;
            while (current != null) {
                segments.add(current);
                current = current.getTreeParent();
            }
            if (segments.size() <= 0) continue;
            Object[] segmentsArray = new ITreeElement[segments.size()];
            int i = 0;
            while (i < segments.size()) {
                segmentsArray[i] = (ITreeElement)segments.get(segments.size() - i - 1);
                ++i;
            }
            treePaths.add(new TreePath(segmentsArray));
        }
        if (!treePaths.isEmpty()) {
            this.treeViewer.setSelection((ISelection)new TreeSelection(treePaths.toArray(new TreePath[treePaths.size()])), reveal);
        }
    }

    protected LinkItem getLink(ModelElementItem selectedModelElementItem, EStructuralFeature feature) {
        Object[] children;
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object[] objectArray = children = contentProvider.getChildren((Object)selectedModelElementItem);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            LinkItem linkItem;
            Object child = objectArray[n2];
            if (child instanceof LinkItem && (linkItem = (LinkItem)child).getReference() == feature) {
                return linkItem;
            }
            ++n2;
        }
        return null;
    }

    protected ModelElementItem getElement(LinkItem linkItem, EObject eObject) {
        Object[] children;
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object[] objectArray = children = contentProvider.getChildren((Object)linkItem);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ModelElementItem modelElementItem;
            Object child = objectArray[n2];
            if (child instanceof ModelElementItem && EcoreUtil.getURI((EObject)(modelElementItem = (ModelElementItem)child).getEObject()).equals((Object)EcoreUtil.getURI((EObject)eObject))) {
                return modelElementItem;
            }
            ++n2;
        }
        return null;
    }

    protected ModelElementItem getSelectedModelElementItem() {
        ITreeSelection selection = (ITreeSelection)this.treeViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof ModelElementItemEx) {
            ModelElementItemEx modelElementItem = (ModelElementItemEx)((Object)firstElement);
            return modelElementItem;
        }
        return null;
    }

    class BrowserAdapterFactory
    extends ComposedAdapterFactory
    implements IEditingDomainProvider {
        public BrowserAdapterFactory(ComposedAdapterFactory.Descriptor.Registry registry) {
            super(registry);
        }

        public EditingDomain getEditingDomain() {
            return EcoreBrowser.this.getEditingDomain();
        }
    }

    private final class MetaclassListViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private final HashMap<EClass, ITreeSelection> selections = new HashMap();
        private EClass lastSelectedMetaclass = null;

        private MetaclassListViewerSelectionChangedListener() {
        }

        private InstancesForMetaclass[] getEntriesForSelection(ISelection selection) {
            ArrayList<InstancesForMetaclass> instancesForMetaclasses = new ArrayList<InstancesForMetaclass>();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object element : structuredSelection) {
                    if (!(element instanceof InstancesForMetaclass)) continue;
                    InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                    instancesForMetaclasses.add(instancesForMetaclass);
                }
            }
            return instancesForMetaclasses.toArray(new InstancesForMetaclass[instancesForMetaclasses.size()]);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.lastSelectedMetaclass != null) {
                this.selections.put(this.lastSelectedMetaclass, (ITreeSelection)EcoreBrowser.this.treeViewer.getSelection());
            }
            ISelection metaclassSelection = event.getSelection();
            InstancesForMetaclass[] entries = this.getEntriesForSelection(metaclassSelection);
            ITreeSelection savedSelection = null;
            MetaclassList input = null;
            if (entries.length > 0) {
                savedSelection = this.selections.get(entries[0].getEClass());
                EClass[] selectedMetaclasses = new EClass[entries.length];
                int i = 0;
                InstancesForMetaclass[] instancesForMetaclassArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    InstancesForMetaclass entry = instancesForMetaclassArray[n2];
                    selectedMetaclasses[i++] = entry.getEClass();
                    ++n2;
                }
                input = new MetaclassList(EcoreBrowser.this.browserConfiguration, selectedMetaclasses);
                this.lastSelectedMetaclass = entries[0].getEClass();
            } else {
                this.lastSelectedMetaclass = null;
            }
            try {
                EcoreBrowser.this.treeViewer.getTree().setRedraw(false);
                if (EcoreBrowser.this.searchBox != null) {
                    EcoreBrowser.this.searchBox.setText("");
                }
                EcoreBrowser.this.treeViewer.setSelection(null);
                EcoreBrowser.this.treeViewer.setInput(input);
                EcoreBrowser.this.savedInput = input;
                EcoreBrowser.this.treeViewer.setSelection((ISelection)savedSelection, true);
            }
            finally {
                EcoreBrowser.this.treeViewer.getTree().setRedraw(true);
            }
            EcoreBrowser.this.markNavigationLocation();
        }
    }
}

