/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.editors;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.infra.browser.BrowserPlugin;
import org.eclipse.emf.facet.infra.browser.editors.EcoreBrowser;
import org.eclipse.emf.facet.infra.common.core.internal.utils.UriUtils;
import org.eclipse.ui.IEditorPart;

public class WorkspaceChangeListener
implements IResourceChangeListener {
    private final EcoreBrowser fBrowser;

    public WorkspaceChangeListener(EcoreBrowser browser) {
        this.fBrowser = browser;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta eventDelta = event.getDelta();
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                private final ResourceSet resourceSet;
                private final Collection<Resource> changedResourcesDelta;
                private final Collection<Resource> removedResourcesDelta;

                ResourceDeltaVisitor() {
                    this.resourceSet = WorkspaceChangeListener.this.fBrowser.getEditingDomain().getResourceSet();
                    this.changedResourcesDelta = new ArrayList<Resource>();
                    this.removedResourcesDelta = new ArrayList<Resource>();
                }

                public boolean visit(IResourceDelta deltaResource) {
                    String resourcePath;
                    Resource resource;
                    if (deltaResource.getResource().getType() == 1 && (deltaResource.getKind() == 2 || deltaResource.getKind() == 4 && deltaResource.getFlags() != 131072) && (resource = this.resourceSet.getResource(UriUtils.createUri((String)(resourcePath = deltaResource.getFullPath().toString())), false)) != null) {
                        if (deltaResource.getKind() == 2) {
                            this.removedResourcesDelta.add(resource);
                        } else if (!WorkspaceChangeListener.this.fBrowser.getSavedResources().remove(resource)) {
                            this.changedResourcesDelta.add(resource);
                        }
                    }
                    return true;
                }

                public Collection<Resource> getChangedResources() {
                    return this.changedResourcesDelta;
                }

                public Collection<Resource> getRemovedResources() {
                    return this.removedResourcesDelta;
                }
            }
            final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            eventDelta.accept((IResourceDeltaVisitor)visitor);
            if (!visitor.getRemovedResources().isEmpty()) {
                this.fBrowser.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                    {
                    }

                    public void run() {
                        WorkspaceChangeListener.this.fBrowser.getRemovedResources().addAll(visitor.getRemovedResources());
                        if (!WorkspaceChangeListener.this.fBrowser.isDirty()) {
                            WorkspaceChangeListener.this.fBrowser.getSite().getPage().closeEditor((IEditorPart)WorkspaceChangeListener.this.fBrowser, false);
                        }
                    }
                });
            }
            if (!visitor.getChangedResources().isEmpty()) {
                this.fBrowser.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                    {
                    }

                    public void run() {
                        WorkspaceChangeListener.this.fBrowser.getChangedResources().addAll(visitor.getChangedResources());
                        if (WorkspaceChangeListener.this.fBrowser.getSite().getPage().getActiveEditor() == WorkspaceChangeListener.this.fBrowser) {
                            WorkspaceChangeListener.this.fBrowser.handleActivate();
                        }
                    }
                });
            }
        }
        catch (CoreException exception) {
            BrowserPlugin.logException(exception);
        }
    }
}

