/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditingSupportUtil {
    private EditingSupportUtil() {
    }

    public static Collection<?> getNewChildDescriptors(List<EReference> eAllReferences) {
        ArrayList<CommandParameter> parameters = new ArrayList<CommandParameter>();
        for (EReference reference : eAllReferences) {
            if (!reference.isContainment()) continue;
            EditingSupportUtil.createCommandParameters(parameters, reference);
        }
        return parameters;
    }

    public static void createCommandParameters(List<CommandParameter> parameters, EReference feature) {
        EClass featureClass = feature.getEReferenceType();
        if (!featureClass.isInterface() && !featureClass.isAbstract()) {
            parameters.add(new CommandParameter(null, (Object)feature, (Object)featureClass.getEPackage().getEFactoryInstance().create(featureClass)));
        }
        EList<EClass> eclasses = EditingSupportUtil.allSubClasses(feature.getEReferenceType());
        for (EClass eclass : eclasses) {
            if (eclass.isAbstract()) continue;
            parameters.add(new CommandParameter(null, (Object)feature, (Object)eclass.getEPackage().getEFactoryInstance().create(eclass)));
        }
    }

    public static EList<EClass> allSubClasses(EClass context) {
        BasicEList result = new BasicEList();
        BasicEList resources = new BasicEList();
        if (context.eResource().getResourceSet() != null) {
            resources.addAll((Collection)context.eResource().getResourceSet().getResources());
        } else {
            resources.add((Object)context.eResource());
        }
        for (Resource resource : resources) {
            TreeIterator content = resource.getAllContents();
            while (content.hasNext()) {
                EClass currentClassDeclaration;
                EObject eObject = (EObject)content.next();
                if (!(eObject instanceof EClass) || !EditingSupportUtil.isSuperTypeOf(context, currentClassDeclaration = (EClass)eObject)) continue;
                result.add((Object)currentClassDeclaration);
            }
        }
        return result;
    }

    public static boolean isSuperTypeOf(EClass self, EClass typeDeclaration) {
        return typeDeclaration.getEAllSuperTypes().contains((Object)self);
    }
}

