/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grégoire Dupé (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.common.core.internal.builder;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;


/**
 * @author Grégoire Dupé (Mia-Software)
 */
public class EcoreBuilder extends EmfFacetCatalogBuilder {

	public static final String FILE_EXTENSION = "ecore"; //$NON-NLS-1$

	@Override
	protected AbstractEmfFacetCatalog getCatalog() {
		return EcoreCatalog.getSingleton();
	}

	@Override
	protected String getElementType() {
		return null;
	}

	@Override
	protected String getRegistrationExtensionPoint() {
		return null;
	}

	@Override
	protected String getMarkerType() {
		return null;
	}

	@Override
	protected String getFileExtension() {
		return EcoreBuilder.FILE_EXTENSION;
	}

	@Override
	protected Plugin getActivator() {
		return CommonEmfFacetActivator.getDefault();
	}

}
