/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gregoire Dupe (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.common.core.internal.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;
import org.eclipse.emf.facet.infra.common.core.logging.Logger;

/**
 * @author Gregoire Dupe
 */
public class EmfFacetResourceListenerGroup {

	private final Map<IEmfFacetResourceListener, HashSet<URI>> listeners = new HashMap<IEmfFacetResourceListener, HashSet<URI>>();
	private final URI watchedResourceUri;

	public EmfFacetResourceListenerGroup(final URI watchedResourceUri) {
		this.watchedResourceUri = watchedResourceUri;
		if (EmfFacetResourceSet.DEBUG) {
			String message = this.getClass().getSimpleName()
					+ "." + this.getClass().getSimpleName() + "(): " //$NON-NLS-1$ //$NON-NLS-2$
				+ this.watchedResourceUri;
			System.out.println(message);
			// IStatus status = new Status(IStatus.INFO,
			// CommonEmfFacetActivator.PLUGIN_ID, message);
			// CommonEmfFacetActivator.getDefault().getLog().log(status);
		}
	}

	public void notifyChange() {
		if (EmfFacetResourceSet.DEBUG) {
			String message = this.getClass().getSimpleName()
					+ ".notifyChange(): " + this.watchedResourceUri //$NON-NLS-1$
					+ " nbListeners=" + this.listeners.size(); //$NON-NLS-1$
			System.out.println(message);
			// IStatus status = new Status(IStatus.INFO,
			// CommonEmfFacetActivator.PLUGIN_ID, message);
			// CommonEmfFacetActivator.getDefault().getLog().log(status);
		}
		List<Runnable> toDoList = new ArrayList<Runnable>();
		for (IEmfFacetResourceListener listener : this.listeners.keySet()) {
			final IEmfFacetResourceListener fListener = listener;
			for (URI clientUri : this.listeners.get(listener)) {
				final URI fClientURI = clientUri;
				Runnable toDo = new Runnable() {
					public void run() {
						try {
							if (EmfFacetResourceSet.DEBUG) {
								System.out
										.println(EmfFacetResourceListenerGroup.this.getClass()
												.getSimpleName()
												+ ".notifyChange(): aListenedResourceHasChanged(changed=" + EmfFacetResourceListenerGroup.this.watchedResourceUri + ", depending=" + fClientURI + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							}
							fListener.aListenedResourceHasChanged(
									EmfFacetResourceListenerGroup.this.watchedResourceUri,
									fClientURI);
						} catch (Exception e) {
							Logger
									.logError(
											e,
											"An exception happened while notifying change of: " //$NON-NLS-1$
											+ EmfFacetResourceListenerGroup.this.watchedResourceUri
											+ " to: " + fListener, CommonEmfFacetActivator //$NON-NLS-1$
													.getDefault());
						}
					}
				};
				toDoList.add(toDo);
			}
		}
		for (Runnable toDo : toDoList) {
			toDo.run();
		}
	}

	public void addListener(final IEmfFacetResourceListener listener, final URI resourceUri) {
		HashSet<URI> list = this.listeners.get(listener);
		if (list == null) {
			list = new HashSet<URI>();
			this.listeners.put(listener, list);
		}
		list.add(resourceUri);
	}

	public void remove(final IEmfFacetResourceListener listener, final URI dependingResource) {
		HashSet<URI> uriSet = this.listeners.get(listener);
		if (uriSet != null) {
			uriSet.remove(dependingResource);
		}
	}

}
