/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.ui.internal.controls;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.ui.internal.EmfFacetCommonUIPlugin;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class FormStyleSashForm
extends SashForm {
    private final ArrayList<Sash> fSashes = new ArrayList();
    private final FormToolkit formToolkit;
    private int minWidth = 0;
    private final Listener fListener = new Listener(){

        public void handleEvent(Event e) {
            switch (e.type) {
                case 6: {
                    e.widget.setData("hover", (Object)Boolean.TRUE);
                    ((Control)e.widget).redraw();
                    break;
                }
                case 7: {
                    e.widget.setData("hover", null);
                    ((Control)e.widget).redraw();
                    break;
                }
                case 9: {
                    FormStyleSashForm.this.onSashPaint(e);
                    break;
                }
                case 11: {
                    FormStyleSashForm.this.hookSashListeners();
                    break;
                }
                case 13: {
                    if (e.x >= FormStyleSashForm.this.minWidth) break;
                    e.x = FormStyleSashForm.this.minWidth;
                    break;
                }
                default: {
                    Logger.logWarning((String)"Unhandled event", (Plugin)EmfFacetCommonUIPlugin.getDefault());
                }
            }
        }
    };

    public FormStyleSashForm(Composite parent, int style, FormToolkit formToolkit) {
        super(parent, style);
        this.formToolkit = formToolkit;
        formToolkit.adapt((Control)this, false, false);
        this.createContents();
        this.hookListeners();
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    protected abstract void createContents();

    private void hookListeners() {
        Listener listener = this.fListener;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!(child instanceof Sash)) {
                child.addListener(11, listener);
            }
            ++n2;
        }
    }

    public void layout(boolean changed) {
        super.layout(changed);
        this.hookSashListeners();
    }

    public void layout(Control[] children) {
        super.layout(children);
        this.hookSashListeners();
    }

    void hookSashListeners() {
        this.purgeSashes();
        try {
            Sash[] allSashes;
            Sash[] sashArray = allSashes = this.getSashes();
            int n = allSashes.length;
            int n2 = 0;
            while (n2 < n) {
                Sash sash = sashArray[n2];
                if (!this.fSashes.contains(sash)) {
                    sash.addListener(9, this.fListener);
                    sash.addListener(6, this.fListener);
                    sash.addListener(7, this.fListener);
                    sash.addListener(13, this.fListener);
                    this.fSashes.add(sash);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)EmfFacetCommonUIPlugin.getDefault());
        }
    }

    private Sash[] getSashes() {
        try {
            Field sashesField = SashForm.class.getDeclaredField("sashes");
            sashesField.setAccessible(true);
            Sash[] allSashes = (Sash[])sashesField.get((Object)this);
            return allSashes;
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)EmfFacetCommonUIPlugin.getDefault());
            return new Sash[0];
        }
    }

    private void purgeSashes() {
        Iterator<Sash> iter = this.fSashes.iterator();
        while (iter.hasNext()) {
            Sash sash = iter.next();
            if (!sash.isDisposed()) continue;
            iter.remove();
        }
    }

    void onSashPaint(Event e) {
        Sash sash = (Sash)e.widget;
        FormColors colors = this.formToolkit.getColors();
        GC gc = e.gc;
        Boolean hover = (Boolean)sash.getData("hover");
        if (hover != null) {
            gc.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
            gc.setForeground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
            Point size = sash.getSize();
            gc.fillRectangle(0, 0, size.x, size.y);
        }
    }
}

