/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.common.ui.internal.EmfFacetCommonUIPlugin;
import org.eclipse.emf.facet.infra.common.ui.internal.Messages;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewProjectCreationOperation
extends WorkspaceModifyOperation {
    private IPath projectLocation = null;
    private IProject project = null;

    public NewProjectCreationOperation(IPath projectLocation, IProject projectToCreate) {
        this.projectLocation = projectLocation;
        this.project = projectToCreate;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask(Messages.NewProjectCreationOperation_EmfFacetProjectCreation, -1);
        if (!this.project.exists()) {
            IProjectDescription description = this.project.getWorkspace().newProjectDescription(this.project.getName());
            if (!Platform.getLocation().equals((Object)this.projectLocation)) {
                description.setLocation(this.projectLocation);
            }
            this.project.create(monitor);
            this.project.open(monitor);
            monitor.subTask(Messages.NewProjectCreationOperation_AddingJavaNature);
            ProjectUtils.configureAsJavaProject((IProject)this.project, (IProgressMonitor)monitor);
            monitor.subTask(Messages.NewProjectCreationOperation_AddingPluginNature);
            ProjectUtils.configureAsPluginProject((IProject)this.project);
            ProjectUtils.addNature((IProject)this.project, (IProgressMonitor)monitor, (String)"org.eclipse.emf.facet.common.ProjectNature");
            ProjectUtils.createBuildProperties((IProject)this.project);
        } else {
            Logger.logWarning((String)"EmfFacet project creation aborted: the project already exists", (Plugin)EmfFacetCommonUIPlugin.getDefault());
        }
        monitor.done();
    }
}

